/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MovedInvalidDateTime
extends GregorianCalendar {
    private static final long serialVersionUID = -5679469055375691334L;
    private int minutesMoved;
    private LocalHHMM originalTimeHHMM;

    public MovedInvalidDateTime(Calendar calendar, int n) {
        this(calendar);
        this.minutesMoved = n;
    }

    public MovedInvalidDateTime(Calendar calendar, LocalHHMM localHHMM) {
        this(calendar);
        ValidationHelper.checkForNull((String)"Original Time (hhmm)", (Object)((Object)localHHMM));
        this.originalTimeHHMM = localHHMM;
        LocalHHMM localHHMM2 = new LocalHHMM(calendar.get(11), calendar.get(12));
        this.minutesMoved = this.minutesBetween(localHHMM2, localHHMM);
    }

    private MovedInvalidDateTime(Calendar calendar) {
        super(calendar.getTimeZone());
        this.clear();
        this.setTimeInMillis(calendar.getTimeInMillis());
    }

    public int getMinutesMoved() {
        return this.minutesMoved;
    }

    public LocalHHMM getOriginalTimeHHMM() {
        if (this.originalTimeHHMM == null) {
            this.originalTimeHHMM = this.originalHHMM();
        }
        return this.originalTimeHHMM;
    }

    public long getOriginalDateTimeYYYYMMDDHHMM() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        TimeZone timeZone = this.getTimeZone();
        simpleDateFormat.setTimeZone(timeZone);
        String string = simpleDateFormat.format(this.getTime());
        String string2 = this.getOriginalTimeHHMM().toString().replace(":", "");
        return Long.valueOf(string + string2);
    }

    public Calendar toCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(super.getTimeZone());
        gregorianCalendar.clear();
        gregorianCalendar.setTimeInMillis(this.getTimeInMillis());
        return gregorianCalendar;
    }

    private int minutesBetween(LocalHHMM localHHMM, LocalHHMM localHHMM2) {
        int n = localHHMM.getMinuteOfHour();
        int n2 = localHHMM2.getMinuteOfHour();
        return (n += localHHMM.getHourOfDay() * 60) - (n2 += localHHMM2.getHourOfDay() * 60);
    }

    private LocalHHMM originalHHMM() {
        int n = this.get(11);
        int n2 = this.get(12);
        n2 -= this.minutesMoved;
        while (n2 > 60) {
            n2 -= 60;
            ++n;
        }
        while (n2 < 0) {
            n2 += 60;
            --n;
        }
        return new LocalHHMM(n, n2);
    }
}

