/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.forecast.ForecastReactivityCausePrereq;
import com.helpsystems.enterprise.core.forecast.ForecastSuiteEventInfo;
import com.helpsystems.enterprise.core.forecast.ForecastedObjectRunID;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ForecastedEvent
implements Comparable<ForecastedEvent> {
    private ForecastableEvent forecastableEvent;
    private long agentID;
    private long dateTime;
    private long queue_wait;
    private long run_duration;
    private ForecastInitiationCode forecastInitiationCode;
    private ForecastReactivityCausePrereq[] forecastReactivityCause;
    private ForecastedObjectRunID forecastedObjectRunID;
    private ForecastSuiteEventInfo suiteEventInfo;
    private boolean memberSkippedPerSpecialInstance;

    public ForecastedEvent(ForecastableEvent forecastableEvent, long l, long l2, ForecastInitiationCode forecastInitiationCode, long l3, long l4) {
        ValidationHelper.checkForNull((String)"Forecastable Event", (Object)forecastableEvent);
        ValidationHelper.checkForNull((String)"Calendar", (Object)l2);
        ValidationHelper.checkForNull((String)"Forecast Initiation Code", (Object)forecastInitiationCode);
        this.forecastableEvent = forecastableEvent;
        this.agentID = l;
        this.dateTime = l2;
        this.forecastInitiationCode = forecastInitiationCode;
        this.queue_wait = l3;
        this.run_duration = l4;
    }

    public ForecastableEvent getForecastableEvent() {
        return this.forecastableEvent;
    }

    public long getAgentID() {
        return this.agentID;
    }

    public long getDateTime() {
        return this.dateTime;
    }

    public long getQueueWait() {
        return this.queue_wait;
    }

    public long getRunDuration() {
        return this.run_duration;
    }

    public ForecastInitiationCode getForecastInitiationCode() {
        return this.forecastInitiationCode;
    }

    public ForecastReactivityCausePrereq[] getForecastReactivityCause() {
        return this.forecastReactivityCause;
    }

    public ForecastedObjectRunID getForecastedObjectRunID() {
        return this.forecastedObjectRunID;
    }

    public ForecastSuiteEventInfo getSuiteEventInfo() {
        return this.suiteEventInfo;
    }

    public void setForecastReactivityCause(ForecastReactivityCausePrereq[] forecastReactivityCausePrereqArray) {
        this.forecastReactivityCause = forecastReactivityCausePrereqArray;
    }

    public void setForecastedObjectRunID(ForecastedObjectRunID forecastedObjectRunID) {
        this.forecastedObjectRunID = forecastedObjectRunID;
    }

    public void setMemberSkippedPerSpecialInstance(boolean bl) {
        this.memberSkippedPerSpecialInstance = bl;
    }

    public void setSuiteEventInfo(ForecastSuiteEventInfo forecastSuiteEventInfo) {
        this.suiteEventInfo = forecastSuiteEventInfo;
    }

    public boolean isPrerequisite() {
        return this.forecastedObjectRunID != null;
    }

    public boolean isPrereqsAllHaveActualIDs() {
        if (this.hasPrerequisites()) {
            for (ForecastReactivityCausePrereq forecastReactivityCausePrereq : this.forecastReactivityCause) {
                ForecastedObjectRunID forecastedObjectRunID = forecastReactivityCausePrereq.getForecastedObjectRunID();
                if (forecastedObjectRunID == null || forecastedObjectRunID.isActual()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMemberSkippedPerSpecialInstance() {
        return this.memberSkippedPerSpecialInstance;
    }

    public boolean isSuite() {
        return this.forecastableEvent.getType() == ForecastableEvent.ForecastableEventType.JOB_SUITE;
    }

    public boolean isSuiteMember() {
        return this.forecastableEvent.getType() == ForecastableEvent.ForecastableEventType.MEMBER_JOB;
    }

    public boolean hasPrerequisites() {
        return this.forecastReactivityCause != null;
    }

    @Override
    public int compareTo(ForecastedEvent forecastedEvent) {
        if (forecastedEvent != null) {
            if (this.dateTime < forecastedEvent.dateTime) {
                return -1;
            }
            if (this.dateTime > forecastedEvent.dateTime) {
                return 1;
            }
            if (this.forecastableEvent.compareTo(forecastedEvent.forecastableEvent) != 0) {
                return this.forecastableEvent.compareTo(forecastedEvent.forecastableEvent);
            }
            if (this.agentID < forecastedEvent.agentID) {
                return -1;
            }
            if (this.agentID > forecastedEvent.agentID) {
                return 1;
            }
            return 0;
        }
        throw new NullPointerException("Trying to compare to null.");
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        String string = "";
        switch (this.forecastInitiationCode) {
            case REGULAR_SCHEDULE: {
                string = " (RS) ";
                break;
            }
            case REACTIVE_ONLY: {
                string = " (RO) ";
                break;
            }
            case REACTIVE_AND_REGULAR_SCHEDULE: {
                string = " (RR) ";
                break;
            }
            case FORECAST_SCHEDULE: {
                string = " (FS) ";
                break;
            }
        }
        return simpleDateFormat.format(new Date(this.dateTime)) + string + this.forecastableEvent;
    }

    public static enum ForecastInitiationCode implements PersistableEnum<Integer>
    {
        REGULAR_SCHEDULE(JobInitCode.SCHEDULE.persistanceCode()),
        REACTIVE_ONLY(JobInitCode.REACTIVE.persistanceCode()),
        REACTIVE_AND_REGULAR_SCHEDULE(JobInitCode.SCHEDULED_WITH_PREREQS.persistanceCode()),
        FORECAST_SCHEDULE(5),
        SUITE_MEMBER(JobInitCode.SUITE_MEMBER.persistanceCode());

        private int persistanceCode;
        private static PersistanceCodeToEnumMap<Integer, ForecastInitiationCode> map;

        private ForecastInitiationCode(int n2) {
            this.persistanceCode = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.persistanceCode;
        }

        public static ForecastInitiationCode persistanceCodeToEnum(Integer n) {
            ForecastInitiationCode forecastInitiationCode = map.get(n);
            if (forecastInitiationCode == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return forecastInitiationCode;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])ForecastInitiationCode.values());
        }
    }
}

