/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.DateRange;
import junit.framework.TestCase;

public class DateRangeTest
extends TestCase {
    private DateRange dateRange;

    public DateRangeTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.dateRange = null;
        super.tearDown();
    }

    public void testValidCreate() {
        this.dateRange = new DateRange(20100101, 20100131);
        this.dateRange = new DateRange(20100115, 20100115);
        this.dateRange = new DateRange(20100798, 20105615);
        this.dateRange = new DateRange(22222222, 99999999);
    }

    public void testInvalidCreate() {
        try {
            this.dateRange = new DateRange(20100131, 20100101);
            DateRangeTest.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testContains() {
        this.dateRange = new DateRange(20100415, 20100430);
        DateRangeTest.assertTrue((boolean)this.dateRange.contains(20100415));
        DateRangeTest.assertTrue((boolean)this.dateRange.contains(20100420));
        DateRangeTest.assertTrue((boolean)this.dateRange.contains(20100430));
        DateRangeTest.assertFalse((boolean)this.dateRange.contains(20100404));
        DateRangeTest.assertFalse((boolean)this.dateRange.contains(20100431));
    }

    public void testGetBegin() {
        this.dateRange = new DateRange(20100101, 20100131);
        DateRangeTest.assertEquals((int)20100101, (int)this.dateRange.getBegin());
    }

    public void testGetEnd() {
        this.dateRange = new DateRange(20100101, 20100131);
        DateRangeTest.assertEquals((int)20100131, (int)this.dateRange.getEnd());
    }

    public void testEquals() {
        this.dateRange = new DateRange(20100101, 20100131);
        DateRange dateRange = new DateRange(20100101, 20100131);
        DateRange dateRange2 = new DateRange(20100115, 20100131);
        DateRange dateRange3 = new DateRange(20100101, 20100120);
        DateRangeTest.assertFalse((boolean)this.dateRange.equals(null));
        DateRangeTest.assertFalse((boolean)this.dateRange.equals(new Object()));
        DateRangeTest.assertTrue((boolean)this.dateRange.equals(this.dateRange));
        DateRangeTest.assertTrue((boolean)this.dateRange.equals(dateRange));
        DateRangeTest.assertTrue((boolean)dateRange.equals(this.dateRange));
        DateRangeTest.assertFalse((boolean)dateRange.equals(dateRange2));
        DateRangeTest.assertFalse((boolean)dateRange2.equals(dateRange));
        DateRangeTest.assertFalse((boolean)dateRange.equals(dateRange3));
    }

    public void testEqualValuesHaveEqualHashCodes() {
        this.dateRange = new DateRange(20100101, 20100131);
        DateRange dateRange = new DateRange(20100101, 20100131);
        DateRangeTest.assertEquals((int)this.dateRange.hashCode(), (int)dateRange.hashCode());
    }

    public void testToString() {
        this.dateRange = new DateRange(20100101, 20100131);
        DateRangeTest.assertEquals((String)"20100101 - 20100131", (String)this.dateRange.toString());
    }
}

