/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.remoteserver;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.busobj.PrereqEventSource;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SendStatusEvent;
import com.helpsystems.enterprise.core.busobj.UnknownEnumException;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification_TL;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.text.SimpleDateFormat;

public class RemoteDependencyNotification
extends EnterpriseVersionedObject {
    private static final long serialVersionUID = 7058768094216513336L;
    private long id;
    private long serverID;
    private PrereqEventType eventType;
    private PrereqStatusType eventStatus;
    private long objectID;
    private String objectName;
    private PrereqEventSource eventSource;
    private long eventSourceID;
    private String eventSourceInfo;
    private long statusTimestamp;
    private long notificationHistoryID;
    private String userJobName;
    private long remoteDependencyID;
    private long jobSuiteID;
    private String jobSuiteName;

    public long getId() {
        return this.id;
    }

    public long getServerID() {
        return this.serverID;
    }

    public PrereqEventType getEventType() {
        return this.eventType;
    }

    public PrereqStatusType getEventStatus() {
        return this.eventStatus;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public PrereqEventSource getEventSource() {
        return this.eventSource;
    }

    public long getEventSourceID() {
        return this.eventSourceID;
    }

    public String getEventSourceInfo() {
        return this.eventSourceInfo;
    }

    public long getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public long getNotificationHistoryID() {
        return this.notificationHistoryID;
    }

    public long getRemoteDependencyID() {
        return this.remoteDependencyID;
    }

    public long getJobSuiteID() {
        return this.jobSuiteID;
    }

    public String getJobSuiteName() {
        return this.jobSuiteName;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setServerID(long l) {
        this.serverID = l;
    }

    public void setEventType(PrereqEventType prereqEventType) {
        this.eventType = prereqEventType;
    }

    public void setEventStatus(PrereqStatusType prereqStatusType) {
        this.eventStatus = prereqStatusType;
    }

    public void setObjectID(long l) {
        this.objectID = l;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public void setEventSource(PrereqEventSource prereqEventSource) {
        this.eventSource = prereqEventSource;
    }

    public void setEventSourceID(long l) {
        this.eventSourceID = l;
    }

    public void setEventSourceInfo(String string) {
        this.eventSourceInfo = string;
    }

    public void setStatusTimestamp(long l) {
        this.statusTimestamp = l;
    }

    public void setNotificationHistoryID(long l) {
        this.notificationHistoryID = l;
    }

    public void setRemoteDependencyID(long l) {
        this.remoteDependencyID = l;
    }

    public void setJobSuiteID(long l) {
        this.jobSuiteID = l;
    }

    public void setJobSuiteName(String string) {
        this.jobSuiteName = string;
    }

    public void setUserJobName(String string) {
        this.userJobName = string;
    }

    public String getUserJobName() {
        return this.userJobName;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        return MessageUtil.formatMsg((String)"{0} {1} {2} {3}", (Object[])new Object[]{this.eventType, this.objectID, this.eventStatus, simpleDateFormat.format(this.getStatusTimestamp())});
    }

    public static String convertSkybotNameToUserJobName(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.toUpperCase().trim();
        if (string2.length() > 10) {
            string2 = string2.substring(0, 10);
        }
        return string2;
    }

    public static RemoteDependencyNotification fromAgentEventHistory(AgentEventHistoryInfo agentEventHistoryInfo) {
        ValidationHelper.checkForNull((String)"Agent Event History Info", (Object)((Object)agentEventHistoryInfo));
        RemoteDependencyNotification remoteDependencyNotification = new RemoteDependencyNotification();
        remoteDependencyNotification.setEventType(PrereqEventType.AGENT_EVENT);
        remoteDependencyNotification.setEventStatus(PrereqStatusType.OCCURRED);
        remoteDependencyNotification.setObjectID(agentEventHistoryInfo.getEventOID());
        remoteDependencyNotification.setObjectName(agentEventHistoryInfo.getEventMonitorName());
        remoteDependencyNotification.setEventSource(PrereqEventSource.SYSTEM);
        remoteDependencyNotification.setEventSourceID(agentEventHistoryInfo.getOID());
        remoteDependencyNotification.setStatusTimestamp(agentEventHistoryInfo.getServerTimeStamp());
        return remoteDependencyNotification;
    }

    public static RemoteDependencyNotification fromJobHistory(JobHistory jobHistory) {
        long l;
        PrereqStatusType prereqStatusType;
        long l2;
        PrereqEventType prereqEventType;
        ValidationHelper.checkForNull((String)"Job History", (Object)((Object)jobHistory));
        RemoteDependencyNotification remoteDependencyNotification = new RemoteDependencyNotification();
        if (jobHistory.isJobSuite()) {
            prereqEventType = PrereqEventType.JOB_SUITE_STATUS_CHANGE;
            l2 = jobHistory.getJobID();
        } else if (jobHistory.isJobSuiteMember()) {
            prereqEventType = PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE;
            l2 = jobHistory.getJobSuiteMemberID();
        } else {
            prereqEventType = PrereqEventType.JOB_STATUS_CHANGE;
            l2 = jobHistory.getJobID();
        }
        remoteDependencyNotification.setEventType(prereqEventType);
        switch (jobHistory.getStatusCode()) {
            case SUBMITTED: {
                prereqStatusType = PrereqStatusType.SUBMITTED;
                l = jobHistory.getServerSubmittedTime();
                break;
            }
            case RUNNING: {
                prereqStatusType = PrereqStatusType.RUNNING;
                l = jobHistory.getServerRunningTime();
                break;
            }
            case COMPLETED: {
                prereqStatusType = PrereqStatusType.COMPLETED;
                l = jobHistory.getServerEndedTime();
                break;
            }
            case FAILED: {
                prereqStatusType = PrereqStatusType.FAILED;
                l = jobHistory.getServerEndedTime();
                break;
            }
            case SKIPPED: {
                prereqStatusType = PrereqStatusType.SKIPPED;
                l = jobHistory.getServerInitiatedTime();
                break;
            }
            case CANCELED: {
                prereqStatusType = PrereqStatusType.CANCELED;
                l = jobHistory.getServerEndedTime();
                break;
            }
            case CONDITION_RETRY_WAIT: {
                prereqStatusType = PrereqStatusType.CONDITION_RETRY_WAIT;
                l = jobHistory.getServerSubmittedTime();
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job status code {0} is not supported by this method.", (Object[])new Object[]{jobHistory.getStatusCode()}));
            }
        }
        remoteDependencyNotification.setEventStatus(prereqStatusType);
        remoteDependencyNotification.setStatusTimestamp(l);
        remoteDependencyNotification.setObjectID(l2);
        remoteDependencyNotification.setObjectName(jobHistory.getJobName());
        remoteDependencyNotification.setEventSource(PrereqEventSource.SYSTEM);
        remoteDependencyNotification.setEventSourceID(jobHistory.getId());
        if (jobHistory.isJobSuiteMember()) {
            remoteDependencyNotification.setJobSuiteID(jobHistory.getJobSuiteID());
            remoteDependencyNotification.setJobSuiteName(jobHistory.getJobSuiteName());
        }
        return remoteDependencyNotification;
    }

    public static RemoteDependencyNotification fromJobMonitorEvent(JobMonitorEvent jobMonitorEvent) {
        PrereqStatusType prereqStatusType;
        ValidationHelper.checkForNull((String)"Job Monitor Event", (Object)((Object)jobMonitorEvent));
        RemoteDependencyNotification remoteDependencyNotification = new RemoteDependencyNotification();
        remoteDependencyNotification.setEventType(jobMonitorEvent.determinePrereqEventType());
        remoteDependencyNotification.setObjectID(jobMonitorEvent.getJobID());
        remoteDependencyNotification.setObjectName(jobMonitorEvent.getRuntimeJobName());
        remoteDependencyNotification.setEventSource(PrereqEventSource.SYSTEM);
        remoteDependencyNotification.setEventSourceID(jobMonitorEvent.getID());
        remoteDependencyNotification.setStatusTimestamp(jobMonitorEvent.getTimeDetected());
        switch (jobMonitorEvent.getEventType()) {
            case 3: {
                prereqStatusType = PrereqStatusType.LATE_START;
                break;
            }
            case 1: {
                prereqStatusType = PrereqStatusType.UNDER_RUN;
                break;
            }
            case 2: {
                prereqStatusType = PrereqStatusType.OVER_RUN;
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job monitor event type code {0} is not supported by this method.", (Object[])new Object[]{jobMonitorEvent.getEventType()}));
            }
        }
        remoteDependencyNotification.setEventStatus(prereqStatusType);
        return remoteDependencyNotification;
    }

    public static RemoteDependencyNotification fromSendStatusEvent(SendStatusEvent sendStatusEvent) {
        ValidationHelper.checkForNull((String)"Send Status Event", (Object)((Object)sendStatusEvent));
        RemoteDependencyNotification remoteDependencyNotification = new RemoteDependencyNotification();
        remoteDependencyNotification.setEventType(sendStatusEvent.getPrereqEventType());
        remoteDependencyNotification.setEventStatus(sendStatusEvent.getPrereqStatusType());
        remoteDependencyNotification.setObjectID(sendStatusEvent.getPrereqObjectID());
        remoteDependencyNotification.setEventSource(PrereqEventSource.USER);
        remoteDependencyNotification.setEventSourceInfo(sendStatusEvent.getUser());
        remoteDependencyNotification.setStatusTimestamp(sendStatusEvent.getTimeStamp());
        return remoteDependencyNotification;
    }

    public static RemoteDependencyNotification fromRemoteDependencyNotification_TL(RemoteDependencyNotification_TL remoteDependencyNotification_TL) throws UnknownEnumException {
        Object object;
        ValidationHelper.checkForNull((String)"Remote Dependency Notification TL", (Object)((Object)remoteDependencyNotification_TL));
        RemoteDependencyNotification remoteDependencyNotification = new RemoteDependencyNotification();
        remoteDependencyNotification.setId(remoteDependencyNotification_TL.getId());
        remoteDependencyNotification.setServerID(remoteDependencyNotification_TL.getServerID());
        int n = remoteDependencyNotification_TL.getEventTypeCode();
        try {
            object = PrereqEventType.persistanceCodeToEnum(n);
            remoteDependencyNotification.setEventType((PrereqEventType)object);
        }
        catch (IllegalStateException illegalStateException) {
            String string = MessageUtil.formatMsg((String)"Unknown event type. The code {0}, representing the type of an event, is unrecognized.", (Object[])new Object[]{n});
            throw new UnknownEnumException(string, (Throwable)illegalStateException, "PrereqEventType", n);
        }
        object = remoteDependencyNotification_TL.getEventStatusCode();
        try {
            PrereqStatusType prereqStatusType = PrereqStatusType.persistanceCodeToEnum((String)object);
            remoteDependencyNotification.setEventStatus(prereqStatusType);
        }
        catch (IllegalStateException illegalStateException) {
            String string = MessageUtil.formatMsg((String)"Unknown event status. The code {0}, representing the status of an event, is unrecognized.", (Object[])new Object[]{object});
            throw new UnknownEnumException(string, (Throwable)illegalStateException, "PrereqStatusType", object);
        }
        remoteDependencyNotification.setObjectID(remoteDependencyNotification_TL.getObjectID());
        remoteDependencyNotification.setObjectName(remoteDependencyNotification_TL.getObjectName());
        int n2 = remoteDependencyNotification_TL.getEventSourceCode();
        try {
            PrereqEventSource prereqEventSource = PrereqEventSource.persistanceCodeToEnum(n2);
            remoteDependencyNotification.setEventSource(prereqEventSource);
        }
        catch (IllegalStateException illegalStateException) {
            String string = MessageUtil.formatMsg((String)"Unknown event source. The code {0}, representing the status of an event, is unrecognized.", (Object[])new Object[]{n2});
            throw new UnknownEnumException(string, (Throwable)illegalStateException, "PrereqEventSource", n2);
        }
        remoteDependencyNotification.setEventSourceID(remoteDependencyNotification_TL.getEventSourceID());
        remoteDependencyNotification.setEventSourceInfo(remoteDependencyNotification_TL.getEventSourceInfo());
        remoteDependencyNotification.setStatusTimestamp(remoteDependencyNotification_TL.getStatusTimestamp());
        remoteDependencyNotification.setNotificationHistoryID(remoteDependencyNotification_TL.getNotificationHistoryID());
        remoteDependencyNotification.setUserJobName(remoteDependencyNotification_TL.getUserJobName());
        remoteDependencyNotification.setRemoteDependencyID(remoteDependencyNotification_TL.getRemoteDependencyID());
        remoteDependencyNotification.setJobSuiteID(remoteDependencyNotification_TL.getJobSuiteID());
        remoteDependencyNotification.setJobSuiteName(remoteDependencyNotification_TL.getJobSuiteName());
        return remoteDependencyNotification;
    }
}

