/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.exec;

import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import java.io.Serializable;
import java.util.Map;
import junit.framework.TestCase;

public class ExecutableJobTest
extends TestCase {
    private ExecutableJob job;

    protected void setUp() throws Exception {
        super.setUp();
        this.job = new ExecutableJob();
    }

    protected void tearDown() throws Exception {
        this.job = null;
        super.tearDown();
    }

    public void testSetEventID() {
        this.job.setEventID("eventID");
        ExecutableJobTest.assertEquals((String)"eventID", (String)this.job.getEventID());
    }

    public void testSetScheduleJob() {
        ScheduleJob scheduleJob = new ScheduleJob();
        this.job.setScheduleJob(scheduleJob);
        ExecutableJobTest.assertEquals((Object)((Object)scheduleJob), (Object)((Object)this.job.getScheduleJob()));
    }

    public void testSetPrivateAgentEnvironment() {
        AgentEnvironment agentEnvironment = new AgentEnvironment();
        this.job.setPrivateAgentEnvironment(agentEnvironment);
        ExecutableJobTest.assertEquals((Object)((Object)agentEnvironment), (Object)((Object)this.job.getPrivateAgentEnvironment()));
    }

    public void testSetSharedAgentEnvironment() {
        AgentEnvironment agentEnvironment = new AgentEnvironment();
        this.job.setSharedAgentEnvironment(agentEnvironment);
        ExecutableJobTest.assertEquals((Object)((Object)agentEnvironment), (Object)((Object)this.job.getSharedAgentEnvironment()));
    }

    public void testSetServerPeerID() {
        PeerDescriptor peerDescriptor = new PeerDescriptor("address", 4321, 4, "WINDOZE");
        PeerID peerID = PeerID.createPeerID((String)"hardwareKey", (Serializable)((Object)"instanceIdentifier"), (PeerDescriptor)peerDescriptor);
        this.job.setServerPeerID(peerID);
        ExecutableJobTest.assertEquals((Object)peerID, (Object)this.job.getServerPeerID());
    }

    public void testSetCopyJobLogToServer() {
        this.job.setCopyJobLogToServer(false);
        ExecutableJobTest.assertFalse((boolean)this.job.getCopyJobLogToServer());
        ExecutableJobTest.assertFalse((boolean)this.job.isCopyJobLogToServer());
        this.job.setCopyJobLogToServer(true);
        ExecutableJobTest.assertTrue((boolean)this.job.getCopyJobLogToServer());
        ExecutableJobTest.assertTrue((boolean)this.job.isCopyJobLogToServer());
    }

    public void testSetJobUser() {
        this.job.setJobUser("jobUser");
        ExecutableJobTest.assertEquals((String)"jobUser", (String)this.job.getJobUser());
        this.job.setJobUser(" jobUser  ");
        ExecutableJobTest.assertEquals((String)"jobUser", (String)this.job.getJobUser());
        this.job.setJobUser(null);
        ExecutableJobTest.assertEquals((String)"", (String)this.job.getJobUser());
    }

    public void testSetAgent() {
        Agent agent = new Agent();
        this.job.setAgent(agent);
        ExecutableJobTest.assertEquals((Object)((Object)agent), (Object)((Object)this.job.getAgent()));
    }

    public void testSetEventHistory() {
        AgentEventHistoryInfo agentEventHistoryInfo = new AgentEventHistoryInfo();
        AgentEventHistoryInfo agentEventHistoryInfo2 = new AgentEventHistoryInfo();
        AgentEventHistoryInfo agentEventHistoryInfo3 = new AgentEventHistoryInfo();
        AgentEventHistoryInfo[] agentEventHistoryInfoArray = new AgentEventHistoryInfo[]{agentEventHistoryInfo, agentEventHistoryInfo2, agentEventHistoryInfo3};
        this.job.setEventHistory(agentEventHistoryInfoArray);
    }

    public void testGetEventEnvVars() {
        AgentEventHistoryInfo agentEventHistoryInfo = new AgentEventHistoryInfo();
        agentEventHistoryInfo.setEventMonitorName("mon1");
        agentEventHistoryInfo.setEventType(301);
        agentEventHistoryInfo.setEventData("12345\tusername\tcommand");
        AgentEventHistoryInfo[] agentEventHistoryInfoArray = new AgentEventHistoryInfo[]{agentEventHistoryInfo};
        this.job.setEventHistory(agentEventHistoryInfoArray);
        Map<String, String> map = this.job.getEventEnvVars();
        ExecutableJobTest.assertTrue((boolean)map.containsKey("SKYBOT_mon1_PID"));
        ExecutableJobTest.assertTrue((boolean)map.containsKey("SKYBOT_mon1_USER"));
        ExecutableJobTest.assertTrue((boolean)map.containsKey("SKYBOT_mon1_COMMAND"));
        ExecutableJobTest.assertFalse((boolean)map.containsKey("SOME_BOGUS_KEY"));
        ExecutableJobTest.assertEquals((String)"12345", (String)map.get("SKYBOT_mon1_PID"));
        ExecutableJobTest.assertEquals((String)"username", (String)map.get("SKYBOT_mon1_USER"));
        ExecutableJobTest.assertEquals((String)"command", (String)map.get("SKYBOT_mon1_COMMAND"));
    }
}

