/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.dm;

import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.dm.RefreshNotificationException;
import junit.framework.TestCase;

public class RefreshNotificationExceptionTest
extends TestCase {
    RefreshNotificationException rne;
    Throwable t;
    AgentProxy proxy1;
    AgentProxy proxy2;

    protected void setUp() throws Exception {
        super.setUp();
        this.rne = new RefreshNotificationException();
        this.t = new Throwable();
        this.proxy1 = new AgentProxy();
        this.proxy1.setOid(55443L);
        this.proxy1.setName("AgentName1");
        this.proxy2 = new AgentProxy();
        this.proxy2.setOid(66554L);
        this.proxy2.setName("AgentName2");
    }

    protected void tearDown() throws Exception {
        this.proxy1 = null;
        this.proxy2 = null;
        this.t = null;
        this.rne = null;
        super.tearDown();
    }

    public void testRefreshNotificationExceptionString() {
        this.rne = new RefreshNotificationException("message");
        RefreshNotificationExceptionTest.assertEquals((String)"message", (String)this.rne.getMessage());
    }

    public void testRefreshNotificationExceptionThrowable() {
        this.rne = new RefreshNotificationException(this.t);
        RefreshNotificationExceptionTest.assertEquals((Object)this.t, (Object)this.rne.getCause());
    }

    public void testRefreshNotificationExceptionStringThrowable() {
        this.rne = new RefreshNotificationException("message", this.t);
        RefreshNotificationExceptionTest.assertEquals((String)"message", (String)this.rne.getMessage());
        RefreshNotificationExceptionTest.assertEquals((Object)this.t, (Object)this.rne.getCause());
    }

    public void testRefreshNotificationExceptionLong() {
        this.rne = new RefreshNotificationException(12345L);
        RefreshNotificationExceptionTest.assertEquals((long)12345L, (long)this.rne.getAgentOID());
    }

    public void testRefreshNotificationExceptionLongThrowable() {
        this.rne = new RefreshNotificationException(12345L, this.t);
        RefreshNotificationExceptionTest.assertEquals((long)12345L, (long)this.rne.getAgentOID());
        RefreshNotificationExceptionTest.assertEquals((Object)this.t, (Object)this.rne.getCause());
    }

    public void testRefreshNotificationExceptionAgentProxyThrowable() {
        this.rne = new RefreshNotificationException(this.proxy1, this.t);
        String string = this.rne.getFriendlyMessage();
        RefreshNotificationExceptionTest.assertTrue((boolean)string.contains("AgentName1".toUpperCase()));
        RefreshNotificationExceptionTest.assertEquals((Object)this.t, (Object)this.rne.getCause());
    }

    public void testRefreshNotificationExceptionAgentProxyAgentProxyThrowable() {
        this.rne = new RefreshNotificationException(this.proxy1, this.proxy2, this.t);
        RefreshNotificationExceptionTest.assertEquals((Object)this.t, (Object)this.rne.getCause());
        String string = this.rne.getFriendlyMessage();
        RefreshNotificationExceptionTest.assertTrue((boolean)string.contains("AgentName1".toUpperCase()));
        RefreshNotificationExceptionTest.assertTrue((boolean)string.contains("AgentName2".toUpperCase()));
    }

    public void testSetEventMonitor() {
        AgentEventMonitor agentEventMonitor = new AgentEventMonitor();
        this.rne.setEventMonitor(agentEventMonitor);
        RefreshNotificationExceptionTest.assertEquals((Object)((Object)agentEventMonitor), (Object)((Object)this.rne.getEventMonitor()));
    }

    public void testSetSwitchedEventCount() {
        this.rne.setSwitchedEventCount(135);
        RefreshNotificationExceptionTest.assertEquals((int)135, (int)this.rne.getSwitchedEventCount());
    }

    public void testSetAgentOID() {
        this.rne.setAgentOID(54321L);
        RefreshNotificationExceptionTest.assertEquals((long)54321L, (long)this.rne.getAgentOID());
    }

    public void testGetFriendlyMessage() {
        String string = this.rne.getFriendlyMessage();
        RefreshNotificationExceptionTest.assertFalse((boolean)string.contains("AgentName1".toUpperCase()));
        RefreshNotificationExceptionTest.assertFalse((boolean)string.contains("AgentName2".toUpperCase()));
        this.rne = new RefreshNotificationException(this.proxy1, this.t);
        string = this.rne.getFriendlyMessage();
        RefreshNotificationExceptionTest.assertTrue((boolean)string.contains("AgentName1".toUpperCase()));
        RefreshNotificationExceptionTest.assertFalse((boolean)string.contains("AgentName2".toUpperCase()));
        this.rne = new RefreshNotificationException(this.proxy1, this.proxy2, this.t);
        string = this.rne.getFriendlyMessage();
        RefreshNotificationExceptionTest.assertTrue((boolean)string.contains("AgentName1".toUpperCase()));
        RefreshNotificationExceptionTest.assertTrue((boolean)string.contains("AgentName2".toUpperCase()));
    }
}

