/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.dm;

import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentProxy;

public class RefreshNotificationException
extends Exception {
    private AgentEventMonitor eventMonitor = null;
    private int switchedEventCount = 0;
    private long agentOID = 0L;
    private String agentName1 = null;
    private String agentName2 = null;

    private static String getAgentMessage(AgentProxy agentProxy) {
        return "Unable to notify " + agentProxy.getName() + " to refresh agent event monitors.";
    }

    private static String getAgentMessage(AgentProxy agentProxy, AgentProxy agentProxy2) {
        return "Unable to notify " + agentProxy.getName() + " and " + agentProxy2.getName() + " to refresh agent event monitors.";
    }

    public RefreshNotificationException() {
    }

    public RefreshNotificationException(String string) {
        super(string);
    }

    public RefreshNotificationException(Throwable throwable) {
        super(throwable);
    }

    public RefreshNotificationException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public RefreshNotificationException(long l) {
        super("Error notifying agent with OID " + l + " to refresh event monitors.");
        this.agentOID = l;
    }

    public RefreshNotificationException(long l, Throwable throwable) {
        super("Error notifying agent with OID " + l + " to refresh event monitors.", throwable);
        this.agentOID = l;
    }

    public RefreshNotificationException(AgentProxy agentProxy, Throwable throwable) {
        super(RefreshNotificationException.getAgentMessage(agentProxy), throwable);
        this.agentName1 = agentProxy.getName();
    }

    public RefreshNotificationException(AgentProxy agentProxy, AgentProxy agentProxy2, Throwable throwable) {
        super(RefreshNotificationException.getAgentMessage(agentProxy, agentProxy2), throwable);
        this.agentName1 = agentProxy.getName();
        this.agentName2 = agentProxy2.getName();
    }

    public AgentEventMonitor getEventMonitor() {
        return this.eventMonitor;
    }

    public void setEventMonitor(AgentEventMonitor agentEventMonitor) {
        this.eventMonitor = agentEventMonitor;
    }

    public int getSwitchedEventCount() {
        return this.switchedEventCount;
    }

    public void setSwitchedEventCount(int n) {
        this.switchedEventCount = n;
    }

    public long getAgentOID() {
        return this.agentOID;
    }

    public void setAgentOID(long l) {
        this.agentOID = l;
    }

    public String getFriendlyMessage() {
        if (this.agentName1 != null && this.agentName2 != null) {
            return "The event monitor action completed. However, there was an error notifying the Enterprise Server to update agents " + this.agentName1 + " and " + this.agentName2 + ". " + "You may need to restart " + this.agentName1 + " and " + this.agentName2 + ".";
        }
        if (this.agentName1 != null) {
            return "The event monitor action completed. However, there was an error notifying the Enterprise Server to update agent " + this.agentName1 + ". " + "You may need to restart " + this.agentName1 + ".";
        }
        return "The event monitor action completed. However, there was an error notifying the Enterprise Server to update the event monitors on active agents. You may need to restart agents with event monitors that have been added, changed, deleted, or switched.";
    }
}

