/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.AgentEventHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.AuditHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.ForecastJobRunsReportFilter;
import com.helpsystems.enterprise.core.reports.filter.GoodMorningReportFilter;
import com.helpsystems.enterprise.core.reports.filter.JobHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.JobMonitorHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.JobSetupReportFilter;
import com.helpsystems.enterprise.core.reports.filter.OutputDistributionHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPAbapStepSetReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPInterceptedJobHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPJobDefinitionReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPRunInterceptedJobsReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPSystemDefinitionReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SNMPTrapMonitorHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SecurityReportFilter;
import com.helpsystems.enterprise.core.reports.filter.ServerHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.FilterDeclaration;
import com.helpsystems.enterprise.core.reports.filter.parser.AgentEventHistoryReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.AuditHistoryReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.ForecastJobRunsReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.GoodMorningReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.JobHistoryReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.JobMonitorHistoryReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.JobSetupReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.OutputDistributionHistoryReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.ReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPAbapStepSetReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPInterceptedJobHistoryReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPJobDefinitionReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPRunInterceptedJobsReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPSystemDefinitionReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.SNMPTrapMonitorHistoryReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.SecurityReportFilterParser;
import com.helpsystems.enterprise.core.reports.filter.parser.ServerHistoryReportParser;
import org.apache.log4j.Logger;

public class ReportCommand
extends AgentCommand {
    private static final long serialVersionUID = 4929011453962245939L;
    private static final Logger logger = Logger.getLogger(ReportCommand.class);
    public static final String COMMAND_NAME = "REPORT";
    public static final String OUTPUT_TYPE_PARAM = "-outputType";
    public static final String AGENT_CONFIGURATION_FILE = "-f";
    public static final String OUTPUT_TYPE_PDF = "pdf";
    public static final String OUTPUT_TYPE_CSV = "csv";
    public static final String OUTPUT_TYPE_PDF_ID = "0";
    public static final String OUTPUT_TYPE_CSV_ID = "3";
    private String reportName;
    private Object[] reportParams;
    private int reportID;
    private ReportOutput.OutputType outputType;
    private String runAsUserName;
    private long userFileRecordId;

    public ReportCommand() {
    }

    public ReportCommand(int n) {
        Reports.ReportType reportType = Reports.ReportType.getReportType(n);
        this.reportID = reportType.getReportID();
        this.reportName = reportType.name();
    }

    public ReportCommand(long l) {
        super(l);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    protected String getCommandInfo() {
        StringBuffer stringBuffer = new StringBuffer(this.reportName);
        stringBuffer.append(" as ");
        stringBuffer.append(this.outputType.name());
        stringBuffer.append(" using parms [");
        for (int i = 0; i < this.reportParams.length; ++i) {
            if (i > 0 && i < this.reportParams.length) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.reportParams[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public void validate() throws ActionFailedException {
        if (this.reportName == null || this.reportName.trim().length() < 1) {
            throw new ActionFailedException("Invalid report name: " + this.reportName);
        }
        ReportFilterParser<GoodMorningReportFilter> reportFilterParser = null;
        FilterDeclaration filterDeclaration = null;
        switch (this.reportID) {
            case 0: {
                filterDeclaration = new GoodMorningReportFilter();
                reportFilterParser = new GoodMorningReportFilterParser();
                break;
            }
            case 100: {
                filterDeclaration = new JobSetupReportFilter();
                reportFilterParser = new JobSetupReportFilterParser();
                break;
            }
            case 1000: {
                filterDeclaration = new JobHistoryReportFilter();
                reportFilterParser = new JobHistoryReportFilterParser();
                break;
            }
            case 1001: {
                filterDeclaration = new AgentEventHistoryReportFilter();
                reportFilterParser = new AgentEventHistoryReportFilterParser();
                break;
            }
            case 1002: {
                filterDeclaration = new JobMonitorHistoryReportFilter();
                reportFilterParser = new JobMonitorHistoryReportFilterParser();
                break;
            }
            case 1003: {
                filterDeclaration = new OutputDistributionHistoryReportFilter();
                reportFilterParser = new OutputDistributionHistoryReportFilterParser();
                break;
            }
            case 1004: {
                filterDeclaration = new SNMPTrapMonitorHistoryReportFilter();
                reportFilterParser = new SNMPTrapMonitorHistoryReportFilterParser();
                break;
            }
            case 1005: {
                filterDeclaration = new AuditHistoryReportFilter();
                reportFilterParser = new AuditHistoryReportFilterParser();
                break;
            }
            case 1006: {
                filterDeclaration = new ForecastJobRunsReportFilter();
                reportFilterParser = new ForecastJobRunsReportFilterParser();
                break;
            }
            case 1007: {
                filterDeclaration = new ServerHistoryReportFilter();
                reportFilterParser = new ServerHistoryReportParser();
                break;
            }
            case 1008: {
                break;
            }
            case 1009: {
                filterDeclaration = new SAPSystemDefinitionReportFilter();
                reportFilterParser = new SAPSystemDefinitionReportFilterParser();
                break;
            }
            case 1010: {
                filterDeclaration = new SAPJobDefinitionReportFilter();
                reportFilterParser = new SAPJobDefinitionReportFilterParser();
                break;
            }
            case 1011: {
                filterDeclaration = new SAPAbapStepSetReportFilter();
                reportFilterParser = new SAPAbapStepSetReportFilterParser();
                break;
            }
            case 1012: {
                filterDeclaration = new SAPInterceptedJobHistoryReportFilter();
                reportFilterParser = new SAPInterceptedJobHistoryReportFilterParser();
                break;
            }
            case 1013: {
                filterDeclaration = new SAPRunInterceptedJobsReportFilter();
                reportFilterParser = new SAPRunInterceptedJobsReportFilterParser();
                break;
            }
            case 1014: {
                filterDeclaration = new SecurityReportFilter();
                reportFilterParser = new SecurityReportFilterParser();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid report name: " + this.reportID);
            }
        }
        if (reportFilterParser != null && filterDeclaration != null) {
            try {
                reportFilterParser.parseParameters((GoodMorningReportFilter)filterDeclaration, this.reportParams);
            }
            catch (IllegalStateException illegalStateException) {
                throw new ActionFailedException("Report Command is not valid - " + illegalStateException.getMessage() + "\nThe -h option will show command help.");
            }
        }
    }

    @Override
    public void parseParameters(String[] stringArray) throws ActionFailedException {
        int n;
        int n2;
        if (logger.isTraceEnabled()) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                System.out.print("  params:" + n2 + " = " + stringArray[n2]);
            }
        }
        n2 = Integer.parseInt(stringArray[0]);
        Reports.ReportType reportType = Reports.ReportType.getReportType(n2);
        this.reportName = reportType.getReportName();
        this.reportID = reportType.getReportID();
        if (this.reportID == 1006) {
            int n3;
            n = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (!OUTPUT_TYPE_PARAM.equalsIgnoreCase(stringArray[n3]) || stringArray.length < n3 + 2 || stringArray[n3 + 1].startsWith("-")) continue;
                this.setReportOutputType(stringArray[n3 + 1]);
                n = 1;
            }
            if (n == 0) {
                throw new ActionFailedException("\nThe '-outputType' parameter is required for generating 'forecastedjobrunsreport' report. \nThe -h option will show command help.");
            }
            n3 = 1;
            if (stringArray.length >= 2 && stringArray[1].equals(AGENT_CONFIGURATION_FILE)) {
                n3 = 3;
            }
            this.reportParams = new String[stringArray.length - n3];
            System.arraycopy(stringArray, n3, this.reportParams, 0, stringArray.length - n3);
        } else {
            this.outputType = ReportOutput.OutputType.getOutputType(stringArray[1]);
            n = 2;
            if (stringArray.length >= 3 && stringArray[2].equals(AGENT_CONFIGURATION_FILE)) {
                n = 4;
            }
            this.reportParams = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, this.reportParams, 0, stringArray.length - n);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("   name:" + this.reportName));
            logger.trace((Object)("   type:" + this.outputType));
            for (n = 0; n < this.reportParams.length; ++n) {
                logger.trace((Object)("  params:" + n + " = " + this.reportParams[n]));
            }
        }
    }

    public void setReportOutputType(String string) throws ActionFailedException {
        if (OUTPUT_TYPE_PDF.equalsIgnoreCase(string)) {
            this.outputType = ReportOutput.OutputType.getOutputType(OUTPUT_TYPE_PDF_ID);
        } else if (OUTPUT_TYPE_CSV.equalsIgnoreCase(string)) {
            this.outputType = ReportOutput.OutputType.getOutputType(OUTPUT_TYPE_CSV_ID);
        } else {
            throw new ActionFailedException("\nThere is wrong value given for '-outputType' parameter. \nThe -h option will show command help.");
        }
    }

    public long getUserFileRecordId() {
        return this.userFileRecordId;
    }

    public void setUserFileRecordId(long l) {
        this.userFileRecordId = l;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setParameters(Object[] objectArray) {
        this.reportParams = objectArray;
    }

    public Object[] getParams() {
        return this.reportParams;
    }

    public void setOutputType(ReportOutput.OutputType outputType) {
        this.outputType = outputType;
    }

    public ReportOutput.OutputType getOutputType() {
        return this.outputType;
    }

    public int getReportID() {
        return this.reportID;
    }

    public void setReportID(int n) {
        this.reportID = n;
    }

    public String getRunAsUserName() {
        return this.runAsUserName;
    }

    public void setRunAsUser(String string) {
        this.runAsUserName = string;
    }
}

