/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;

public class GetActivityCommand
extends AgentCommand {
    private static final long serialVersionUID = 7132815282236243665L;
    public static final String COMMAND_NAME = "GETACTIVITY";
    private boolean jobListRequested = false;
    private boolean eventListRequested = false;
    private boolean fileTransfersRequested = false;

    @Override
    protected String getCommandInfo() {
        if (!(this.jobListRequested || this.eventListRequested || this.fileTransfersRequested)) {
            return this.getCommandInfoHelper(true, true, true);
        }
        return this.getCommandInfoHelper(this.jobListRequested, this.eventListRequested, this.fileTransfersRequested);
    }

    private String getCommandInfoHelper(boolean bl, boolean bl2, boolean bl3) {
        return "Job List: " + Convert.booleanToYesNo((boolean)bl) + " Event List: " + Convert.booleanToYesNo((boolean)bl2) + " File Transfers: " + Convert.booleanToYesNo((boolean)bl3);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void parseParameters(String[] stringArray) throws ActionFailedException {
        if (stringArray.length == 0) {
            this.setEventListRequested(true);
            this.setFileTransfersRequested(true);
            this.setJobListRequested(true);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].toLowerCase().trim();
                if (string.equals("-m")) {
                    this.setEventListRequested(true);
                    continue;
                }
                if (string.equals("-t")) {
                    this.setFileTransfersRequested(true);
                    continue;
                }
                if (string.equals("-j")) {
                    this.setJobListRequested(true);
                    continue;
                }
                if (string.length() == 0) continue;
                throw new ActionFailedException("Invalid parameter: " + stringArray[i]);
            }
        }
    }

    @Override
    public void validate() throws ActionFailedException {
    }

    public boolean isJobListRequested() {
        return this.jobListRequested;
    }

    public void setJobListRequested(boolean bl) {
        this.jobListRequested = bl;
    }

    public boolean isEventListRequested() {
        return this.eventListRequested;
    }

    public void setEventListRequested(boolean bl) {
        this.eventListRequested = bl;
    }

    public boolean isFileTransfersRequested() {
        return this.fileTransfersRequested;
    }

    public void setFileTransfersRequested(boolean bl) {
        this.fileTransfersRequested = bl;
    }
}

