/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPField;
import java.math.BigDecimal;
import java.security.InvalidParameterException;

public abstract class SAPParameters
extends EnterpriseProxy {
    private static final long serialVersionUID = -1L;

    public abstract Object getField(SAPField var1);

    public abstract String getBooleanFieldAsString(SAPField var1);

    public String getStringFromValue(Object object, SAPField sAPField) {
        this.doStringCheck(object, sAPField);
        String string = (String)object;
        this.doStringLengthCheck(string, sAPField);
        return string;
    }

    private void doStringLengthCheck(String string, SAPField sAPField) {
        if (string.length() > sAPField.getMaxValue()) {
            throw new InvalidParameterException("The parameter of " + string + " exceeds the maximum length of " + sAPField.getMaxValue() + " for the field " + sAPField);
        }
    }

    private void doStringCheck(Object object, SAPField sAPField) {
        if (!(object instanceof String)) {
            throw new InvalidParameterException("The value for " + sAPField.getDescription() + " must be a String.  It is currently set to " + object);
        }
    }

    public BigDecimal getBigDecimalFromValue(Object object, SAPField sAPField) {
        this.doBigDecimalCheck(object, sAPField);
        BigDecimal bigDecimal = (BigDecimal)object;
        this.doIntegerValidateCheck(bigDecimal.intValue(), sAPField);
        return bigDecimal;
    }

    public int getIntegerFromValue(Object object, SAPField sAPField) {
        this.doIntegerCheck(object, sAPField);
        int n = (Integer)object;
        this.doIntegerValidateCheck(n, sAPField);
        return n;
    }

    private void doIntegerCheck(Object object, SAPField sAPField) {
        if (!(object instanceof Integer)) {
            throw new InvalidParameterException("The value for " + sAPField.getDescription() + " must be an Integer.  It is currently set to " + object);
        }
    }

    private void doIntegerValidateCheck(int n, SAPField sAPField) {
        if (n < sAPField.getMinValue()) {
            throw new InvalidParameterException("The parameter of " + n + " is less than the minimum value of " + sAPField.getMinValue() + " for the field " + sAPField);
        }
        if (n > sAPField.getMaxValue()) {
            throw new InvalidParameterException("The parameter of " + n + " is more than the maximum value of " + sAPField.getMaxValue() + " for the field " + sAPField);
        }
    }

    private void doBigDecimalCheck(Object object, SAPField sAPField) {
        if (!(object instanceof BigDecimal)) {
            throw new InvalidParameterException("The value for " + sAPField.getDescription() + " must be an BigDecimal.  It is currently set to " + object);
        }
    }
}

