/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.sap.SAPProcess;
import com.helpsystems.enterprise.core.busobj.sap.SAPProcessChain;
import com.helpsystems.enterprise.core.busobj.sap.SAPProcessStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SAPExecutableProcessChain
extends SAPProcessChain {
    private static final long serialVersionUID = -1L;
    private String logID;
    private SAPProcessStatus status;
    private boolean waitOnCompletion = true;
    private boolean terminated;
    private HashMap<String, SAPProcess> sapProcessHM = new HashMap();

    public SAPExecutableProcessChain(long l, String string) {
        this.setSAPSystemEnvironmentID(l);
        super.setName(string);
    }

    public SAPExecutableProcessChain() {
    }

    public String toString() {
        return "commandID = " + this.getOID() + " sapSystemDefinitionID = " + this.getSAPSystemDefinitionID() + " sapSystemEnvironmentID = " + this.getSAPSystemEnvironmentID() + " sapProcessChainName = " + this.getName();
    }

    public String getLogID() {
        return this.logID;
    }

    public void setLogID(String string) {
        this.logID = string;
    }

    public SAPProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(SAPProcessStatus sAPProcessStatus) {
        this.status = sAPProcessStatus;
    }

    public void setWaitOnCompletion(boolean bl) {
        this.waitOnCompletion = bl;
    }

    public boolean isWaitOnCompletion() {
        return this.waitOnCompletion;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    public String getNameAndLogID() {
        return this.getName() + "(" + this.getLogID() + ")";
    }

    public ArrayList<SAPProcess> getActiveProcesses() {
        ArrayList<SAPProcess> arrayList = new ArrayList<SAPProcess>();
        Set<String> set = this.sapProcessHM.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            SAPProcess sAPProcess = this.sapProcessHM.get(iterator.next());
            if (!sAPProcess.isActive()) continue;
            arrayList.add(sAPProcess);
        }
        return arrayList;
    }

    public void addProcess(SAPProcess sAPProcess) {
        this.sapProcessHM.put(sAPProcess.getHashMapID(), sAPProcess);
    }

    public boolean hasSAPProcesses() {
        return !this.sapProcessHM.isEmpty();
    }

    public HashMap<String, SAPProcess> getSapProcessHM() {
        return this.sapProcessHM;
    }
}

