/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStepSet;
import com.helpsystems.enterprise.core.busobj.sap.SAPChildJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPCommand;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobClass;
import java.util.ArrayList;

public class SAPExecutableJob
extends SAPJob
implements SAPCommand {
    private static final long serialVersionUID = -1L;
    private ExecutableSAPJobType executableSAPJobType = ExecutableSAPJobType.NORMAL;
    private String sapExecTarget = "";
    private String sapSpoolListRecipientType = "B";
    private String sapSpoolListRecipient = "";
    private String deliverStatusSetting = "";
    private SAPABAPStepSet abapStepSet;
    private boolean waitOnCompletion = true;
    private boolean waitForChildJobs;
    private ArrayList<SAPChildJob> sapChildJobsAL = new ArrayList();
    private ArrayList<SAPInterceptedJob> interceptedJobsToRelease = new ArrayList();

    public SAPExecutableJob(long l, String string, SAPJobClass sAPJobClass, String string2, String string3, String string4, boolean bl, int n) {
        this.setSAPSystemEnvironmentID(l);
        super.setName(string);
        this.setSapJobClass(sAPJobClass);
        this.sapExecTarget = string2;
        this.sapSpoolListRecipient = string3;
        super.setSapRecipientAttributes(string4);
        this.setCopySpoolFiles(bl);
        super.setSapABAPStepSetID(n);
    }

    public SAPExecutableJob() {
    }

    public SAPExecutableJob(SAPInterceptedJob sAPInterceptedJob) {
        this.setSapSystemDefinitionID(sAPInterceptedJob.getSapSystemDefinitionID());
        this.setJobName(sAPInterceptedJob.getJobName());
        this.setJobCount(sAPInterceptedJob.getJobCount());
    }

    public SAPExecutableJob(long l, String string, String string2, boolean bl) {
        this.setSapSystemDefinitionID(l);
        this.setJobName(string);
        this.setJobCount(string2);
        this.setStartImmediately(bl);
    }

    public SAPExecutableJob(long l, String string, String string2) {
        this.setSapSystemDefinitionID(l);
        this.setJobName(string);
        this.setJobCount(string2);
    }

    public String getSapExecTarget() {
        if (this.sapExecTarget == null) {
            this.sapExecTarget = "";
        }
        return this.sapExecTarget;
    }

    public void setSapExecTarget(String string) {
        this.sapExecTarget = string;
    }

    public String getSapSpoolListRecipient() {
        return this.sapSpoolListRecipient;
    }

    public void setSapSpoolListRecipient(String string) {
        this.sapSpoolListRecipient = string;
    }

    public void setAbapStepSet(SAPABAPStepSet sAPABAPStepSet) {
        this.abapStepSet = sAPABAPStepSet;
    }

    public SAPABAPStepSet getAbapStepSet() {
        return this.abapStepSet;
    }

    public String toString() {
        return "commandID = " + this.getOID() + " sapSystemDefinitionID = " + this.getSAPSystemDefinitionID() + " sapSystemEnvironmentID = " + this.getSAPSystemEnvironmentID() + " sapJobName = " + this.getName() + " sapJobClass + " + this.getSapJobClass() + " sapExecTarget = " + this.sapExecTarget + " sapSpoolListRecipient = " + this.sapSpoolListRecipient + " sapSpoolListRecipientType = " + this.sapSpoolListRecipientType + " sapSpoolListRecipientAttributes = " + this.getSapRecipientAttributes() + " copySpoolFiles = " + this.isCopySpoolFiles() + " sapABAPStepSetID = " + this.getSapABAPStepSetID() + " abapStepSet ID = " + this.abapStepSet.getOID() + " waitOnCompletion = " + this.isWaitOnCompletion() + " startImmediately = " + this.isStartImmediately();
    }

    public void setWaitOnCompletion(boolean bl) {
        this.waitOnCompletion = bl;
    }

    public boolean isWaitOnCompletion() {
        return this.waitOnCompletion;
    }

    public void addChildJob(SAPChildJob sAPChildJob) {
        this.sapChildJobsAL.add(sAPChildJob);
    }

    public ArrayList<SAPChildJob> getChildJobs() {
        return this.sapChildJobsAL;
    }

    public void setExecutableSAPJobType(ExecutableSAPJobType executableSAPJobType) {
        this.executableSAPJobType = executableSAPJobType;
    }

    public ExecutableSAPJobType getExecutableSAPJobType() {
        return this.executableSAPJobType;
    }

    public SAPChildJob getChild(String string, String string2) {
        for (SAPChildJob sAPChildJob : this.sapChildJobsAL) {
            if (!sAPChildJob.getJobName().equals(string) || !sAPChildJob.getJobCount().equals(string2)) continue;
            return sAPChildJob;
        }
        return null;
    }

    @Override
    public String getSAPCommandName() {
        if (this.executableSAPJobType == ExecutableSAPJobType.SINGLE_INTERCEPTED) {
            return "Release Intercepted SAP Job " + this.getJobName();
        }
        if (this.executableSAPJobType == ExecutableSAPJobType.MULTIPLE_INTERCEPTED) {
            return this.getJobName();
        }
        return "Run SAP Job " + this.getJobName();
    }

    @Override
    public long getSAPSystemDefinitionID() {
        return super.getSapSystemDefinitionID();
    }

    public boolean isWaitForChildJobs() {
        return this.waitForChildJobs;
    }

    public void setWaitForChildJobs(boolean bl) {
        this.waitForChildJobs = bl;
    }

    public ArrayList<SAPInterceptedJob> getInterceptedJobsToRelease() {
        return this.interceptedJobsToRelease;
    }

    public void setInterceptedJobsToRelease(ArrayList<SAPInterceptedJob> arrayList) {
        this.interceptedJobsToRelease = arrayList;
    }

    public void addInterceptedJobToRelease(SAPInterceptedJob sAPInterceptedJob) {
        this.interceptedJobsToRelease.add(sAPInterceptedJob);
    }

    public String getSapSpoolListRecipientType() {
        return this.sapSpoolListRecipientType;
    }

    public void setSapSpoolListRecipientType(String string) {
        this.sapSpoolListRecipientType = string;
    }

    public String getDeliverStatusSetting() {
        return this.deliverStatusSetting;
    }

    public void setDeliverStatusSetting(String string) {
        this.deliverStatusSetting = string;
    }

    public boolean hasSapSpoolListRecipient() {
        return this.sapSpoolListRecipient != null && this.sapSpoolListRecipient.length() > 0;
    }

    public boolean hasSAPExecTarget() {
        return this.getSapExecTarget().length() > 0;
    }

    public static enum ExecutableSAPJobType {
        NORMAL,
        SINGLE_INTERCEPTED,
        MULTIPLE_INTERCEPTED;

    }
}

