/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteria;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteriaField;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteriaItem;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteriaNode;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriterion;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAPCriteriaXMLInfo {
    private static Logger logger = Logger.getLogger(SAPCriteriaXMLInfo.class);
    private static final String PROFILE = "profile";
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String STATE = "state";
    private static final String LASTCHUSER = "lastchuser";
    private static final String LASTCHTMSTMP = "lastchtmstmp";
    private static final String CREATEUSER = "createuser";
    private static final String ROOT = "root";
    private static final String SIGN = "sign";
    private static final String OPT = "opt";
    private static final String LOW = "low";
    private static final String HIGH = "high";
    private Document doc;
    private Node nodeProfileType;
    private Node nodeProfileID;
    private Node nodeProfileDescription;
    private Node nodeProfileState;
    private Node nodeProfileLastChUser;
    private Node nodeProfileLastchtmstmp;
    private Node nodeProfileCreateuser;
    private boolean modified;
    private SAPCriteria sapCriteria;

    public SAPCriteriaXMLInfo(String string, SAPCriteria sAPCriteria) throws ParserConfigurationException, SAXException, IOException {
        this.sapCriteria = sAPCriteria;
        this.initialize(string);
        this.modified = false;
    }

    private void initialize(String string) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(new StringReader(string));
        String string2 = System.getProperty("user.dir");
        inputSource.setSystemId("file:///" + string2 + "/");
        logger.debug((Object)("InputSource systemdId set to " + inputSource.getSystemId()));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.setDoc(documentBuilder.parse(inputSource));
        logger.debug((Object)"After setDoc(db.parse(is))");
        this.loadDoc();
    }

    private void loadDoc() throws InvalidObjectException {
        this.doc.getDocumentElement().normalize();
        String string = this.doc.getDocumentElement().getNodeName();
        if (string == null || !string.equals(PROFILE)) {
            throw new InvalidObjectException("The loaded criteriaXML does not contain the element profile.");
        }
        NodeList nodeList = this.doc.getElementsByTagName(PROFILE);
        NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
        this.nodeProfileType = namedNodeMap.getNamedItem(TYPE);
        String string2 = this.nodeProfileType.getNodeValue();
        logger.debug((Object)("Profile Type = " + string2));
        this.setProfileType(string2);
        this.nodeProfileID = namedNodeMap.getNamedItem(ID);
        String string3 = this.nodeProfileID.getNodeValue();
        logger.debug((Object)("Profile ID = " + string3));
        this.setProfileID(string3);
        this.nodeProfileDescription = namedNodeMap.getNamedItem(DESCRIPTION);
        String string4 = this.nodeProfileDescription.getNodeValue();
        logger.debug((Object)("Profile Description = " + string4));
        this.setProfileDescription(string4);
        this.nodeProfileState = namedNodeMap.getNamedItem(STATE);
        String string5 = this.nodeProfileState.getNodeValue();
        logger.debug((Object)("Profile State = " + string5));
        this.setProfileState(string5);
        this.nodeProfileLastChUser = namedNodeMap.getNamedItem(LASTCHUSER);
        String string6 = this.nodeProfileLastChUser.getNodeValue();
        logger.debug((Object)("Profile LastChUser = " + string6));
        this.setProfileLastChUser(string6);
        this.nodeProfileLastchtmstmp = namedNodeMap.getNamedItem(LASTCHTMSTMP);
        String string7 = this.nodeProfileLastchtmstmp.getNodeValue();
        logger.debug((Object)("Profile lastchtmstmp = " + string7));
        this.setProfileLastchtmstmp(string7);
        this.nodeProfileCreateuser = namedNodeMap.getNamedItem(CREATEUSER);
        String string8 = this.nodeProfileCreateuser.getNodeValue();
        logger.debug((Object)("Profile createuser = " + string8));
        this.setProfileCreateuser(string8);
        nodeList = this.doc.getElementsByTagName(ROOT);
        logger.debug((Object)("root nodeLst.getLength() = " + nodeList.getLength()));
        if (nodeList.getLength() > 1) {
            throw new InvalidObjectException("XML document contains more than 1 root node.");
        }
        Node node = nodeList.item(0);
        if (node.hasChildNodes()) {
            SAPCriteriaNode sAPCriteriaNode = new SAPCriteriaNode(SAPCriteriaNode.SAPCriteriaNodeType.AND);
            this.loadChildNodes(node, sAPCriteriaNode);
            this.sapCriteria.addNode(sAPCriteriaNode);
        }
    }

    private void loadChildNodes(Node node, SAPCriteriaNode sAPCriteriaNode) {
        SAPCriteriaNode sAPCriteriaNode2 = sAPCriteriaNode;
        NodeList nodeList = node.getChildNodes();
        logger.debug((Object)("currentNodeList.getLength() = " + nodeList.getLength()));
        block4: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            RootChildNodeType rootChildNodeType = RootChildNodeType.persistanceCodeToEnum(node2.getNodeName());
            switch (rootChildNodeType) {
                case NODE: {
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    Node node3 = namedNodeMap.getNamedItem(TYPE);
                    logger.debug((Object)("Node type = " + node3));
                    String string = node3.getNodeValue();
                    SAPCriteriaNode.SAPCriteriaNodeType sAPCriteriaNodeType = SAPCriteriaNode.SAPCriteriaNodeType.persistanceCodeToEnum(string);
                    logger.debug((Object)("Child node found: " + node2.getNodeName() + " type = " + sAPCriteriaNodeType));
                    if (!node2.hasChildNodes()) continue block4;
                    SAPCriteriaNode sAPCriteriaNode3 = new SAPCriteriaNode(sAPCriteriaNodeType);
                    this.loadChildNodes(node2, sAPCriteriaNode3);
                    sAPCriteriaNode2.addNode(sAPCriteriaNode3);
                    continue block4;
                }
                case ITEM: {
                    this.addItemToCriteriaNode(sAPCriteriaNode2, node2);
                }
            }
        }
    }

    private void addItemToCriteriaNode(SAPCriteriaNode sAPCriteriaNode, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(DESCRIPTION);
        String string = node2.getNodeValue();
        logger.debug((Object)("Root child item found.  description = " + string));
        SAPCriteriaItem sAPCriteriaItem = new SAPCriteriaItem(string);
        NodeList nodeList = node.getChildNodes();
        logger.debug((Object)("fieldNodes.getLength() = " + nodeList.getLength()));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            SAPCriteriaField sAPCriteriaField = new SAPCriteriaField();
            if (node3.hasChildNodes()) {
                NodeList nodeList2 = node3.getChildNodes();
                logger.debug((Object)("currentField has " + node3.getChildNodes().getLength() + " child nodes."));
                block5: for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node4 = nodeList2.item(j);
                    logger.debug((Object)("fieldChildNode [" + j + "] = " + node4.getNodeName()));
                    SAPCriteriaFieldNodeType sAPCriteriaFieldNodeType = SAPCriteriaFieldNodeType.persistanceCodeToEnum(node4.getNodeName());
                    switch (sAPCriteriaFieldNodeType) {
                        case TEXT: {
                            String string2 = node4.getNodeValue();
                            logger.debug((Object)("NodeName:" + node4.getNodeName() + " Value:" + node4.getNodeValue()));
                            sAPCriteriaField.setFieldName(string2);
                            continue block5;
                        }
                        case CRITERION: {
                            NamedNodeMap namedNodeMap2 = node4.getAttributes();
                            Node node5 = namedNodeMap2.getNamedItem(SIGN);
                            String string3 = node5.getNodeValue();
                            logger.debug((Object)("Criterion Sign = " + string3));
                            Node node6 = namedNodeMap2.getNamedItem(OPT);
                            String string4 = node6.getNodeValue();
                            logger.debug((Object)("Criterion Opt = " + string4));
                            Node node7 = namedNodeMap2.getNamedItem(LOW);
                            String string5 = node7.getNodeValue();
                            logger.debug((Object)("Criterion Low = " + string5));
                            Node node8 = namedNodeMap2.getNamedItem(HIGH);
                            String string6 = node8.getNodeValue();
                            logger.debug((Object)("Criterion High = " + string6));
                            SAPCriterion sAPCriterion = new SAPCriterion(SAPCriterion.SAPCriterionSign.persistanceCodeToEnum(string3), SAPCriterion.SAPCriterionOption.persistanceCodeToEnum(string4), string5, string6);
                            sAPCriteriaField.addCriterion(sAPCriterion);
                        }
                    }
                }
            }
            sAPCriteriaItem.addField(sAPCriteriaField);
        }
        sAPCriteriaNode.addItem(sAPCriteriaItem);
    }

    public void setDoc(Document document) {
        this.doc = document;
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setProfileType(String string) {
        this.nodeProfileType.setNodeValue(string);
    }

    public String getProfileType() {
        return this.nodeProfileType.getNodeValue();
    }

    public void setProfileID(String string) {
        this.nodeProfileID.setNodeValue(string);
    }

    public String getProfileID() {
        return this.nodeProfileID.getNodeValue();
    }

    public void setProfileDescription(String string) {
        this.nodeProfileDescription.setNodeValue(string);
    }

    public String getProfileDescription() {
        return this.nodeProfileDescription.getNodeValue();
    }

    public void setProfileState(String string) {
        this.nodeProfileState.setNodeValue(string);
    }

    public String getProfileState() {
        return this.nodeProfileState.getNodeValue();
    }

    public void setProfileLastChUser(String string) {
        this.nodeProfileLastChUser.setNodeValue(string);
    }

    public String getProfileLastChUser() {
        return this.nodeProfileLastChUser.getNodeValue();
    }

    public void setProfileLastchtmstmp(String string) {
        this.nodeProfileLastchtmstmp.setNodeValue(string);
    }

    public String getProfileLastchtmstmp() {
        return this.nodeProfileLastchtmstmp.getNodeValue();
    }

    public void setProfileCreateuser(String string) {
        this.nodeProfileCreateuser.setNodeValue(string);
    }

    public String getProfileCreateuser() {
        return this.nodeProfileCreateuser.getNodeValue();
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    private static enum SAPCriteriaFieldNodeType implements PersistableEnum<String>
    {
        TEXT("#text"),
        CRITERION("criterion");

        private String criteriaFieldNodeTypeString;
        private static PersistanceCodeToEnumMap<String, SAPCriteriaFieldNodeType> map;

        private SAPCriteriaFieldNodeType(String string2) {
            this.criteriaFieldNodeTypeString = string2;
        }

        public static SAPCriteriaFieldNodeType persistanceCodeToEnum(String string) {
            SAPCriteriaFieldNodeType sAPCriteriaFieldNodeType = map.get(string);
            if (sAPCriteriaFieldNodeType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return sAPCriteriaFieldNodeType;
        }

        @Override
        public String persistanceCode() {
            return this.criteriaFieldNodeTypeString;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])SAPCriteriaFieldNodeType.values());
        }
    }

    private static enum RootChildNodeType implements PersistableEnum<String>
    {
        ITEM("item"),
        NODE("node");

        private String childNodeString;
        private static PersistanceCodeToEnumMap<String, RootChildNodeType> map;

        private RootChildNodeType(String string2) {
            this.childNodeString = string2;
        }

        public static RootChildNodeType persistanceCodeToEnum(String string) {
            RootChildNodeType rootChildNodeType = map.get(string);
            if (rootChildNodeType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return rootChildNodeType;
        }

        @Override
        public String persistanceCode() {
            return this.childNodeString;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])RootChildNodeType.values());
        }
    }
}

