/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.automate;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public enum AutoMateSystemType implements PersistableEnum<Integer>
{
    AUTOMATE_V10(1),
    AUTOMATE_BPA_SERVER_V10(2),
    AUTOMATE_V11(3),
    AUTOMATE_ENTERPRISE_V11(4);

    private int persistanceCode;
    private static PersistanceCodeToEnumMap<Integer, AutoMateSystemType> map;

    private AutoMateSystemType(int n2) {
        this.persistanceCode = n2;
    }

    @Override
    public Integer persistanceCode() {
        return this.persistanceCode;
    }

    public static AutoMateSystemType persistanceCodeToEnum(int n) {
        AutoMateSystemType autoMateSystemType = map.get(n);
        if (autoMateSystemType == null) {
            String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
            throw new IllegalStateException(string);
        }
        return autoMateSystemType;
    }

    public boolean isV11Type() {
        return this.equals(AUTOMATE_V11) || this.equals(AUTOMATE_ENTERPRISE_V11);
    }

    static {
        map = new PersistanceCodeToEnumMap((Enum[])AutoMateSystemType.values());
    }
}

