/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.DayOfWeekTimestampFilter;
import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class SpecialInstanceDays
extends DayOfWeekTimestampFilter {
    private long id;
    private long specialInstanceID;
    private int dayNumber;
    private CalendarObject.PeriodType periodType;
    private static final Logger logger = Logger.getLogger(SpecialInstanceDays.class);

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getSpecialInstanceID() {
        return this.specialInstanceID;
    }

    public void setSpecialInstanceID(long l) {
        this.specialInstanceID = l;
    }

    public int getDayNumber() {
        return this.dayNumber;
    }

    public void setDayNumber(int n) {
        this.dayNumber = n;
    }

    public CalendarObject.PeriodType getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(CalendarObject.PeriodType periodType) {
        this.periodType = periodType;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID[" + this.id + "]");
        stringBuffer.append(".SPC_INST_ID[" + this.specialInstanceID + "]");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public boolean isDayOfPeriodTimeAccepted(Calendar calendar, CalendarObject calendarObject, long l, ParentType parentType, CalendarObject.DayType dayType) {
        if (calendarObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"WARNING: Calendar object is null!");
            }
            return true;
        }
        if (this.dayNumber == 0) {
            return false;
        }
        int n = 0;
        try {
            n = this.dayNumber > 0 ? calendarObject.relativeDayFromBeginOfPeriod(calendar, this.periodType, dayType) : calendarObject.relativeDayFromEndOfPeriod(calendar, this.periodType, dayType);
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            logger.warn((Object)("Special instance calendar object error: " + calendarObjectRangeException.getMessage()));
            return false;
        }
        boolean bl = false;
        int n2 = calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar);
        if (n != 0 && n == Math.abs(this.dayNumber)) {
            bl = TimeHelper.isWithinRange(calendar, n2, this.getStartTime(), this.getEndTime());
        }
        if (bl) {
            return true;
        }
        Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.setTimeInMillis(calendar.getTimeInMillis());
        calendar2.add(5, -1);
        n = 0;
        try {
            n = this.dayNumber > 0 ? calendarObject.relativeDayFromBeginOfPeriod(calendar2, this.periodType, dayType) : calendarObject.relativeDayFromEndOfPeriod(calendar2, this.periodType, dayType);
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            logger.warn((Object)("Special instance calendar object error on midnight rollover check: " + calendarObjectRangeException.getMessage()));
            return false;
        }
        boolean bl2 = false;
        n2 = calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar2);
        if (n != 0 && n == Math.abs(this.dayNumber)) {
            bl2 = TimeHelper.isWithinRange(calendar, n2, this.getStartTime(), this.getEndTime());
        }
        return bl2;
    }
}

