/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SendStatusEvent;
import com.helpsystems.enterprise.core.busobj.SendStatusEventType;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import junit.framework.TestCase;

public class SendStatusEventTest
extends TestCase {
    private SendStatusEvent event;
    private static final String user = "UserName";
    private static final String guid = "guid";
    private static final long prereqObjectID = 12345L;
    private static final long dependencyID = 3456789L;
    private static final PrereqEventType prereqEventType = PrereqEventType.AGENT_EVENT;
    private static final PrereqStatusType prereqStatusType = PrereqStatusType.OCCURRED;

    public SendStatusEventTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        long l = 0L;
        this.event = SendStatusEvent.sendObjectEvent(user, guid, prereqEventType, 12345L, l, PrereqStatusType.OCCURRED, 0L);
        long l2 = this.event.getTimeStamp();
        this.event.setActionRequest(l2);
    }

    protected void tearDown() throws Exception {
        this.event = null;
        super.tearDown();
    }

    public void testEqualsObject() {
        long l = this.event.getTimeStamp();
        SendStatusEventTest.assertFalse((boolean)this.event.equals(null));
        SendStatusEventTest.assertFalse((boolean)this.event.equals(new Object()));
        SendStatusEventTest.assertTrue((boolean)this.event.equals((Object)this.event));
        long l2 = 0L;
        SendStatusEvent sendStatusEvent = SendStatusEvent.sendObjectEvent(user, guid, PrereqEventType.AGENT_EVENT, 12345L, l2, PrereqStatusType.OCCURRED, l);
        sendStatusEvent.setActionRequest(l);
        SendStatusEvent sendStatusEvent2 = SendStatusEvent.sendObjectEvent("different_user", guid, PrereqEventType.JOB_STATUS_CHANGE, 654321L, l2, PrereqStatusType.COMPLETED, l + 3L);
        sendStatusEvent2.setActionRequest(l);
        SendStatusEventTest.assertTrue((boolean)this.event.equals((Object)sendStatusEvent));
        SendStatusEventTest.assertTrue((boolean)sendStatusEvent.equals((Object)this.event));
        SendStatusEventTest.assertTrue((boolean)this.event.equals((Object)sendStatusEvent2));
        sendStatusEvent.setGUID("differentGUID");
        SendStatusEventTest.assertFalse((boolean)this.event.equals((Object)sendStatusEvent));
        sendStatusEvent.setGUID(this.event.getGUID());
        sendStatusEvent.setActionRequest(l + 2L);
        SendStatusEventTest.assertFalse((boolean)this.event.equals((Object)sendStatusEvent));
    }

    public void testSetActionCode() {
        this.event.setActionCode();
        SendStatusEventTest.assertEquals((int)2006, (int)this.event.getActionCode());
    }

    public void testSetSendStatusEventType() {
        this.event.setSendStatusEventType(SendStatusEventType.NOT_APPLICABLE);
        SendStatusEventTest.assertEquals((Object)SendStatusEventType.NOT_APPLICABLE, (Object)this.event.getSendStatusEventType());
    }

    public void testSetPrereqEventType() {
        this.event.setPrereqEventType(PrereqEventType.AGENT_EVENT);
        SendStatusEventTest.assertEquals((Object)PrereqEventType.AGENT_EVENT, (Object)this.event.getPrereqEventType());
    }

    public void testSetPrereqStatusType() {
        this.event.setPrereqStatusType(PrereqStatusType.BLANK);
        SendStatusEventTest.assertEquals((Object)PrereqStatusType.BLANK, (Object)this.event.getPrereqStatusType());
    }

    public void testSetTimeStamp() {
        this.event.setTimeStamp(1239042134L);
        SendStatusEventTest.assertEquals((long)1239042134L, (long)this.event.getTimeStamp());
    }

    public void testSetDependencyID() {
        this.event.setDependencyID(1234789L);
        SendStatusEventTest.assertEquals((long)1234789L, (long)this.event.getDependencyID());
    }

    public void testSetPrereqObjectID() {
        this.event.setPrereqObjectID(345789L);
        SendStatusEventTest.assertEquals((long)345789L, (long)this.event.getPrereqObjectID());
    }

    public void testToString() {
        String string = "Object status OCCURRED for event type AGENT_EVENT was sent by UserName for object id 12345";
        String string2 = this.event.toString();
        SendStatusEventTest.assertEquals((String)string, (String)string2);
        long l = 0L;
        long l2 = 0L;
        this.event = SendStatusEvent.sendPrereqEvent(user, guid, prereqEventType, prereqStatusType, 3456789L, l, l2, 0L);
        string = "Prerequisite status OCCURRED for event type AGENT_EVENT was sent by UserName for dependency id 3456789";
        string2 = this.event.toString();
        SendStatusEventTest.assertEquals((String)string, (String)string2);
    }

    public void testGetActionString() {
        SendStatusEventTest.assertEquals((String)"SendStatusEvent", (String)this.event.getActionString());
    }

    public void testGetEventData() {
        String string = "kljqwerjlkaojihasdlnkjnlqwerlkasdfljkqwrelkjasdf";
        this.event.setEventData(string);
        SendStatusEventTest.assertEquals((String)string, (String)this.event.getEventData());
    }

    public void testGetDepJobID() {
        this.event.setDepJobID(293824984L);
        SendStatusEventTest.assertEquals((long)293824984L, (long)this.event.getDepJobID());
    }
}

