/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.DayOfWeekTimestampFilter;
import com.helpsystems.enterprise.core.busobj.DayOfWeekTimestampFilterTest;
import com.helpsystems.enterprise.core.busobj.ReactivityDays;
import com.helpsystems.enterprise.core.busobj.WindowEndOption;
import com.helpsystems.enterprise.core.busobj.WindowStartOption;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.TimeZone;

public class ReactivityDaysTest
extends DayOfWeekTimestampFilterTest {
    private ReactivityDays rds;
    private CalendarObject stdCal;
    TimeZone tz;

    public ReactivityDaysTest(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.stdCal = new CalendarObject();
        this.stdCal.setID(1234567890L);
        this.stdCal.setName("TESTCAL");
        this.stdCal.setDescription("Test Calendar");
        int n = 20100704;
        int n2 = 20101225;
        int[] nArray = new int[]{n, n2};
        this.stdCal.setHolidays(nArray);
        EnumSet<CalendarObject.DayOfWeek> enumSet = EnumSet.of(CalendarObject.DayOfWeek.SUN);
        this.stdCal.setNonWorkdayByDOW(enumSet);
        this.tz = TimeZone.getTimeZone("America/New_York");
        this.rds = new ReactivityDays();
        this.rds.setId(4321L);
        this.rds.setJobID(1234L);
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setStartTime(0);
        this.rds.setEndTime(0);
    }

    public void testPersistanceCodeToEnum() {
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(null));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(""));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("   "));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.EVERY, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("Y"));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIRST, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("1"));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.SECOND, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("2"));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.THIRD, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("3"));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FOURTH, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("4"));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIFTH, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("5"));
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.LAST, (Object)DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("L"));
        try {
            DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum("XYZ");
            ReactivityDaysTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetId() {
        this.rds.setId(4321L);
        ReactivityDaysTest.assertEquals((long)4321L, (long)this.rds.getId());
    }

    public void testSetJobId() {
        this.rds.setJobID(1234L);
        ReactivityDaysTest.assertEquals((long)1234L, (long)this.rds.getJobID());
    }

    public void testToString() {
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.EVERY);
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.FIRST);
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.SECOND);
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.THIRD);
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.FOURTH);
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.FIFTH);
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setStartTime(1023);
        this.rds.setEndTime(2345);
        String string = "Reactivity Days: ID[4321].JOBID[1234].MON[FIRST].TUE[SECOND].WED[THIRD].THU[FOURTH].FRI[FIFTH].SAT[NEVER].SUN[EVERY].START_TIME[1023].END_TIME[2345]";
        String string2 = this.rds.toString();
        ReactivityDaysTest.assertEquals((String)string, (String)string2);
    }

    public void testFourthThursday() {
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.FOURTH);
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setStartTime(1200);
        this.rds.setEndTime(1500);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 1, 12, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 12, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 15, 12, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 22, 11, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 22, 12, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 22, 15, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 22, 15, 0, 0, 1, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 29, 12, 0, 0, 0, this.stdCal, false);
    }

    public void testEveryThursday() {
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.EVERY);
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setStartTime(1200);
        this.rds.setEndTime(1500);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 12, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 11, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 1, 12, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 12, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 15, 12, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 22, 12, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 29, 12, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 1, 15, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 15, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 15, 15, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 22, 15, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 29, 15, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 15, 0, 0, 1, this.stdCal, false);
    }

    public void testLastThursday() {
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.LAST);
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setStartTime(1200);
        this.rds.setEndTime(1500);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 12, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 11, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 1, 12, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 12, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 15, 12, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 22, 12, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 1, 15, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 8, 15, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 15, 15, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 22, 15, 0, 0, 0, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 29, 11, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 29, 12, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 29, 15, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 29, 15, 0, 0, 1, this.stdCal, false);
    }

    public void testMidnightRollover() {
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.EVERY);
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setStartTime(2300);
        this.rds.setEndTime(100);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 6, 22, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 6, 23, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 7, 1, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 7, 1, 0, 0, 1, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 27, 22, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 27, 23, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 28, 1, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 28, 1, 0, 0, 1, this.stdCal, false);
    }

    public void testMonthEnd() {
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.LAST);
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setStartTime(2300);
        this.rds.setEndTime(100);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 30, 22, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 30, 23, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 3, 30, 23, 59, 59, 999, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 4, 1, 0, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 4, 1, 1, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 4, 1, 1, 0, 0, 1, this.stdCal, false);
    }

    public void testDSTTransition() {
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.EVERY);
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        this.rds.setStartTime(230);
        this.rds.setEndTime(330);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 1, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 30, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 30, 0, 1, this.stdCal, false);
        this.rds.setStartTime(130);
        this.rds.setEndTime(230);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 1, 29, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 1, 30, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 1, 59, 59, 999, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 0, 0, 0, this.stdCal, false);
        this.rds.setStartTime(201);
        this.rds.setEndTime(259);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 1, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 0, 0, 0, this.stdCal, false);
        this.rds.setStartTime(200);
        this.rds.setEndTime(300);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 1, 59, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 0, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 0, 0, 1, this.stdCal, false);
        this.rds.setStartTime(159);
        this.rds.setEndTime(301);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 1, 58, 59, 999, this.stdCal, false);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 1, 59, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 1, 0, 0, this.stdCal, true);
        ReactivityDaysTest.testDate(this.rds, this.tz, 2010, 2, 14, 3, 1, 0, 1, this.stdCal, false);
    }

    private static void testDate(ReactivityDays reactivityDays, TimeZone timeZone, int n, int n2, int n3, int n4, int n5, int n6, int n7, CalendarObject calendarObject, boolean bl) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(n, n2, n3, n4, n5, n6);
        calendar.set(14, n7);
        long l = 0L;
        ReactivityDaysTest.assertEquals((boolean)bl, (boolean)reactivityDays.isTimeAccepted(calendar, l, calendarObject));
    }

    @Override
    public void testSetDayOption_Fri() {
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.NEVER);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)this.rds.getDayOption_Fri());
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.EVERY);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.EVERY, (Object)this.rds.getDayOption_Fri());
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.FIRST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIRST, (Object)this.rds.getDayOption_Fri());
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.SECOND);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.SECOND, (Object)this.rds.getDayOption_Fri());
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.THIRD);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.THIRD, (Object)this.rds.getDayOption_Fri());
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.FOURTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FOURTH, (Object)this.rds.getDayOption_Fri());
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.FIFTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIFTH, (Object)this.rds.getDayOption_Fri());
        this.rds.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.LAST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.LAST, (Object)this.rds.getDayOption_Fri());
    }

    @Override
    public void testSetDayOption_Mon() {
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.NEVER);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)this.rds.getDayOption_Mon());
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.EVERY);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.EVERY, (Object)this.rds.getDayOption_Mon());
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.FIRST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIRST, (Object)this.rds.getDayOption_Mon());
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.SECOND);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.SECOND, (Object)this.rds.getDayOption_Mon());
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.THIRD);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.THIRD, (Object)this.rds.getDayOption_Mon());
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.FOURTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FOURTH, (Object)this.rds.getDayOption_Mon());
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.FIFTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIFTH, (Object)this.rds.getDayOption_Mon());
        this.rds.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.LAST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.LAST, (Object)this.rds.getDayOption_Mon());
    }

    @Override
    public void testSetDayOption_Sat() {
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.NEVER);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)this.rds.getDayOption_Sat());
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.EVERY);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.EVERY, (Object)this.rds.getDayOption_Sat());
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.FIRST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIRST, (Object)this.rds.getDayOption_Sat());
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.SECOND);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.SECOND, (Object)this.rds.getDayOption_Sat());
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.THIRD);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.THIRD, (Object)this.rds.getDayOption_Sat());
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.FOURTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FOURTH, (Object)this.rds.getDayOption_Sat());
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.FIFTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIFTH, (Object)this.rds.getDayOption_Sat());
        this.rds.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.LAST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.LAST, (Object)this.rds.getDayOption_Sat());
    }

    @Override
    public void testSetDayOption_Sun() {
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.NEVER);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)this.rds.getDayOption_Sun());
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.EVERY);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.EVERY, (Object)this.rds.getDayOption_Sun());
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.FIRST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIRST, (Object)this.rds.getDayOption_Sun());
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.SECOND);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.SECOND, (Object)this.rds.getDayOption_Sun());
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.THIRD);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.THIRD, (Object)this.rds.getDayOption_Sun());
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.FOURTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FOURTH, (Object)this.rds.getDayOption_Sun());
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.FIFTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIFTH, (Object)this.rds.getDayOption_Sun());
        this.rds.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.LAST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.LAST, (Object)this.rds.getDayOption_Sun());
    }

    @Override
    public void testSetDayOption_Thu() {
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.NEVER);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)this.rds.getDayOption_Thu());
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.EVERY);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.EVERY, (Object)this.rds.getDayOption_Thu());
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.FIRST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIRST, (Object)this.rds.getDayOption_Thu());
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.SECOND);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.SECOND, (Object)this.rds.getDayOption_Thu());
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.THIRD);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.THIRD, (Object)this.rds.getDayOption_Thu());
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.FOURTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FOURTH, (Object)this.rds.getDayOption_Thu());
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.FIFTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIFTH, (Object)this.rds.getDayOption_Thu());
        this.rds.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.LAST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.LAST, (Object)this.rds.getDayOption_Thu());
    }

    @Override
    public void testSetDayOption_Tue() {
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.NEVER);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)this.rds.getDayOption_Tue());
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.EVERY);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.EVERY, (Object)this.rds.getDayOption_Tue());
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.FIRST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIRST, (Object)this.rds.getDayOption_Tue());
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.SECOND);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.SECOND, (Object)this.rds.getDayOption_Tue());
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.THIRD);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.THIRD, (Object)this.rds.getDayOption_Tue());
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.FOURTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FOURTH, (Object)this.rds.getDayOption_Tue());
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.FIFTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIFTH, (Object)this.rds.getDayOption_Tue());
        this.rds.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.LAST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.LAST, (Object)this.rds.getDayOption_Tue());
    }

    @Override
    public void testSetDayOption_Wed() {
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.NEVER);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.NEVER, (Object)this.rds.getDayOption_Wed());
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.EVERY);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.EVERY, (Object)this.rds.getDayOption_Wed());
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.FIRST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIRST, (Object)this.rds.getDayOption_Wed());
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.SECOND);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.SECOND, (Object)this.rds.getDayOption_Wed());
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.THIRD);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.THIRD, (Object)this.rds.getDayOption_Wed());
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.FOURTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FOURTH, (Object)this.rds.getDayOption_Wed());
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.FIFTH);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.FIFTH, (Object)this.rds.getDayOption_Wed());
        this.rds.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.LAST);
        ReactivityDaysTest.assertEquals((Object)DayOfWeekTimestampFilter.DayOption.LAST, (Object)this.rds.getDayOption_Wed());
    }

    @Override
    public void testSetEndTime() {
        this.rds.setEndTime(12345);
        ReactivityDaysTest.assertEquals((int)12345, (int)this.rds.getEndTime());
    }

    @Override
    public void testSetStartTime() {
        this.rds.setStartTime(54321);
        ReactivityDaysTest.assertEquals((int)54321, (int)this.rds.getStartTime());
    }

    @Override
    public void testSetStartOption() {
        this.rds.setStartOption(WindowStartOption.CHECK_PREREQS);
        ReactivityDaysTest.assertEquals((Object)WindowStartOption.CHECK_PREREQS, (Object)this.rds.getStartOption());
    }

    @Override
    public void testSetEndOption() {
        this.rds.setEndOption(WindowEndOption.CANCEL_JOB);
        ReactivityDaysTest.assertEquals((Object)WindowEndOption.CANCEL_JOB, (Object)this.rds.getEndOption());
    }
}

