/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.AgentEventProcess;
import com.helpsystems.enterprise.core.busobj.ManualEvent;
import com.helpsystems.enterprise.core.busobj.ProcessEvent;
import junit.framework.TestCase;

public class ProcessEventTest
extends TestCase {
    ProcessEvent pe;
    AgentEventProcess ap;
    long longMax = Long.MAX_VALUE;
    long longMin = Long.MIN_VALUE;

    protected void setUp() throws Exception {
        super.setUp();
        this.pe = new ProcessEvent();
        this.ap = new AgentEventProcess();
    }

    protected void tearDown() throws Exception {
        this.pe = null;
        this.ap = null;
        super.tearDown();
    }

    public void testSetAgentProcessToNullCreatesNewAgentProcess() {
        this.pe.setAgentEventProcess(null);
        ProcessEventTest.assertNotNull((Object)((Object)this.pe.getAgentEventProcess()));
    }

    public void testSetOID() {
        this.pe.setOID(22832L);
        ProcessEventTest.assertEquals((long)22832L, (long)this.pe.getOID());
        this.pe.setOID(this.longMin);
        ProcessEventTest.assertEquals((long)this.longMin, (long)this.pe.getOID());
        this.pe.setOID(this.longMax);
        ProcessEventTest.assertEquals((long)this.longMax, (long)this.pe.getOID());
    }

    public void testSetAgentProcess() {
        this.pe.setAgentEventProcess(this.ap);
        ProcessEventTest.assertEquals((Object)((Object)this.ap), (Object)((Object)this.pe.getAgentEventProcess()));
    }

    public void testSetProductIIDint() {
        this.pe.setProductIIDInt(12345);
        ProcessEventTest.assertEquals((int)12345, (int)this.pe.getProductIIDInt());
    }

    public void testClone() {
        this.pe.setTargetID(1L);
        this.pe.setAgentEventProcess(this.ap);
        this.pe.setName("TESTNAME");
        this.pe.setDescription("Test description");
        ProcessEvent processEvent = new ProcessEvent();
        processEvent.clone(this.pe);
        ProcessEventTest.assertEquals((Object)((Object)this.ap), (Object)((Object)processEvent.getAgentEventProcess()));
        ProcessEventTest.assertEquals((Object)((Object)processEvent), (Object)((Object)this.pe));
        ProcessEventTest.assertFalse((processEvent == this.pe ? 1 : 0) != 0);
    }

    public void testValidateRejectsProcessTimeAsOnlyCriteria() {
        this.ap.setProcessTime(2);
        this.pe.setAgentEventProcess(this.ap);
        this.pe.setTargetID(1L);
    }

    public void testValidateAcceptsProcessNameAsOnlyCriteria() {
        this.ap.setProcessName("/some/process/name.sh");
        this.pe.setAgentEventProcess(this.ap);
        this.pe.setTargetID(1L);
    }

    public void testValidateAcceptsUserNameAsOnlyCriteria() {
        this.ap.setUserName("SOMEUSER");
        this.pe.setAgentEventProcess(this.ap);
        this.pe.setTargetID(1L);
    }

    public void testValidateAcceptsMultipleCriteria() {
        this.pe.setTargetID(1L);
        this.pe.setAgentEventProcess(this.ap);
        this.ap.setProcessTime(2);
        this.ap.setProcessName("/some/process/name.sh");
        this.ap.setUserName("");
        this.ap.setProcessTime(0);
        this.ap.setProcessName("/some/process/name.sh");
        this.ap.setUserName("SOMEUSER");
        this.ap.setProcessTime(2);
        this.ap.setProcessName("");
        this.ap.setUserName("SOMEUSER");
        this.ap.setProcessTime(2);
        this.ap.setProcessName("/some/process/name.sh");
        this.ap.setUserName("SOMEUSER");
        this.ap.setProcessTime(0);
        this.ap.setProcessName("");
        this.ap.setUserName("");
    }

    public void testValidateRequiresAtLeastOneCriteria() {
        this.pe.setTargetID(1L);
        this.pe.setAgentEventProcess(this.ap);
    }

    public void testMeetsFireCriteriaRecognizesHit() {
        this.pe.setTargetID(1L);
        this.pe.setAgentEventProcess(this.ap);
        this.ap.setProcessTime(0);
        this.ap.setProcessName("");
        this.ap.setUserName("SOMEUSER");
        ProcessEventTest.assertTrue((boolean)this.pe.meetsFireCriteria("/some/process/name.sh", "SOMEUSER", 2));
        ProcessEventTest.assertTrue((boolean)this.pe.meetsFireCriteria("", "SOMEUSER", 0));
        this.ap.setProcessTime(3);
        this.ap.setProcessName("");
        this.ap.setUserName("SOMEUSER");
        ProcessEventTest.assertTrue((boolean)this.pe.meetsFireCriteria("/some/process/name.sh", "SOMEUSER", 4));
        ProcessEventTest.assertTrue((boolean)this.pe.meetsFireCriteria("", "SOMEUSER", 3));
        this.ap.setUserName("bobo");
        this.ap.setProcessName("");
        this.ap.setProcessTime(0);
        this.ap.setUserCompareValue(0);
        ProcessEventTest.assertTrue((boolean)this.ap.meetsFireCriteria("", "bobofette", 0));
    }

    public void testValidateFailsIfNoFeedbackSelected() {
        this.ap.setUserName("SOMEUSER");
        this.pe.setAgentEventProcess(this.ap);
        this.pe.setTargetID(1L);
    }

    public void testMeetsFireCriteriaRecognizesMiss() {
        this.pe.setTargetID(1L);
        this.pe.setAgentEventProcess(this.ap);
        this.ap.setProcessTime(3);
        this.ap.setProcessName("name.sh");
        this.ap.setProcessCompareValue(2);
        this.ap.setUserName("SOMEUSER");
        this.ap.setUserCompareValue(0);
        ProcessEventTest.assertFalse((boolean)this.pe.meetsFireCriteria("/some/process/name.sh", "SOMEUSER", 0));
        ProcessEventTest.assertFalse((boolean)this.pe.meetsFireCriteria("/some/process/name.sh", "SOMEUSER", 2));
        ProcessEventTest.assertFalse((boolean)this.pe.meetsFireCriteria("", "SOMEUSER", 3));
        ProcessEventTest.assertFalse((boolean)this.pe.meetsFireCriteria("/some/process/other.sh", "SOMEUSER5", 4));
        ProcessEventTest.assertFalse((boolean)this.pe.meetsFireCriteria("/some/process/name.sh", "", 4));
        ProcessEventTest.assertFalse((boolean)this.pe.meetsFireCriteria("/some/process/name.sh", "WRONGUSR", 4));
        this.ap.setProcessCompareValue(4);
        ProcessEventTest.assertFalse((boolean)this.pe.meetsFireCriteria("name", "user", 6));
        this.ap.setUserCompareValue(4);
        ProcessEventTest.assertFalse((boolean)this.ap.userCompareMatches("Zippy"));
        this.ap.setUserName("");
        this.ap.setUserCompareValue(0);
        ProcessEventTest.assertFalse((boolean)this.ap.meetsFireCriteria("", "", 2));
    }

    public void testIsDifferentThan() {
        this.pe.setTargetID(12345L);
        this.pe.setName("Event1");
        this.pe.setDescription("A test event");
        this.pe.setProductIIDInt(9494);
        this.pe.setDisabled(true);
        this.pe.setCycle(666);
        this.pe.setOID(58493L);
        this.pe.setFromTime(1234);
        this.pe.setToTime(2468);
        this.ap.setOID(29292L);
        this.ap.setProcessCompareValue(0);
        this.ap.setProcessName("ProcName");
        this.ap.setUserCompareValue(0);
        this.ap.setUserName("UserName");
        this.ap.setProcessTime(1234);
        this.pe.setAgentEventProcess(this.ap);
        AgentEventProcess agentEventProcess = new AgentEventProcess();
        agentEventProcess.setProcessCompareValue(2);
        agentEventProcess.setProcessName("OtherProcName");
        agentEventProcess.setUserCompareValue(2);
        agentEventProcess.setUserName("OtherUserName");
        agentEventProcess.setProcessTime(4321);
        ManualEvent manualEvent = new ManualEvent();
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(manualEvent));
        ProcessEvent processEvent = new ProcessEvent();
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(processEvent));
        processEvent.setTargetID(this.pe.getTargetID());
        processEvent.setName(this.pe.getName());
        processEvent.setDescription(this.pe.getDescription());
        processEvent.setProductIIDInt(this.pe.getProductIIDInt());
        processEvent.setDisabled(this.pe.getDisabled());
        processEvent.setCycle(this.pe.getCycle());
        processEvent.setOID(this.pe.getOID());
        processEvent.setFromTime(this.pe.getFromTime());
        processEvent.setToTime(this.pe.getToTime());
        processEvent.setAgentEventProcess(agentEventProcess);
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(processEvent));
        agentEventProcess.setOID(this.ap.getOID());
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(processEvent));
        agentEventProcess.setProcessCompareValue(this.ap.getProcessCompareValue());
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(processEvent));
        agentEventProcess.setProcessName(this.ap.getProcessName());
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(processEvent));
        agentEventProcess.setUserCompareValue(this.ap.getUserCompareValue());
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(processEvent));
        agentEventProcess.setUserName(this.ap.getUserName());
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(processEvent));
        agentEventProcess.setProcessTime(this.ap.getProcessTime());
        ProcessEventTest.assertFalse((boolean)this.pe.isDifferentThan(processEvent));
        agentEventProcess.setOID(0L);
        ProcessEventTest.assertTrue((boolean)this.pe.isDifferentThan(processEvent));
    }
}

