/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.NotificationList;
import com.helpsystems.enterprise.core.busobj.User;
import junit.framework.TestCase;

public class NotificationListTest
extends TestCase {
    private NotificationList list;
    private User u1;
    private User u2;
    private User u3;

    protected void setUp() throws Exception {
        super.setUp();
        this.list = new NotificationList();
        this.u1 = new User();
        this.u1.setID(1234L);
        this.u1.setEmailAddress("user1234@test.com");
        this.u2 = new User();
        this.u2.setID(3456L);
        this.u2.setEmailAddress("bono@test.com");
        this.u3 = new User();
        this.u3.setID(5678L);
        this.u3.setEmailAddress("user5678@test.com");
    }

    protected void tearDown() throws Exception {
        this.u1 = null;
        this.u2 = null;
        this.u3 = null;
        this.list = null;
        super.tearDown();
    }

    public void testAddUser() {
        this.list.addUser(this.u1);
        User[] userArray = this.list.getUsers();
        NotificationListTest.assertEquals((int)1, (int)userArray.length);
    }

    public void testAddUserAfterPosition() {
        this.list.addUser(this.u1);
        this.list.addUser(this.u2);
        this.list.addUser(this.u3, 0);
        User[] userArray = this.list.getUsers();
        NotificationListTest.assertEquals((int)3, (int)userArray.length);
        NotificationListTest.assertEquals((Object)((Object)this.u1), (Object)((Object)userArray[0]));
        NotificationListTest.assertEquals((Object)((Object)this.u3), (Object)((Object)userArray[1]));
        NotificationListTest.assertEquals((Object)((Object)this.u2), (Object)((Object)userArray[2]));
    }

    public void testSetOid() {
        this.list.setOid(123456L);
        NotificationListTest.assertEquals((long)123456L, (long)this.list.getOid());
        try {
            this.list.setOid(45678L);
            NotificationListTest.fail((String)"Allowed resetting OID");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testHasUsers() {
        NotificationListTest.assertFalse((boolean)this.list.hasUsers());
        this.list.addUser(this.u1);
        NotificationListTest.assertTrue((boolean)this.list.hasUsers());
    }

    public void testGetUniqueEmailAddresses() {
        this.list.addUser(this.u1);
        this.list.addUser(this.u2);
        this.list.addUser(this.u3);
        this.list.addEmailContact("thing1@suess.org");
        this.list.addEmailContact("thing2@suess.org");
        this.list.addEmailContact("bono@test.com");
        this.list.addEmailContact("bono@test.com");
        String[] stringArray = this.list.getListOfUniqueEmails();
        NotificationListTest.assertEquals((int)5, (int)stringArray.length);
        System.out.println("Show the 5 addresses - Mixed version with triplicate");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    public void testGetUniqueEmailAddressesUsersOnly() {
        this.list.addUser(this.u1);
        this.list.addUser(this.u2);
        this.list.addUser(this.u3);
        String[] stringArray = this.list.getListOfUniqueEmails();
        NotificationListTest.assertEquals((int)3, (int)stringArray.length);
        System.out.println("Show the 3 addresses - User type only");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    public void testGetUniqueEmailAddresses2() {
        this.list.addEmailContact("thing1@suess.org");
        this.list.addEmailContact("thing2@suess.org");
        this.list.addEmailContact("bono@test.com");
        this.list.addEmailContact("bono@test.com");
        String[] stringArray = this.list.getListOfUniqueEmails();
        NotificationListTest.assertEquals((int)3, (int)stringArray.length);
        System.out.println("Show the 3 addresses - Email contacts only");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    public void testGetUniqueEmailAddresses3() {
        String[] stringArray = this.list.getListOfUniqueEmails();
        NotificationListTest.assertEquals((int)0, (int)stringArray.length);
        System.out.println("Show the 0 addresses - Empty list");
    }

    public void testGetUniqueEmailAddresses4() {
        this.list.addUser(null);
        try {
            this.list.addEmailContact(null);
            NotificationListTest.fail((String)"Accepted null when it should not have.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String[] stringArray = this.list.getListOfUniqueEmails();
        NotificationListTest.assertEquals((int)0, (int)stringArray.length);
        System.out.println("Show the empty list, adding null user");
    }
}

