/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobMonitor;
import junit.framework.TestCase;

public class JobMonitorTest
extends TestCase {
    private JobMonitor mon;

    protected void setUp() throws Exception {
        super.setUp();
        this.mon = new JobMonitor();
    }

    protected void tearDown() throws Exception {
        this.mon = null;
        super.tearDown();
    }

    public void testConstructors() {
        this.mon = new JobMonitor(123456L, 99L, 234567L, 345678L, JobMonitor.MonitorType.OVERRUN, 456789L);
        JobMonitorTest.assertEquals((long)123456L, (long)this.mon.getJobHistoryID());
        JobMonitorTest.assertEquals((long)99L, (long)this.mon.getJobSuiteHistoryID());
        JobMonitorTest.assertEquals((long)234567L, (long)this.mon.getJobID());
        JobMonitorTest.assertEquals((long)345678L, (long)this.mon.getAgentID());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.OVERRUN, (Object)this.mon.getMonitorType());
        JobMonitorTest.assertEquals((long)456789L, (long)this.mon.getScheduledTime());
        JobHistory jobHistory = new JobHistory();
        jobHistory.setId(5544332L);
        jobHistory.setJobID(4433221L);
        jobHistory.setAgentID(3322111L);
        jobHistory.setScheduledTime(6655443L);
        this.mon = new JobMonitor(jobHistory, JobMonitor.MonitorType.LATESTART, JobMonitor.MonitorOption.TARGET_TIME, 123456L);
        JobMonitorTest.assertEquals((long)5544332L, (long)this.mon.getJobHistoryID());
        JobMonitorTest.assertEquals((long)4433221L, (long)this.mon.getJobID());
        JobMonitorTest.assertEquals((long)3322111L, (long)this.mon.getAgentID());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.LATESTART, (Object)this.mon.getMonitorType());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.TARGET_TIME, (Object)this.mon.getMonitorOption());
        JobMonitorTest.assertEquals((long)6655443L, (long)this.mon.getScheduledTime());
        JobMonitorTest.assertEquals((long)123456L, (long)this.mon.getMonitorTime());
    }

    public void testGetJobRunDuration() {
        this.mon.setJobStartTime(9000000L);
        this.mon.setJobEndTime(9123456L);
        JobMonitorTest.assertEquals((long)123456L, (long)this.mon.getJobRunDuration());
    }

    public void testToString() {
        JobHistory jobHistory = new JobHistory();
        jobHistory.setId(5544332L);
        jobHistory.setJobID(4433221L);
        jobHistory.setJobSuiteHistoryID(99L);
        jobHistory.setAgentID(3322111L);
        jobHistory.setScheduledTime(6655443L);
        this.mon = new JobMonitor(jobHistory, JobMonitor.MonitorType.LATESTART, JobMonitor.MonitorOption.TARGET_TIME, 123456L);
        String string = "jobHistoryOID:5544332 jobSuiteHistoryID:99 monitorType:LATESTART monitorOption:TARGET_TIME";
        String string2 = this.mon.toString();
        JobMonitorTest.assertEquals((String)string, (String)string2);
    }

    public void testIsJobStarted() {
        this.mon.setJobStarted(true);
        JobMonitorTest.assertTrue((boolean)this.mon.isJobStarted());
        this.mon.setJobStarted(false);
        JobMonitorTest.assertFalse((boolean)this.mon.isJobStarted());
    }

    public void testIsJobCompleted() {
        this.mon.setJobCompleted(true);
        JobMonitorTest.assertTrue((boolean)this.mon.isJobCompleted());
        this.mon.setJobCompleted(false);
        JobMonitorTest.assertFalse((boolean)this.mon.isJobCompleted());
    }

    public void testSetJobHistoryID() {
        this.mon.setJobHistoryID(12345L);
        JobMonitorTest.assertEquals((long)12345L, (long)this.mon.getJobHistoryID());
    }

    public void testSetJobID() {
        this.mon.setJobID(54321L);
        JobMonitorTest.assertEquals((long)54321L, (long)this.mon.getJobID());
    }

    public void testSetAgentID() {
        this.mon.setAgentID(8765432L);
        JobMonitorTest.assertEquals((long)8765432L, (long)this.mon.getAgentID());
    }

    public void testSetMonitorType() {
        this.mon.setMonitorType(JobMonitor.MonitorType.LATESTART);
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.LATESTART, (Object)this.mon.getMonitorType());
        this.mon.setMonitorType(JobMonitor.MonitorType.OVERRUN);
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.OVERRUN, (Object)this.mon.getMonitorType());
        this.mon.setMonitorType(JobMonitor.MonitorType.UNDERRUN);
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.UNDERRUN, (Object)this.mon.getMonitorType());
        this.mon.setMonitorType(JobMonitor.MonitorType.NONE);
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.NONE, (Object)this.mon.getMonitorType());
    }

    public void testSetMonitorTypeAsInt() {
        this.mon.setMonitorTypeAsInt(0);
        JobMonitorTest.assertEquals((int)0, (int)this.mon.getMonitorTypeAsInt());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.NONE, (Object)this.mon.getMonitorType());
        this.mon.setMonitorTypeAsInt(1);
        JobMonitorTest.assertEquals((int)1, (int)this.mon.getMonitorTypeAsInt());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.UNDERRUN, (Object)this.mon.getMonitorType());
        this.mon.setMonitorTypeAsInt(2);
        JobMonitorTest.assertEquals((int)2, (int)this.mon.getMonitorTypeAsInt());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.OVERRUN, (Object)this.mon.getMonitorType());
        this.mon.setMonitorTypeAsInt(3);
        JobMonitorTest.assertEquals((int)3, (int)this.mon.getMonitorTypeAsInt());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.LATESTART, (Object)this.mon.getMonitorType());
    }

    public void testSetMonitorOption() {
        this.mon.setMonitorOption(JobMonitor.MonitorOption.NONE);
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.NONE, (Object)this.mon.getMonitorOption());
        this.mon.setMonitorOption(JobMonitor.MonitorOption.RUN_DURATION);
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.RUN_DURATION, (Object)this.mon.getMonitorOption());
        this.mon.setMonitorOption(JobMonitor.MonitorOption.TARGET_TIME);
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.TARGET_TIME, (Object)this.mon.getMonitorOption());
    }

    public void testSetMonitorOptionAsInt() {
        this.mon.setMonitorOptionAsInt(0);
        JobMonitorTest.assertEquals((int)0, (int)this.mon.getMonitorOptionAsInt());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.NONE, (Object)this.mon.getMonitorOption());
        this.mon.setMonitorOptionAsInt(1);
        JobMonitorTest.assertEquals((int)1, (int)this.mon.getMonitorOptionAsInt());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.RUN_DURATION, (Object)this.mon.getMonitorOption());
        this.mon.setMonitorOptionAsInt(2);
        JobMonitorTest.assertEquals((int)2, (int)this.mon.getMonitorOptionAsInt());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.TARGET_TIME, (Object)this.mon.getMonitorOption());
    }

    public void testSetScheduledTime() {
        this.mon.setScheduledTime(1234567L);
        JobMonitorTest.assertEquals((long)1234567L, (long)this.mon.getScheduledTime());
    }

    public void testSetMonitorTime() {
        this.mon.setMonitorTime(7654321L);
        JobMonitorTest.assertEquals((long)7654321L, (long)this.mon.getMonitorTime());
    }

    public void testSetJobStartTime() {
        this.mon.setJobStartTime(5544332L);
        JobMonitorTest.assertEquals((long)5544332L, (long)this.mon.getJobStartTime());
    }

    public void testSetJobEndTime() {
        this.mon.setJobEndTime(5443321L);
        JobMonitorTest.assertEquals((long)5443321L, (long)this.mon.getJobEndTime());
    }

    public void testSetOID() {
        this.mon.setOID(135135L);
        JobMonitorTest.assertEquals((long)135135L, (long)this.mon.getOID());
    }

    public void testMonitorTypePersistanceCode() {
        JobMonitorTest.assertEquals((int)0, (int)JobMonitor.MonitorType.NONE.persistanceCode());
        JobMonitorTest.assertEquals((int)1, (int)JobMonitor.MonitorType.UNDERRUN.persistanceCode());
        JobMonitorTest.assertEquals((int)2, (int)JobMonitor.MonitorType.OVERRUN.persistanceCode());
        JobMonitorTest.assertEquals((int)3, (int)JobMonitor.MonitorType.LATESTART.persistanceCode());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.NONE, (Object)JobMonitor.MonitorType.persistanceCodeToEnum(0));
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.UNDERRUN, (Object)JobMonitor.MonitorType.persistanceCodeToEnum(1));
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.OVERRUN, (Object)JobMonitor.MonitorType.persistanceCodeToEnum(2));
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorType.LATESTART, (Object)JobMonitor.MonitorType.persistanceCodeToEnum(3));
        try {
            JobMonitor.MonitorType.persistanceCodeToEnum(99);
            JobMonitorTest.fail((String)"MonitorType.persistanceCodeToEnum accepted invalid value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMonitorOptionPersistanceCode() {
        JobMonitorTest.assertEquals((int)0, (int)JobMonitor.MonitorOption.NONE.persistanceCode());
        JobMonitorTest.assertEquals((int)1, (int)JobMonitor.MonitorOption.RUN_DURATION.persistanceCode());
        JobMonitorTest.assertEquals((int)2, (int)JobMonitor.MonitorOption.TARGET_TIME.persistanceCode());
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.NONE, (Object)JobMonitor.MonitorOption.persistanceCodeToEnum(0));
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.RUN_DURATION, (Object)JobMonitor.MonitorOption.persistanceCodeToEnum(1));
        JobMonitorTest.assertEquals((Object)JobMonitor.MonitorOption.TARGET_TIME, (Object)JobMonitor.MonitorOption.persistanceCodeToEnum(2));
        try {
            JobMonitor.MonitorOption.persistanceCodeToEnum(99);
            JobMonitorTest.fail((String)"MonitorOption.persistanceCodeToEnum accepted invalid value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

