/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobReactCode;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import junit.framework.TestCase;

public class JobHistoryTest
extends TestCase {
    private JobHistory hist;

    protected void setUp() throws Exception {
        super.setUp();
        this.hist = new JobHistory();
    }

    protected void tearDown() throws Exception {
        this.hist = null;
        super.tearDown();
    }

    public void testEquals() {
        JobHistoryTest.assertFalse((boolean)this.hist.equals(null));
        JobHistoryTest.assertFalse((boolean)this.hist.equals(new Object()));
    }

    public void testHashCode() {
        this.hist.setId(12345L);
        int n = this.hist.hashCode();
        for (int i = 0; i < 20; ++i) {
            JobHistoryTest.assertEquals((int)n, (int)this.hist.hashCode());
        }
    }

    public void testSetId() {
        this.hist.setId(123456L);
        JobHistoryTest.assertEquals((long)123456L, (long)this.hist.getId());
    }

    public void testSetJobID() {
        this.hist.setJobID(234567L);
        JobHistoryTest.assertEquals((long)234567L, (long)this.hist.getJobID());
    }

    public void testSetJobName() {
        this.hist.setJobName("jobName");
        JobHistoryTest.assertEquals((String)"jobName", (String)this.hist.getJobName());
    }

    public void testSetAgentID() {
        this.hist.setAgentID(23456789L);
        JobHistoryTest.assertEquals((long)23456789L, (long)this.hist.getAgentID());
    }

    public void testSetAgentName() {
        this.hist.setAgentName("agentName");
        JobHistoryTest.assertEquals((String)"agentName", (String)this.hist.getAgentName());
    }

    public void testSetStatusCode() {
        JobStatusCode[] jobStatusCodeArray;
        for (JobStatusCode jobStatusCode : jobStatusCodeArray = JobStatusCode.values()) {
            this.hist.setStatusCode(jobStatusCode);
            JobHistoryTest.assertEquals((Object)jobStatusCode, (Object)this.hist.getStatusCode());
        }
    }

    public void testSetStatusCode_asStr() {
        JobStatusCode[] jobStatusCodeArray;
        for (JobStatusCode jobStatusCode : jobStatusCodeArray = JobStatusCode.values()) {
            String string = jobStatusCode.persistanceCode();
            this.hist.setStatusCode_asStr(string);
            JobHistoryTest.assertEquals((String)string, (String)this.hist.getStatusCode_asStr());
        }
    }

    public void testSetScheduledTime() {
        this.hist.setScheduledTime(567789L);
        JobHistoryTest.assertEquals((long)567789L, (long)this.hist.getScheduledTime());
    }

    public void testSetServerInitiatedTime() {
        this.hist.setServerInitiatedTime(246135L);
        JobHistoryTest.assertEquals((long)246135L, (long)this.hist.getServerInitiatedTime());
    }

    public void testSetServerSubmittedTime() {
        this.hist.setServerSubmittedTime(135468L);
        JobHistoryTest.assertEquals((long)135468L, (long)this.hist.getServerSubmittedTime());
    }

    public void testSetServerRunningTime() {
        this.hist.setServerRunningTime(135680L);
        JobHistoryTest.assertEquals((long)135680L, (long)this.hist.getServerRunningTime());
    }

    public void testSetServerEndedTime() {
        this.hist.setServerEndedTime(6541132L);
        JobHistoryTest.assertEquals((long)6541132L, (long)this.hist.getServerEndedTime());
    }

    public void testSetAgentStartedTime() {
        this.hist.setAgentStartedTime(246246L);
        JobHistoryTest.assertEquals((long)246246L, (long)this.hist.getAgentStartedTime());
    }

    public void testSetAgentEndedTime() {
        this.hist.setAgentEndedTime(357357L);
        JobHistoryTest.assertEquals((long)357357L, (long)this.hist.getAgentEndedTime());
    }

    public void testSetStartAtCommandSequence() {
        this.hist.setStartAtCommandSequence(123);
        JobHistoryTest.assertEquals((int)123, (int)this.hist.getStartAtCommandSequence());
    }

    public void testSetInitiationData() {
        this.hist.setInitiationData("initiationData");
        JobHistoryTest.assertEquals((String)"initiationData", (String)this.hist.getInitiationData());
    }

    public void testSetRestartParentHistoryID() {
        this.hist.setRestartParentHistoryID(135870L);
        JobHistoryTest.assertEquals((long)135870L, (long)this.hist.getRestartParentHistoryID());
    }

    public void testSetRestartChildHistoryID() {
        this.hist.setRestartChildHistoryID(7567346L);
        JobHistoryTest.assertEquals((long)7567346L, (long)this.hist.getRestartChildHistoryID());
    }

    public void testSetReactCode() {
        JobReactCode[] jobReactCodeArray;
        for (JobReactCode jobReactCode : jobReactCodeArray = JobReactCode.values()) {
            this.hist.setReactCode(jobReactCode);
            JobHistoryTest.assertEquals((Object)jobReactCode, (Object)this.hist.getReactCode());
        }
    }

    public void testSetReactCode_asInt() {
        this.hist.setReactCode_asInt(0);
        JobHistoryTest.assertEquals((int)0, (int)this.hist.getReactCode_asInt());
        this.hist.setReactCode_asInt(1);
        JobHistoryTest.assertEquals((int)1, (int)this.hist.getReactCode_asInt());
    }

    public void testSetInitiationCode() {
        JobInitCode[] jobInitCodeArray;
        for (JobInitCode jobInitCode : jobInitCodeArray = JobInitCode.values()) {
            this.hist.setInitiationCode(jobInitCode);
            JobHistoryTest.assertEquals((Object)jobInitCode, (Object)this.hist.getInitiationCode());
        }
    }

    public void testSetInitiationCode_asInt() {
        this.hist.setInitiationCode_asInt(0);
        JobHistoryTest.assertEquals((int)0, (int)this.hist.getInitiationCode_asInt());
        this.hist.setInitiationCode_asInt(1);
        JobHistoryTest.assertEquals((int)1, (int)this.hist.getInitiationCode_asInt());
        this.hist.setInitiationCode_asInt(2);
        JobHistoryTest.assertEquals((int)2, (int)this.hist.getInitiationCode_asInt());
        this.hist.setInitiationCode_asInt(3);
        JobHistoryTest.assertEquals((int)3, (int)this.hist.getInitiationCode_asInt());
    }

    public void testSetFailedAtCommandSequence() {
        this.hist.setFailedAtCommandSequence(321);
        JobHistoryTest.assertEquals((int)321, (int)this.hist.getFailedAtCommandSequence());
    }

    public void testSetMissedCode() {
        JobMissedCode[] jobMissedCodeArray;
        for (JobMissedCode jobMissedCode : jobMissedCodeArray = JobMissedCode.values()) {
            this.hist.setMissedCode(jobMissedCode);
            JobHistoryTest.assertEquals((Object)jobMissedCode, (Object)this.hist.getMissedCode());
        }
    }

    public void testSetMissedCode_asInt() {
        this.hist.setMissedCode_asInt(0);
        JobHistoryTest.assertEquals((int)0, (int)this.hist.getMissedCode_asInt());
        this.hist.setMissedCode_asInt(1);
        JobHistoryTest.assertEquals((int)1, (int)this.hist.getMissedCode_asInt());
    }

    public void testSetCopiedJobLogToServer() {
        this.hist.setCopiedJobLogToServer(false);
        JobHistoryTest.assertFalse((boolean)this.hist.isCopiedJobLogToServer());
        JobHistoryTest.assertFalse((boolean)this.hist.getCopiedJobLogToServer());
        this.hist.setCopiedJobLogToServer(true);
        JobHistoryTest.assertTrue((boolean)this.hist.isCopiedJobLogToServer());
        JobHistoryTest.assertTrue((boolean)this.hist.getCopiedJobLogToServer());
    }

    public void testSetManuallyStarted() {
        this.hist.setManuallyStarted(false);
        JobHistoryTest.assertFalse((boolean)this.hist.isManuallyStarted());
        this.hist.setManuallyStarted(true);
        JobHistoryTest.assertTrue((boolean)this.hist.isManuallyStarted());
    }

    public void testSetClearPrereqStatus() {
        this.hist.setClearPrereqStatus(false);
        JobHistoryTest.assertFalse((boolean)this.hist.isClearPrereqStatus());
        this.hist.setClearPrereqStatus(true);
        JobHistoryTest.assertTrue((boolean)this.hist.isClearPrereqStatus());
    }

    public void testSetMovedFromScheduledDateTime() {
        this.hist.setMovedFromScheduledDateTime(213456789L);
        JobHistoryTest.assertEquals((long)213456789L, (long)this.hist.getMovedFromScheduledDateTime());
    }

    public void testSetJobEndedReasonCode() {
        this.hist.setJobEndedReasonCode(JobEndedReasonCode.AGENT_ENDED);
        JobHistoryTest.assertEquals((Object)JobEndedReasonCode.AGENT_ENDED, (Object)this.hist.getJobEndedReasonCode());
        JobHistoryTest.assertEquals((String)"G", (String)this.hist.getJobEndedReasonCode_asString());
    }

    public void testSetJobEndedReasonCodeAsString() {
        this.hist.setJobEndedReasonCode_asString("I");
        JobHistoryTest.assertEquals((String)"I", (String)this.hist.getJobEndedReasonCode_asString());
        JobHistoryTest.assertEquals((Object)JobEndedReasonCode.INITIALIZATION_FAILURE, (Object)this.hist.getJobEndedReasonCode());
    }
}

