/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.encryption.AESUtils;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.encryption.MD5;
import com.helpsystems.common.core.license.AgentLicenseTier;
import com.helpsystems.common.core.license.AgentLicenseVersion;
import com.helpsystems.common.core.license.InvalidLicenseVersionException;
import com.helpsystems.common.core.license.LicenseKey;
import com.helpsystems.common.core.license.PointKey;
import com.helpsystems.common.core.license.TierKey;
import com.helpsystems.common.core.util.ValidationHelper;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class EnterpriseProductLicense {
    private static final long serialVersionUID = -6270377893550172275L;
    private static Logger logger = Logger.getLogger(EnterpriseProductLicense.class);
    public static final int UNLIMITED_LICENSE_COUNT = 999999;
    public static final long MAX_SYSTEM_SPECIFIC_TEMP_MILLIS = 94608000000L;
    public static final long MAX_GENERIC_TEMP_MILLIS = 7776000000L;
    public static final int TYPE_NONE = -1;
    public static final int TYPE_INVALID = 0;
    public static final int TYPE_PERMANENT = 1;
    public static final int TYPE_TEMPORARY = 2;
    private static final String APPL_AIX = "SSA";
    private static final String APPL_WINDOWS = "SSW";
    private static final String GENERIC_HARDWARE_HASH = "0000000000";
    private static EncryptUtil decoder = null;
    private LicenseKey licenseKey = null;
    private String licenseCode = "";
    private int licenseType = -1;
    private int licenseKeyVersion = 0;
    private long id;
    private long updatedMS;

    public EnterpriseProductLicense() {
    }

    public EnterpriseProductLicense(String string) throws InvalidLicenseVersionException {
        this.id = 0L;
        this.setLicenseCode(string, false);
    }

    public EnterpriseProductLicense(String string, boolean bl) throws InvalidLicenseVersionException {
        this.id = 0L;
        this.setLicenseCode(string, bl);
    }

    public EnterpriseProductLicense(long l, long l2, String string) throws InvalidLicenseVersionException {
        this.id = l;
        this.updatedMS = l2;
        this.setLicenseCode(string, false);
    }

    private void setLicenseCode(String string, boolean bl) throws InvalidLicenseVersionException {
        LicenseKeyType licenseKeyType = null;
        if (this.setLicenseCode(string, LicenseKeyType.TIERKEY, bl)) {
            licenseKeyType = LicenseKeyType.TIERKEY;
        } else {
            this.setLicenseCode(string, LicenseKeyType.POINTKEY, false);
            licenseKeyType = LicenseKeyType.POINTKEY;
        }
        if (this.licenseKey != null) {
            logger.trace((Object)("Found " + licenseKeyType.name() + ": " + this.licenseKey));
        }
    }

    private boolean setLicenseCode(String string, LicenseKeyType licenseKeyType, boolean bl) throws InvalidLicenseVersionException {
        long l = System.currentTimeMillis();
        if (string.length() > 0) {
            logger.trace((Object)("Loading license " + string + " as " + (Object)((Object)licenseKeyType)));
        }
        try {
            int n;
            ValidationHelper.checkForNull((String)"License Code", (Object)string);
            this.licenseCode = string.trim();
            if (this.licenseCode.length() == 0) {
                this.licenseType = -1;
                this.licenseKey = null;
                return true;
            }
            switch (licenseKeyType) {
                case TIERKEY: {
                    this.licenseKey = new TierKey();
                    try {
                        ((TierKey)this.licenseKey).setEncryptedKey(this.licenseCode, decoder);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)("Failed to set license " + string + " as TierKey due to NumberFormatException: " + numberFormatException.getMessage()));
                        return false;
                    }
                    n = ((TierKey)this.licenseKey).getLicenseKeyVersion();
                    this.setLicenseKeyVersion(n);
                    AgentLicenseVersion.getVersion((int)n);
                    if (n != 0) break;
                    return false;
                }
                case POINTKEY: {
                    this.licenseKey = new PointKey();
                    ((PointKey)this.licenseKey).setEncryptedKey(this.licenseCode, decoder);
                }
            }
            n = 0;
            String string2 = (System.getProperty("os.name") + " " + System.getProperty("os.version")).toLowerCase();
            if ((string2.contains("win") || string2.contains("linux") || string2.contains("bsd") || string2.contains("sco")) && this.licenseKey.getProductCode().equals(APPL_WINDOWS)) {
                n = 1;
            }
            if ((string2.contains("aix") || string2.contains("solaris") || string2.contains("sunos")) && this.licenseKey.getProductCode().equals(APPL_AIX)) {
                n = 1;
            }
            if (n == 0) {
                logger.debug((Object)("License Application is not correct: " + this.licenseKey.getProductCode()));
                this.licenseType = 0;
                this.licenseKey = null;
            } else {
                long l2 = this.adjustExpirationDate(this.licenseKey.getExpirationDate());
                if (l2 == 0L) {
                    this.licenseType = 1;
                } else if (l2 < 0L) {
                    this.licenseType = 0;
                } else {
                    String string3 = this.getLicenseHash();
                    Date date = string3.equals(GENERIC_HARDWARE_HASH) ? new Date(l2 - 7776000000L) : new Date(l2 - 94608000000L);
                    Date date2 = new Date(l2);
                    logger.trace((Object)("Temporary license range: " + date + " --> " + date2));
                    if (date2.getTime() < l) {
                        this.licenseType = 0;
                        logger.trace((Object)("Temporary license is not valid after: " + date2));
                    } else if (date.getTime() > l) {
                        this.licenseType = 0;
                        logger.warn((Object)("Temporary license is not valid until: " + date));
                    } else {
                        this.licenseType = 2;
                    }
                }
            }
        }
        catch (Exception exception) {
            if (bl && exception instanceof InvalidLicenseVersionException) {
                throw (InvalidLicenseVersionException)exception;
            }
            logger.error((Object)("Invalid license " + string + " - " + exception.getClass() + ": " + exception.getMessage()));
            this.licenseType = 0;
            this.licenseKey = null;
        }
        return true;
    }

    public long getId() {
        return this.id;
    }

    public long getUpdatedMS() {
        return this.updatedMS;
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public int getLicenseType() {
        return this.licenseType;
    }

    public Date getExpirationDate() {
        if (this.licenseKey == null) {
            return null;
        }
        if (this.licenseKey.getExpirationDate() != 0L) {
            return new Date(this.adjustExpirationDate(this.licenseKey.getExpirationDate()));
        }
        return null;
    }

    public String getLicenseHash() {
        if (this.licenseKey == null) {
            return "";
        }
        return this.licenseKey.getHardwareCode();
    }

    public int getTierPoints(AgentLicenseTier agentLicenseTier) {
        if (this.licenseKey == null || !(this.licenseKey instanceof TierKey)) {
            return 0;
        }
        return ((TierKey)this.licenseKey).getPoints(agentLicenseTier);
    }

    public int getTierPoints(int n) {
        if (this.licenseKey == null || !(this.licenseKey instanceof TierKey)) {
            return 0;
        }
        return ((TierKey)this.licenseKey).getPoints(n);
    }

    public int getPoints() {
        if (this.licenseKey == null || this.isTierKey()) {
            return 0;
        }
        return ((PointKey)this.licenseKey).getPoints();
    }

    public boolean isTierKey() {
        return this.licenseKey instanceof TierKey;
    }

    public boolean isSystemSpecificTempCode() {
        if (this.licenseKey != null) {
            return this.licenseKey.getKeyType() == 2;
        }
        return false;
    }

    public int getLicenseKeyVersion() {
        return this.licenseKeyVersion;
    }

    public void setLicenseKeyVersion(int n) {
        this.licenseKeyVersion = n;
    }

    public boolean isSAPEnabled() {
        if (this.licenseKey != null) {
            byte by = this.licenseKey.getFlags();
            return (by & FEATURE.SAP.mask) == FEATURE.SAP.mask;
        }
        return false;
    }

    public boolean isInformaticaEnabled() {
        if (this.licenseKey != null) {
            byte by = this.licenseKey.getFlags();
            return (by & FEATURE.INFORMATICA.mask) == FEATURE.INFORMATICA.mask;
        }
        return false;
    }

    public boolean isOracleEnabled() {
        if (this.licenseKey != null) {
            byte by = this.licenseKey.getFlags();
            return (by & FEATURE.ORACLE.mask) == FEATURE.ORACLE.mask;
        }
        return false;
    }

    public boolean isRobotScheduleInterfaceEnabled() {
        if (this.licenseKey != null) {
            byte by = this.licenseKey.getFlags();
            return (by & FEATURE.RSI.mask) == FEATURE.RSI.mask;
        }
        return false;
    }

    public boolean isSequelBundledLicense() {
        if (this.licenseKey != null) {
            byte by = this.licenseKey.getFlags();
            return (by & FEATURE.SEQUEL_BUNDLED.mask) == FEATURE.SEQUEL_BUNDLED.mask;
        }
        return false;
    }

    public boolean isUniversalConnectorEnabled() {
        if (this.licenseKey != null) {
            byte by = this.licenseKey.getFlags();
            return (by & FEATURE.UNIVERSAL_CONNECTOR.mask) == FEATURE.UNIVERSAL_CONNECTOR.mask;
        }
        return false;
    }

    public boolean isUnlimitedPoints() {
        if (!this.isTierKey()) {
            PointKey pointKey = (PointKey)this.licenseKey;
            return pointKey.getPoints() == 999999;
        }
        return false;
    }

    public boolean isUnlimitedTier(int n) {
        if (this.isTierKey()) {
            TierKey tierKey = (TierKey)this.licenseKey;
            return tierKey.getPoints(n) == 99999;
        }
        return false;
    }

    public boolean isValidPermanent(String string) {
        return (this.getLicenseType() == 1 || this.getLicenseType() == 2 && this.isSystemSpecificTempCode()) && this.isValidOn(string);
    }

    public boolean isValidTemporary(String string) {
        return this.getLicenseType() == 2 && this.isValidOn(string);
    }

    public boolean isValidOn(String string) {
        return this.isValidOn(string, false);
    }

    public boolean isValidAndValidOn(String string) {
        return this.isValidOn(string, true);
    }

    private boolean isValidOn(String string, boolean bl) {
        if (bl && this.getLicenseType() != 1 && this.getLicenseType() != 2) {
            return false;
        }
        String string2 = this.getLicenseHash();
        String string3 = null;
        try {
            string3 = MD5.shortHash((String)string.toUpperCase());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error((Object)"The MD5 algorithm could not be found on this system.", (Throwable)noSuchAlgorithmException);
            return false;
        }
        if (this.getLicenseType() == 2 && string2.equals(GENERIC_HARDWARE_HASH)) {
            return true;
        }
        if (string3.equalsIgnoreCase(string2)) {
            return true;
        }
        logger.debug((Object)("License is not valid: Incorrect hardware (" + string3 + "/" + string2 + ")"));
        return false;
    }

    public boolean isValidStandby(String string) {
        if (this.licenseType == 1 || this.licenseType == 2 && this.isSystemSpecificTempCode()) {
            return !this.isValidOn(string);
        }
        return false;
    }

    private long adjustExpirationDate(long l) {
        if (l > 0L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(l);
            gregorianCalendar.set(11, 12);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            return gregorianCalendar.getTimeInMillis();
        }
        return l;
    }

    public static boolean isTierKeyVersion(AgentLicenseVersion agentLicenseVersion) {
        return agentLicenseVersion.equals((Object)AgentLicenseVersion.ONE);
    }

    public static String skybotNameForTier(AgentLicenseTier agentLicenseTier) {
        switch (agentLicenseTier) {
            case UNDEFINED: {
                return "Undefined";
            }
            case TIER_1: {
                return "Windows/OS X";
            }
            case TIER_2: {
                return "Linux";
            }
            case TIER_3: {
                return "AIX/UNIX";
            }
            case TIER_4: {
                return "IBM i";
            }
        }
        return null;
    }

    static {
        try {
            decoder = AESUtils.init((String)"sNeaKY<rOBot>KeY");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error initilizing node license.", exception);
        }
    }

    public static enum FEATURE {
        SAP(1),
        INFORMATICA(2),
        ORACLE(4),
        RSI(8),
        SEQUEL_BUNDLED(16),
        UNIVERSAL_CONNECTOR(32);

        private final byte mask;

        private FEATURE(byte by) {
            this.mask = by;
        }
    }

    private static enum LicenseKeyType {
        TIERKEY,
        POINTKEY;

    }
}

