/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.enterprise.core.busobj.AgentServerPath;
import com.helpsystems.enterprise.core.busobj.WorkingOIDHolder;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;

public class AgentCopyFileDefinition
extends AbstractBusinessObject
implements XMLSerializable {
    private static final long serialVersionUID = -1L;
    private static WorkingOIDHolder WORKING_OID_HOLDER = new WorkingOIDHolder();
    public static final int MAX_LENGTH_AGENT_FILES = 3000;
    public static final int MAX_LENGTH_HOST_DIRECTORY = 3000;
    public static final int MAX_LENGTH_ALRDEV = 10;
    public static final char DISTRIBUTE_TO_HOST = 'H';
    public static final char COPY_FAIL = '1';
    public static final char COPY_REPLACE = '2';
    public static final char COPY_INCREMENT = '3';
    public static final char COPY_TIMESTAMP = '4';
    private long oid;
    private String jobID = "";
    private String agentFilePath = "";
    private boolean requireCopiedFiles = false;
    private char distributionType = (char)72;
    private String hostDirectory = "";
    private char hostCopyOption = (char)49;
    private boolean modified = false;
    private long workingOID = AgentCopyFileDefinition.getNextWorkingOID();
    private int lineNumber = 0;
    private final String fldnameJobID = "Job Identifier";
    private final String fldnameAgentFilePath = "agent_file_path";
    private final String fldnameDirectory = "directory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextWorkingOID() {
        WorkingOIDHolder workingOIDHolder = WORKING_OID_HOLDER;
        synchronized (workingOIDHolder) {
            return WORKING_OID_HOLDER.getNextWorkingOID();
        }
    }

    public long getOid() {
        return this.oid;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        if (this.lineNumber != n) {
            this.modified = true;
        }
        this.lineNumber = n;
    }

    public void setOid(long l) {
        if (this.oid > 0L) {
            throw new IllegalStateException("OID changes are not allowed.");
        }
        this.oid = l;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void setJobID(String string) {
        ValidationHelper.checkForNull((String)"Job Identifier", (Object)string);
        this.jobID = string.trim();
    }

    public String getAgentFilePath() {
        return this.agentFilePath;
    }

    public void setAgentFilePath(String string) {
        ValidationHelper.checkForNull((String)"agent_file_path", (Object)string);
        ValidationHelper.validateLength((String)"agent_file_path", (int)3000, (String)string);
        if (string.endsWith("/") || string.endsWith("\\")) {
            throw new IllegalArgumentException("Output distribution path '" + string + "' does not include an output file name.");
        }
        if (!string.equals(this.agentFilePath)) {
            this.modified = true;
        }
        this.agentFilePath = string;
    }

    public boolean isRequireCopiedFiles() {
        return this.requireCopiedFiles;
    }

    public boolean getRequireCopiedFiles() {
        return this.isRequireCopiedFiles();
    }

    public void setRequireCopiedFiles(boolean bl) {
        if (this.requireCopiedFiles != bl) {
            this.modified = true;
        }
        this.requireCopiedFiles = bl;
    }

    public char getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(char c) {
        if (c != 'H') {
            throw new IllegalArgumentException("Distribution Type is not valid: " + String.valueOf(c));
        }
        if (c != this.distributionType) {
            this.modified = true;
        }
        this.distributionType = c;
    }

    public String getHostDirectory() {
        return this.hostDirectory;
    }

    public void setHostDirectory(String string) {
        ValidationHelper.checkForNull((String)"directory", (Object)string);
        String string2 = Convert.trimL((String)string);
        ValidationHelper.validateLength((String)"directory", (int)3000, (String)string2);
        string2 = AgentServerPath.validateDirectoryPath(string2);
        if (!string2.equals(this.hostDirectory)) {
            this.modified = true;
        }
        this.hostDirectory = string2;
    }

    public char getHostCopyOption() {
        return this.hostCopyOption;
    }

    public void setHostCopyOption(char c) {
        switch (c) {
            case '1': 
            case '2': 
            case '3': 
            case '4': {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Copy Options: " + c);
            }
        }
        if (c != this.hostCopyOption) {
            this.modified = true;
        }
        this.hostCopyOption = c;
    }

    public void validate() {
        ValidationHelper.checkForBlankIgnoreNull((String)"agent_file_path", (String)this.agentFilePath);
        ValidationHelper.checkForBlankIgnoreNull((String)"directory", (String)this.hostDirectory);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AgentCopyFileDefinition)) {
            return false;
        }
        AgentCopyFileDefinition agentCopyFileDefinition = (AgentCopyFileDefinition)((Object)object);
        if (agentCopyFileDefinition.oid > 0L && agentCopyFileDefinition.oid == this.oid) {
            return true;
        }
        return Equal.isEqual((long)this.getProductIIDInt(), (long)agentCopyFileDefinition.getProductIIDInt()) && Equal.isEqual((Object)agentCopyFileDefinition.jobID, (Object)this.jobID) && Equal.isEqual((Object)agentCopyFileDefinition.agentFilePath, (Object)this.agentFilePath) && Equal.isEqual((boolean)agentCopyFileDefinition.requireCopiedFiles, (boolean)this.requireCopiedFiles) && Equal.isEqual((long)agentCopyFileDefinition.distributionType, (long)this.distributionType) && Equal.isEqual((Object)agentCopyFileDefinition.hostDirectory, (Object)this.hostDirectory) && Equal.isEqual((long)agentCopyFileDefinition.hostCopyOption, (long)this.hostCopyOption) && Equal.isEqual((Object)agentCopyFileDefinition.getName(), (Object)this.getName());
    }

    public int hashCode() {
        if (this.oid == 0L) {
            return String.valueOf(this.workingOID).hashCode();
        }
        return String.valueOf(this.oid).hashCode();
    }

    public AgentCopyFileDefinition clone() {
        AgentCopyFileDefinition agentCopyFileDefinition = new AgentCopyFileDefinition();
        agentCopyFileDefinition.oid = this.oid;
        agentCopyFileDefinition.jobID = this.jobID;
        agentCopyFileDefinition.agentFilePath = this.agentFilePath;
        agentCopyFileDefinition.requireCopiedFiles = this.requireCopiedFiles;
        agentCopyFileDefinition.distributionType = this.distributionType;
        agentCopyFileDefinition.hostDirectory = this.hostDirectory;
        agentCopyFileDefinition.hostCopyOption = this.hostCopyOption;
        agentCopyFileDefinition.setName(this.getName());
        agentCopyFileDefinition.setPersistent(this.isPersistent());
        agentCopyFileDefinition.setWorkingOID(this.getWorkingOID());
        agentCopyFileDefinition.modified = this.modified;
        if (!agentCopyFileDefinition.equals((Object)this)) {
            throw new IllegalStateException("Not a real clone.");
        }
        return agentCopyFileDefinition;
    }

    public boolean wasModified() {
        return this.modified;
    }

    public void resetModifiedFlag() {
        this.modified = false;
    }

    public void resetForCopy() {
        this.oid = 0L;
        this.setPersistent(false);
        this.workingOID = AgentCopyFileDefinition.getNextWorkingOID();
        this.modified = false;
    }

    public long getWorkingOID() {
        return this.workingOID;
    }

    public void setWorkingOID(long l) {
        this.workingOID = l;
    }
}

