/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentProxy;

public class Agent
extends AgentProxy {
    private static final long serialVersionUID = -1083563982239820238L;
    public static final int NAME_LENGTH = 50;
    public static final int HARDWARE_HASH_LENGTH = 10;
    public static final int HARDWARE_KEY_LENGTH = 1024;
    public static final int DEFAULT_MAX_ACTIVE = 20;
    private static final String TBD_AGENT_NAME = "TBD";
    private String hardwareKey;
    private String version;
    private String ipAddress;
    private int port;
    private String jobShell = "";
    private boolean limitActiveJobs = false;
    private boolean sendSMTPEmail;
    private boolean sendSNMPTrap;
    private long notificationListID;
    private String timeZone;
    private boolean allowAgentUserExec;
    private String standbyServerOverride = null;
    private int standbyPortOverride = 0;
    private long defaultJobQueueID;
    private boolean queuesLocked;

    public void setTimeZone(String string) {
        this.timeZone = string;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getHardwareKey() {
        return this.hardwareKey;
    }

    public void setHardwareKey(String string) {
        if (string == null) {
            this.hardwareKey = string;
            return;
        }
        ValidationHelper.validateLength((String)"Hardware Key", (int)1024, (String)string);
        this.hardwareKey = string;
    }

    @Override
    public void setHardwareHash(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Hardware Hash", (String)string);
        ValidationHelper.validateLength((String)"Hardware Hash", (int)10, (String)string);
        super.setHardwareHash(string);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public void setIPAddress(String string) {
        this.ipAddress = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getJobShell() {
        return this.jobShell;
    }

    public void setJobShell(String string) {
        this.jobShell = string;
    }

    public boolean isLimitActiveJobs() {
        return this.limitActiveJobs;
    }

    public boolean getLimitActiveJobs() {
        return this.limitActiveJobs;
    }

    public void setLimitActiveJobs(boolean bl) {
        this.limitActiveJobs = bl;
    }

    public long getNotificationListID() {
        return this.notificationListID;
    }

    public void setNotificationListID(long l) {
        this.notificationListID = l;
    }

    public boolean isSendSMTPEmail() {
        return this.sendSMTPEmail;
    }

    public boolean getSendSMTPEmail() {
        return this.isSendSMTPEmail();
    }

    public void setSendSMTPEmail(boolean bl) {
        this.sendSMTPEmail = bl;
    }

    public boolean getSendSNMPTrap() {
        return this.isSendSNMPTrap();
    }

    public boolean isSendSNMPTrap() {
        return this.sendSNMPTrap;
    }

    public void setSendSNMPTrap(boolean bl) {
        this.sendSNMPTrap = bl;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        Agent agent = (Agent)((Object)object);
        return super.equals(object) && Equal.isEqual((Object)this.opsys, (Object)agent.opsys) && Equal.isEqual((Object)this.hardwareKey, (Object)agent.hardwareKey) && Equal.isEqual((Object)this.version, (Object)agent.version) && Equal.isEqual((long)this.licensePoints, (long)agent.licensePoints);
    }

    public boolean getAllowAgentUserExec() {
        return this.allowAgentUserExec;
    }

    public void setAllowAgentUserExec(boolean bl) {
        this.allowAgentUserExec = bl;
    }

    public String getStandbyServerOverride() {
        return this.standbyServerOverride;
    }

    public void setStandbyServerOverride(String string) {
        this.standbyServerOverride = string;
    }

    public int getStandbyPortOverride() {
        return this.standbyPortOverride;
    }

    public void setStandbyPortOverride(int n) {
        this.standbyPortOverride = n;
    }

    public long getDefaultJobQueueID() {
        return this.defaultJobQueueID;
    }

    public void setDefaultJobQueueID(long l) {
        this.defaultJobQueueID = l;
    }

    public boolean isQueuesLocked() {
        return this.queuesLocked;
    }

    public boolean getQueuesLocked() {
        return this.isQueuesLocked();
    }

    public void setQueuesLocked(boolean bl) {
        this.queuesLocked = bl;
    }

    public boolean isTheSameAs(Object object) {
        if (object == null || !((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        Agent agent = (Agent)((Object)object);
        return super.equals(object) && Equal.isEqual((Object)this.opsys, (Object)agent.opsys) && Equal.isEqual((Object)this.hardwareKey, (Object)agent.hardwareKey) && Equal.isEqual((Object)this.version, (Object)agent.version) && Equal.isEqual((long)this.licensePoints, (long)agent.licensePoints) && Equal.isEqual((Object)super.getName(), (Object)agent.getName()) && Equal.isEqual((long)this.port, (long)agent.port) && Equal.isEqual((Object)this.timeZone, (Object)agent.timeZone) && Equal.isEqual((Object)this.ipAddress, (Object)agent.ipAddress) && Equal.isEqual((Object)this.version, (Object)agent.version) && Equal.isEqual((boolean)this.allowAgentUserExec, (boolean)agent.allowAgentUserExec) && Equal.isEqual((Object)super.getCPUInfo(), (Object)agent.getCPUInfo());
    }

    public static String getTBDAgentName() {
        return TBD_AGENT_NAME;
    }

    public static String getTBDInGroupAgentName(String string) {
        return "TBD@" + string;
    }
}

