/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.messages.SystemMessage;

public enum RosettaMsg {
    ADMIN_PROFILE_RESET,
    AGENT_CONNECTED,
    AGENT_DISCONNECTED,
    AGENT_DISCONNECTED_WITHOUT_WARNING,
    AGENT_EVENT_OCCURRED,
    AGENT_EVENT_OCCURRED_HELD,
    AGENT_EVENT_OCCURRED_TIME_RANGE,
    AGENT_LICENSE_ALLOCATIONS_CHANGED_BY_USER,
    AGENT_LICENSE_DEALLOCATED,
    AGENT_LOCKED_BY_USER,
    AGENT_UNLOCKED_BY_USER,
    ALL_JOB_QUEUES_LOCKED,
    ALL_JOB_QUEUES_LOCKED_BY_USER,
    ALL_JOB_QUEUES_UNLOCKED_BY_USER,
    AGENT_REPLACED_BY_USER,
    AGENT_RESTARTED_BY_USER,
    AGENT_STOPPED_BY_USER,
    AGENT_UPDATE_INITIATED_BY_USER,
    AGENT_UPDATE_FAILED,
    AGENT_UPDATE_REQUIRED,
    AGENT_UPDATE_STARTED,
    AUTOMATE_USER_ACCOUNT_NOT_ACTIVE,
    AUTOMATE_USER_ALREADY_LOGGED_IN,
    AUTOMATE_USER_LOCKED_OUT,
    AUTOMATE_USER_OR_PASSWORD_INCORRECT,
    CALENDAR_OBJECT_EXPIRING_DAYS,
    CALENDAR_OBJECT_EXPIRING_TODAY,
    CALENDAR_OBJECT_EXPIRING_TOMORROW,
    CALENDAR_OBJECT_CHANGE_MISSING_JOB,
    CALENDAR_OBJECT_CHANGE_NOTIFICATION,
    CLOCK_ADJUSTMENT_EXCEEDED_MAX_ALLOWED,
    CONDITIONAL_JOB_ENTER_RETRY_WAIT,
    CONDITIONAL_JOB_RUN_ANYWAY,
    CONDITIONAL_JOB_RUN_BY_USER,
    CONDITIONAL_JOB_BACKLEVEL_AGENT,
    CONDITIONAL_JOB_BACKLEVEL_AGENT_RETRY,
    COULDNT_FIND_VALID_LICENSE,
    COULDNT_FIND_VALID_PRIMARY_OR_TEMPORARY_LICENSE,
    DAILY_CLEANUP_RUNNERS_ERROR_ENCOUNTERED,
    DAILY_CLEANUP_NEXT_WAKEUP,
    DATE_OBJECT_EXPIRING_DAYS,
    DATE_OBJECT_EXPIRING_TODAY,
    DATE_OBJECT_EXPIRING_TOMORROW,
    DATE_OBJECT_CHANGE_MISSING_JOB,
    DATE_OBJECT_CHANGE_NOTIFICATION,
    DEFAULT_AGENT_USER_NOT_ALLOWED,
    DRIVER_STARTED,
    DRIVER_ENDED,
    DRIVER_ENDED_IN_ERROR,
    ENTERPRISE_SERVER_SHUTDOWN,
    ENTERPRISE_SERVER_STARTUP,
    ERROR_CALCULATING_PURGE_DATE,
    ERROR_ON_AGENT,
    EXPIRING_CALENDAR_OBJECT_NAME,
    EXPIRING_DATE_OBJECT_NAME,
    EXPIRING_LICENSE_NAME,
    FAILED_TO_RUN,
    FORECAST_CLEANUP_COMPLETE_ONE,
    FORECAST_CLEANUP_COMPLETE_MULTIPLE,
    FORECAST_GENERATION_STARTED,
    FORECAST_GENERATION_COMPLETED,
    FORECAST_GENERATION_FAILED,
    FORECAST_RANGE_START_IN_PAST,
    FORECAST_WINDOW_START_TIME_WAS_MOVED,
    FORECAST_WINDOW_END_TIME_WAS_MOVED,
    FORECAST_PURGE_COMPLETE,
    HISTORY_PURGE,
    HISTORY_PURGE_COMPLETE,
    INVALID_NST,
    INVALID_NST_WRONG_AGENT_FOR_JOB,
    INVALID_NST_AGENT_NOT_PART_OF_GROUP,
    INVALID_NST_AGENT_SHOULD_BE_UNASSIGNED,
    INVALID_NST_PURGED,
    INVALID_NST_PURGED_MULTIPLE,
    PURGE_SUITE_HISTORY_NAME,
    SUITE_HISTORY_PURGE_COMPLETE,
    JOB_ALREADY_ACTIVE,
    INVALID_PRIMARY_LICENSE,
    INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION_1,
    INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION_2,
    JOB_ADDED_NOTIFICATION,
    JOB_CANCELED_DUE_TO_CONDITION,
    JOB_CANCELED_DUE_TO_TIMERANGE,
    SUITE_CANCELED_DUE_TO_TIMERANGE,
    JOB_CHANGE_ERROR,
    JOB_CHANGE_MISSING_JOB,
    JOB_CHANGE_NOTIFICATION,
    JOB_CHANGE_NOTIFICATION_AGENT_CHANGED,
    JOB_COMPLETED,
    JOB_DELAYED_COMPLETION_INFO,
    JOB_DELAYED_FAILURE_INFO,
    JOB_DELAYED_COMMAND_FAILURE_INFO,
    JOB_DELAYED_COMPLETION_WITH_PRIOR_INFO,
    JOB_DELAYED_COMPLETION_WITH_REASON_AND_PRIOR_INFO,
    JOB_DELAYED_COMMAND_FAILURE_WITH_PRIOR_INFO,
    JOB_FAILED,
    JOB_FAILED_AT_COMMAND,
    JOB_FAILED_DUE_TO_CONDITION,
    JOB_FAILED_DUE_TO_LICENSE,
    JOB_FAILED_DUE_TO_INFORMATICA_LICENSE,
    JOB_FAILED_DUE_TO_ORACLE_LICENSE,
    JOB_FAILED_DUE_TO_SAP_LICENSE,
    JOB_FAILED_DUE_TO_UNIVERSAL_CONNECTOR_LICENSE,
    JOB_HELD_DUE_TO_FAILURE,
    JOB_LOAD_BALANCED_BY_USER,
    JOB_SUITE_HELD_DUE_TO_FAILURE,
    JOB_HISTORY_RECORD_DELETED,
    JOB_HISTORY_RECORD_MISMATCH,
    JOB_SUITE_HISTORY_RECORD_DELETED,
    JOB_MARKED,
    JOB_MONITOR_EVENT_OCCURRED,
    JOB_MONITOR_EVENT_OCCURRED_LATE_START,
    JOB_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME,
    JOB_MOVED_TO_QUEUE,
    JOB_QUEUE_CLEARED_BY_USER,
    JOB_QUEUE_HELD_BY_USER,
    JOB_QUEUE_RELEASED_BY_USER,
    JOB_QUEUE_UPDATED,
    JOB_QUEUE_UPDATED_XAGENT,
    JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED,
    JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED_LATE_START,
    JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME,
    JOB_SUITE_MONITOR_EVENT_OCCURRED,
    JOB_SUITE_MONITOR_EVENT_OCCURRED_LATE_START,
    JOB_SUITE_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME,
    JOB_SUITE_SUBMITTED_BY_USER,
    JOB_SUBMITTED_BY_USER,
    JOB_NOT_SUBMITTED_REACTIVE_TIME_RANGE,
    JOB_SUITE_NOT_SUBMITTED_REACTIVE_TIME_RANGE,
    JOB_RESTARTED_BY_USER,
    JOB_ENDED_BY_USER,
    JOB_CANCELED_BY_JOB_MONITOR,
    JOB_REMOVED_FROM_QUEUE_BY_USER,
    JOB_WAS_HELD,
    JOB_WAS_HELD_NTH_TIME,
    JOB_WAS_HELD_UNTIL,
    JOB_WAS_IGNORED_IN_AGENT_GROUP,
    JOB_WAS_IGNORED_UNTIL_IN_AGENT_GROUP,
    JOB_WAS_NOT_RUN,
    JOB_PRIORITY_CHANGED,
    MANAGED_JOB_ENDED_BY_USER,
    MANAGED_JOB_REMOVED_BY_USER,
    MANAGED_JOB_SUBMITTED_BY_USER,
    MANAGED_SUITE_ENDED_BY_USER,
    MANAGED_SUITE_SUBMITTED_BY_USER,
    SKIPPED_JOB_SUBMITTED_BY_USER,
    MISSED_JOB_COMPLETING,
    MISSED_SUITE_COMPLETING,
    MISSED_JOB_COMPLETING_AN_ADDITIONAL,
    MISSED_SUITE_COMPLETING_AN_ADDITIONAL,
    MISSED_JOB_IGNORING,
    MISSED_SUITE_IGNORING,
    MISSED_JOB_IGNORING_AN_ADDITIONAL,
    MISSED_SUITE_IGNORING_AN_ADDITIONAL,
    MISSED_JOB_MANAGING_EXIST,
    MISSED_JOB_MANAGING_EXIST_ONE,
    MISSED_JOB_MANAGING,
    MISSED_SUITE_MANAGING,
    MISSED_JOB_MANAGING_AN_ADDITIONAL,
    MISSED_SUITE_MANAGING_AN_ADDITIONAL,
    MISSED_JOB_SUBMITTING_FIRST,
    MISSED_SUITE_SUBMITTING_FIRST,
    MISSED_JOB_SUBMITTING_AN_ADDITIONAL,
    MISSED_SUITE_SUBMITTING_AN_ADDITIONAL,
    MISSED_JOB_FAILING,
    MISSED_SUITE_FAILING,
    MISSED_JOB_FAILING_AN_ADDITIONAL,
    MISSED_SUITE_FAILING_AN_ADDITIONAL,
    MISSED_JOB_PROCESS_STARTED,
    MISSED_JOB_PROCESS_COMPLETED,
    MISSED_JOB_SUBMITTED,
    MISSED_QUEUED_JOB_IGNORED,
    MOVE_NON_WORKDAY_RUN_TO_PRIOR_WORKDAY,
    MOVE_NON_WORKDAY_RUN_TO_SUBSEQUENT_WORKDAY,
    NO_DAILY_CLEANUP_RUNNERS,
    NST_CALC_BAD_SCHEDULE_INFO,
    NST_CALC_ERROR_MULTIPLE_SYSTEMS,
    NST_CALC_RUNTIME_ADJUSTED_DUE_TO_INVALID_DATETIME_DST,
    NST_CALC_TIME_DATA_NOT_SAVED,
    NST_CALC_UNABLE_TO_DETERMINE,
    NST_CALC_UNABLE_TO_DETERMINE_MULTIPLE_SYSTEMS,
    NST_CALC_UNABLE_TO_DETERMINE_NOT_SET_TO_NULL,
    NST_CALC_UNABLE_TO_DETERMINE_NOT_SET_TO_NULL_JOB_CHANGE,
    NST_CALC_UNRECOGNIZED_TIME_ZONE_ID,
    ORACLE_LICENSE_INVALID,
    ORACLE_LICENSE_VALID,
    PREREQUISITE_STATUS_NOT_ACCEPTED_BY_SPECIAL_INSTANCE,
    PREREQUISITE_STATUS_FOR_AGENTLESS_EVENT_NOT_ACCEPTED_BY_SPECIAL_INSTANCE,
    PREREQ_NOT_MET,
    PREREQ_NOT_MET_FOR_MISSED,
    PRIMARY_LICENSE_EXPIRING_DAYS,
    PURGE_AUDIT_LOG_NAME,
    PURGE_AGENT_EVENT_LOG_NAME,
    PURGE_JOB_HISTORY_NAME,
    PURGE_SAP_INTERCEPTED_JOB_HISTORY_NAME,
    PURGE_SAP_INTERCEPTED_JOB_HISTORY,
    PURGE_FORECAST_NAME,
    PURGE_LOGS,
    ROLLUP_PURGE_RUNNER_NAME,
    LOG_PURGE_RUNNER_NAME,
    PURGE_JOB_MONITOR_EVENTS_NAME,
    PURGE_LOG_SKIPPED,
    PURGE_OLDER_THAN,
    PURGE_DELETED_OVER_DAYS,
    PURGE_COMPLETE,
    PURGE_REMOTE_HISTORY_NAME,
    PURGE_REMOTE_EVENT_HISTORY_NAME,
    PURGE_SKYBOT_EVENT_HISTORY_NAME,
    PURGE_RUNNER_NAME,
    PURGE_SCHEDULE_LOG_NAME,
    PURGE_SESSIONS_NAME,
    PURGE_SNMP_EVENTS_NAME,
    PURGE_SYSTEM_MESSAGES_NAME,
    PURGE_FORECAST,
    REACTIVE_JOB_NOT_SUBMITTED_OMITTED_PER_DATE_LIST,
    REACTIVE_JOB_NOT_SUBMITTED_NON_WORKDAY_RULE,
    REACTIVE_JOB_SUITE_NOT_SUBMITTED_OMITTED_PER_DATE_LIST,
    REACTIVE_JOB_SUITE_NOT_SUBMITTED_NON_WORKDAY_RULE,
    REMOTE_SERVER_APPROVED,
    REMOTE_SERVER_CONNECT,
    REMOTE_SERVER_DISCONNECT,
    REMOTE_SERVER_UNABLE_TO_CONNECT,
    REMOTE_SERVER_HAS_NOT_YET_CONNECTED,
    REMOTE_SERVER_FORCED_DISCONNECT,
    REMOTE_SERVER_DELETED_AND_ACTIVE_CONNECTION,
    REMOTE_SERVER_DELETED_AND_NO_ACTIVE_CONNECTION,
    REQUEUED_JOBS,
    REPORT_ROWS_LIMIT,
    REQUEUING_AGENT_QUEUES,
    RSI_LICENSE_INVALID,
    RSI_LICENSE_VALID,
    SAP_COMMAND_BACKLEVEL_AGENT,
    SQL_SERVER_JOB_BACKLEVEL_AGENT,
    SKYBOT_VARIABLE_SET_BY_API,
    SKYBOT_VARIABLE_UNRESOLVED,
    SKYBOT_VARIABLE_VALUE_IS_TOO_LONG,
    REPLICATION_IS_NOT_ACTIVE_MESSAGE,
    REPLICATION_IS_NOT_ACTIVE_SUBJECT,
    RUNNER_NAME,
    SCHEDULED_INTERVAL_JOB_RUN_OMITTED_FOR_DAY,
    SCHEDULED_JOB_RUN_OMITTED,
    SCHEDULER_BYPASSED_JOB,
    SCHEDULER_DRIVER_STARTED,
    SCHEDULER_DRIVER_STARTED_BY_USER,
    SCHEDULER_DRIVER_STOPPED_BY_USER,
    SERVER_LICENSED_BY_USER,
    SKIP_NON_WORKDAY_RUN_DO_NOT_RUN,
    SKIP_NON_WORKDAY_RUN_PRIOR_WORKDAY_IS_OMIT,
    SKIP_NON_WORKDAY_RUN_PRIOR_WORKDAY_IS_RUNDAY,
    SKIP_NON_WORKDAY_RUN_SUBSEQUENT_WORKDAY_IS_OMIT,
    SKIP_NON_WORKDAY_RUN_SUBSEQUENT_WORKDAY_IS_RUNDAY,
    SKYBOT_SCHEDULER_SERVER_NOTICE,
    SKYBOT_SCHEDULER_AGENT_DISCONNECT_NOTICE,
    SKYBOT_SCHEDULER_SNMP_TRAP_EVENT_NOTICE,
    SKYBOT_SCHEDULER_JOB_STATUS_NOTICE,
    SKYBOT_SCHEDULER_MEMBER_JOB_STATUS_NOTICE,
    SKYBOT_SCHEDULER_MEMBER_JOB_SKIPPED_ON_GROUP_STATUS_NOTICE,
    SKYBOT_SCHEDULER_JOB_SUITE_STATUS_NOTICE,
    SKYBOT_SCHEDULER_DOES_NOT_HAVE_A_VALID_LICENSE,
    SNMP_TRAP_EVENT_OCCURRED,
    SNMP_TRAP_EVENT_OCCURRED_HELD,
    SNMP_TRAP_EVENT_OCCURRED_TIME_RANGE,
    SNMP_TRAP_MONITOR_STARTED,
    SNMP_TRAP_MONITOR_STOPPED,
    STANDBY_CLOCK_IS_NOT_IN_SYNC_SUBJECT,
    STANDBY_CLOCK_IS_NOT_IN_SYNC_MESSAGE,
    STARTING_WITH_SCHEDULER_STOPPED,
    STARTING_WITH_SCHEDULER_STOPPED_VIA_CONFIG,
    SUBMITTED_JOB,
    SUBMITTED_SCHEDULED_JOB,
    SUITE_ADD_NOTIFICATION,
    SUITE_ALREADY_ACTIVE,
    SUITE_CHANGE_ERROR,
    SUITE_CHANGE_NOTIFICATION,
    SUITE_ENDED_BY_USER,
    SUITE_ENDED_BY_JOB_MONITOR,
    SUITE_MEMBER_AGENT_GROUP_EMPTY,
    SUITE_MEMBER_ALL_AGENTS_IGNORED,
    SUITE_MEMBER_ENDED,
    SUITE_MEMBER_ENDED_VIA_REMOVAL_FROM_QUEUE,
    SUITE_MEMBER_NOT_ENDED,
    SUITE_MEMBER_CHANGE_NOTIFICATION,
    SUITE_MEMBER_CREATE_HISTORY_ERROR,
    SUITE_MEMBER_STATUS_CHANGE_ERROR,
    SUITE_MEMBER_SUBMITTED,
    SUITE_MEMBER_SUBMIT_ERROR,
    SUITE_MEMBER_WAS_IGNORED_IN_AGENT_GROUP,
    SUITE_MEMBER_WAS_IGNORED_UNTIL_IN_AGENT_GROUP,
    SUITE_MEMBER_WAS_SKIPPED_UNTIL_INCLUDED,
    SUITE_MEMBER_WAS_SKIPPED_NTH_TIME,
    SUITE_MEMBER_WAS_SKIPPED_UNTIL_DATE,
    SUITE_MEMBER_WAS_SKIPPED_BY_SPC_INST,
    SUITE_PREREQS_NOT_MET,
    SUITE_PREREQS_NOT_MET_FOR_MISSED,
    SUITE_STARTED,
    SUITE_STARTED_SCHEDULED,
    SUITE_STATUS_CHANGE_COMPLETED,
    SUITE_STATUS_CHANGE_OTHER,
    SUITE_WAS_HELD,
    SUITE_WAS_HELD_NTH_TIME,
    SUITE_WAS_HELD_UNTIL,
    TEMPORARY_LICENSE_EXPIRING_DAYS,
    UNABLE_TO_PROCESS_COMMAND,
    UNSUPPORTED_COMMAND_TYPE,
    JOB_PARAMETER_ERROR,
    USER_DISABLED,
    MINUTES_BASED_CLEANUP_NEXT_WAKEUP,
    MINUTES_BASED_CLEANUP_RUNNERS_ERROR_ENCOUNTERED,
    NO_MINUTES_BASED_CLEANUP_RUNNERS,
    EMAIL_TARGET_ATTACHMENT,
    OUTPUT_DISTRIBUTION_HISTORY,
    JOB_ERRORED_DUE_TO_COMMAND_PLATFORM_MISMATCH,
    JOB_ERRORED_DUE_TO_PROHIBITED_SEQUEL_COMMAND,
    MANUALLY_GENERATE_REPORT,
    AGENT_TIME_ZONE_CHANGED,
    JOB_RUN_IMMEDIATELY_BY_USER,
    EXPORT_FILE_CREATED,
    SKYBOT_SCHEDULER_SERVER_NOTICE_MISSED_JOB_MANAGING_EXISTS,
    SKYBOT_SCHEDULER_SERVER_NOTICE_MISSED_JOB_MANAGING_EXIST_ONE,
    SKYBOT_SCHEDULER_SERVER_NOTICE_AGENT_STOPPED_BY_USER,
    SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_DAYS,
    SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_TODAY,
    SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_TOMORROW,
    SKYBOT_SCHEDULER_STANBY_SERVER_NO_LICENSE,
    SAP_EVENT_NOT_LICENSED,
    SAP_EVENT_HELD,
    SAP_EVENT_OUTSIDE_TIME_SCOPE,
    SAP_EVENT_OCCURED,
    SAP_INITIAL_POLL_START,
    SAP_INITIAL_POLL_END,
    SAP_INTERCEPT_CRITERIA_SET,
    SAP_INTERCEPT_CRITERION_SET,
    SAP_INTERCEPT_POLLING_ENABLED,
    SAP_INTERCEPT_POLLING_DISABLED,
    SAP_JOBS_DELETED,
    SAP_LICENSE_INVALID,
    SAP_LICENSE_VALID,
    INFORMATICA_LICENSE_INVALID,
    INFORMATICA_LICENSE_VALID,
    SAP_NEXT_REMOVE_POLL_TIME,
    SAP_OBSOLETE_JOBS_DELETED,
    SAP_POLLING_ENABLED,
    SAP_POLLING_DISABLED,
    SAP_REMOVER_ENABLED,
    SAP_SKYBOT_REGISTERED_WITH_SLD,
    SAP_SLD_REGISTRATION_ERROR,
    UNIVERSAL_CONNECTOR_LICENSE_INVALID,
    UNIVERSAL_CONNECTOR_LICENSE_VALID;


    private static String getMsgText(RosettaMsg rosettaMsg) {
        switch (rosettaMsg) {
            case ADMIN_PROFILE_RESET: {
                return "The admin profile has been reset.";
            }
            case AGENT_CONNECTED: {
                return "Agent {0} has connected.";
            }
            case AGENT_DISCONNECTED: {
                return "Agent {0} is disconnecting as expected.";
            }
            case AGENT_DISCONNECTED_WITHOUT_WARNING: {
                return "Agent {0} is disconnecting unexpectedly.";
            }
            case ERROR_ON_AGENT: {
                return "An error occurred on agent {0}. Please see that agent''s diagnostic log for details.";
            }
            case PURGE_AUDIT_LOG_NAME: {
                return "Audit History";
            }
            case PURGE_FORECAST_NAME: {
                return "Forecast";
            }
            case AGENT_LOCKED_BY_USER: {
                return "Agent {0} was locked by {1}.  No jobs will be sent to this agent.";
            }
            case AGENT_UNLOCKED_BY_USER: {
                return "Agent {0} was unlocked by {1}.  Jobs will be sent to this agent.";
            }
            case JOB_QUEUE_CLEARED_BY_USER: {
                return "The job queue {0} was cleared by {1} resulting in {2} {3} being canceled.";
            }
            case JOB_QUEUE_UPDATED: {
                return "Job queue {0} on agent {2} was updated by job queue schedule {1}.";
            }
            case JOB_QUEUE_UPDATED_XAGENT: {
                return "Job queue {0} was updated by job queue schedule {1}.";
            }
            case JOB_QUEUE_HELD_BY_USER: {
                return "Job queue {0} was held by {1}.";
            }
            case JOB_QUEUE_RELEASED_BY_USER: {
                return "Job queue {0} was released by {1}.";
            }
            case ALL_JOB_QUEUES_LOCKED: {
                return "All job queues are locked...no jobs will run.";
            }
            case ALL_JOB_QUEUES_LOCKED_BY_USER: {
                return "All job queues were locked by {0}. No jobs will run.";
            }
            case ALL_JOB_QUEUES_UNLOCKED_BY_USER: {
                return "All job queues were unlocked by {0}.  Jobs will run on released job queues and unlocked Agents.";
            }
            case AGENT_REPLACED_BY_USER: {
                return "A request to replace Agent {0}:{1} with {2}:{3} was initiated by {4}.";
            }
            case AGENT_RESTARTED_BY_USER: {
                return "Agent {0} was restarted by {1}.";
            }
            case AGENT_STOPPED_BY_USER: {
                return "Agent {0} was stopped by {1}.";
            }
            case AGENT_UPDATE_INITIATED_BY_USER: {
                return "An update of Agent {0} was initiated by {1}.";
            }
            case AGENT_UPDATE_FAILED: {
                return "The update of Agent {0} initiated by {1} failed.  See the Server diagnostic log for further details.";
            }
            case AGENT_UPDATE_REQUIRED: {
                return "Please update Agent {1} to support new features found in the job {0}.";
            }
            case AGENT_UPDATE_STARTED: {
                return "Agent {0} is updating and will restart when completed.";
            }
            case AUTOMATE_USER_ACCOUNT_NOT_ACTIVE: {
                return "Automate User account {0} is not active.";
            }
            case AUTOMATE_USER_ALREADY_LOGGED_IN: {
                return "Automate User {0} is already logged in.";
            }
            case AUTOMATE_USER_LOCKED_OUT: {
                return "Automate User {0} is locked out.";
            }
            case AUTOMATE_USER_OR_PASSWORD_INCORRECT: {
                return "Automate User {0} or password is incorrect.";
            }
            case PURGE_RUNNER_NAME: {
                return "{0} Purge Runner";
            }
            case PURGE_AGENT_EVENT_LOG_NAME: {
                return "Agent Event Monitor History";
            }
            case CALENDAR_OBJECT_EXPIRING_DAYS: {
                return "The Calendar {0} will expire in {1} days.";
            }
            case CALENDAR_OBJECT_EXPIRING_TODAY: {
                return "The Calendar {0} will expire today.";
            }
            case CALENDAR_OBJECT_EXPIRING_TOMORROW: {
                return "The Calendar {0} will expire tomorrow.";
            }
            case CALENDAR_OBJECT_CHANGE_MISSING_JOB: {
                return "Could not process a Calendar Change event. Calendar was not found with ID: {0}.";
            }
            case CALENDAR_OBJECT_CHANGE_NOTIFICATION: {
                return "The scheduler was notified that Calendar {0} changed.";
            }
            case CLOCK_ADJUSTMENT_EXCEEDED_MAX_ALLOWED: {
                return "The Scheduler detected a clock adjustment that exceeded {0}. As a safety precaution, the Scheduler was automatically stopped. See the diagnostic log for further details.";
            }
            case COULDNT_FIND_VALID_LICENSE: {
                return "Automate Schedule does not have a valid primary or trial license.";
            }
            case COULDNT_FIND_VALID_PRIMARY_OR_TEMPORARY_LICENSE: {
                return "Automate Schedule does not have a valid primary or trial license.";
            }
            case DATE_OBJECT_EXPIRING_DAYS: {
                return "The Date List {0} will expire in {1} days.";
            }
            case DATE_OBJECT_EXPIRING_TODAY: {
                return "The Date List {0} will expire today.";
            }
            case DATE_OBJECT_EXPIRING_TOMORROW: {
                return "The Date List {0} will expire tomorrow.";
            }
            case DATE_OBJECT_CHANGE_MISSING_JOB: {
                return "Could not process a Date List Change event. Date List was not found with ID: {0}.";
            }
            case DATE_OBJECT_CHANGE_NOTIFICATION: {
                return "The scheduler was notified that Date List {0} changed.";
            }
            case DEFAULT_AGENT_USER_NOT_ALLOWED: {
                return "Running job {0} as Agent''s User is not allowed on Agent {1}.";
            }
            case DRIVER_STARTED: {
                return "The {0} has started.";
            }
            case DRIVER_ENDED: {
                return "The {0} has ended.";
            }
            case DRIVER_ENDED_IN_ERROR: {
                return "The {0} has ended in error.";
            }
            case ENTERPRISE_SERVER_SHUTDOWN: {
                return "The Automate Schedule Enterprise Server is shutting down.";
            }
            case ENTERPRISE_SERVER_STARTUP: {
                return "The Automate Schedule Enterprise Server is starting.";
            }
            case ERROR_CALCULATING_PURGE_DATE: {
                return "A fatal error occured calculating purge date.";
            }
            case EXPIRING_CALENDAR_OBJECT_NAME: {
                return "Expiring Calendar";
            }
            case EXPIRING_DATE_OBJECT_NAME: {
                return "Expiring Date List";
            }
            case EXPIRING_LICENSE_NAME: {
                return "Expiring License";
            }
            case AGENT_EVENT_OCCURRED: {
                return "{0} Event {1} History Id {2} occurred on agent {3}.";
            }
            case AGENT_EVENT_OCCURRED_HELD: {
                return "{0} Event {1} History Id {2} occurred on agent {3}; however the Agent Event Monitor is disabled.";
            }
            case AGENT_EVENT_OCCURRED_TIME_RANGE: {
                return "{0} Event {1} History Id {2} occurred on agent {3}; however it is outside of the time range specified.";
            }
            case AGENT_LICENSE_ALLOCATIONS_CHANGED_BY_USER: {
                return "Agent license allocations have been changed by {0}.";
            }
            case AGENT_LICENSE_DEALLOCATED: {
                return "Agent {0} was unlicensed due to insufficient licenses.";
            }
            case FAILED_TO_RUN: {
                return "{0} failed to run.";
            }
            case FORECAST_CLEANUP_COMPLETE_ONE: {
                return "Forecast cleanup process marked 1 inactive forecast as Failed that was Running before the last shutdown.";
            }
            case FORECAST_CLEANUP_COMPLETE_MULTIPLE: {
                return "Forecast cleanup process marked {0} inactive forecasts as Failed that were Running before the last shutdown.";
            }
            case FORECAST_GENERATION_STARTED: {
                return "Forecast generation has begun for forecast {0}.";
            }
            case FORECAST_GENERATION_COMPLETED: {
                return "Forecast generation has completed for forecast {0} that started at {1}.";
            }
            case FORECAST_GENERATION_FAILED: {
                return "Forecast generation has failed for forecast {0} that started at {1}.";
            }
            case FORECAST_RANGE_START_IN_PAST: {
                return "Forecast {0} did not run. The time range window of the forecast is defined to start {1}, which is in the past.";
            }
            case FORECAST_WINDOW_START_TIME_WAS_MOVED: {
                return "The starting date/time of the time range window for forecast {0} was moved to {1}, because the original starting time ({2}) is invalid, due to the switch to Daylight Saving Time.";
            }
            case FORECAST_WINDOW_END_TIME_WAS_MOVED: {
                return "The ending date/time of the time range window for forecast {0} was moved to {1}, because the original ending time ({2}) is invalid, due to the switch to Daylight Saving Time.";
            }
            case HISTORY_PURGE: {
                return "Purging {0} entries.";
            }
            case HISTORY_PURGE_COMPLETE: {
                return "{0} {1} entries were deleted.";
            }
            case INVALID_NST: {
                return "An invalid next scheduled time entry was encountered for job {0}. Please see Server History for details.";
            }
            case INVALID_NST_WRONG_AGENT_FOR_JOB: {
                return "An invalid next scheduled time entry was encountered: job = {0}, agent = {1}. Job {2} is currently defined to run on 1 agent and that agent is {3}.";
            }
            case INVALID_NST_AGENT_NOT_PART_OF_GROUP: {
                return "An invalid next scheduled time entry was encountered: job = {0}, agent = {1}. Job {2} is currently defined to run on agent group {3}. Agent {4} is not defined as part of {3}.";
            }
            case INVALID_NST_AGENT_SHOULD_BE_UNASSIGNED: {
                return "An invalid next scheduled time entry was encountered: job = {0}, agent = {1}. Job {2} is currently defined to run on agent group {3}. For this type of agent group, the agent should be unassigned at this point. That is, the agent ID should be zero.";
            }
            case INVALID_NST_PURGED: {
                return "Removed the invalid next scheduled time entry, with job ID = {0} and agent ID = {1}, from the database.";
            }
            case INVALID_NST_PURGED_MULTIPLE: {
                return "Removed the {0} invalid next scheduled time entries, with job ID = {1} and agent ID = {2}, from the database.";
            }
            case SUITE_HISTORY_PURGE_COMPLETE: {
                return "{0} {1} entries were deleted for suite {2}.";
            }
            case FORECAST_PURGE_COMPLETE: {
                return "{0} {1} entries were deleted.";
            }
            case JOB_ALREADY_ACTIVE: {
                return "Job {0} on agent {1} was not submitted because it is already active.";
            }
            case INVALID_PRIMARY_LICENSE: {
                return "The Automate Schedule primary license contains an invalid value, some agents will be disabled until this problem is corrected.";
            }
            case INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION_1: {
                return "Job {0} has an invalid path of ''{1}'' specified for the condition.";
            }
            case INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION_2: {
                return "Job {0} with run number {1} was not run on agent {2} and was marked with completion code " + JobStatusCode.ERROR.name() + " at {3}";
            }
            case JOB_CHANGE_ERROR: {
                return "Job {0} has changed and a request was made to recalculate the next scheduled time for the job (on all agents that it runs on). However, an error occurred while trying to perform the recalculations.";
            }
            case JOB_CHANGE_MISSING_JOB: {
                return "Could not process a Job Change event. Job was not found with ID: {0}.";
            }
            case JOB_ADDED_NOTIFICATION: {
                return "The scheduler was notified that job {0} was added.";
            }
            case JOB_CHANGE_NOTIFICATION: {
                return "The scheduler was notified that job {0} changed.";
            }
            case JOB_CHANGE_NOTIFICATION_AGENT_CHANGED: {
                return "The scheduler was notified that job {0} changed from {1} to {2}.";
            }
            case JOB_COMPLETED: {
                return "Job {0} with run number {3} completed on agent {1} at {5}.";
            }
            case JOB_DELAYED_COMPLETION_INFO: {
                return "Agent {0} is reporting that Job {1} with run number {2} ended with status {3}.";
            }
            case JOB_DELAYED_FAILURE_INFO: {
                return "Agent {0} is reporting that Job {1} with run number {2} ended with status {3} and reason {4}.";
            }
            case JOB_DELAYED_COMMAND_FAILURE_INFO: {
                return "Agent {0} is reporting that Job {1} with run number {2} ended with status {3} and reason {4} at command sequence {5}.";
            }
            case JOB_DELAYED_COMPLETION_WITH_PRIOR_INFO: {
                return "Agent {0} is reporting that Job {1} with run number {2} actually ended with status {3}.  The job was previously marked {6} with reason {7}.";
            }
            case JOB_DELAYED_COMPLETION_WITH_REASON_AND_PRIOR_INFO: {
                return "Agent {0} is reporting that Job {1} with run number {2} actually ended with status {3} and reason {4}.  The job was previously marked {6} with reason {7}.";
            }
            case JOB_DELAYED_COMMAND_FAILURE_WITH_PRIOR_INFO: {
                return "Agent {0} is reporting that Job {1} with run number {2} actually ended with status {3} and reason {4} at command sequence {5} .  The job was previously marked {6} with reason {7}.";
            }
            case JOB_FAILED: {
                return "Job {0} with run number {3} failed on agent {1} at {5}.";
            }
            case JOB_FAILED_AT_COMMAND: {
                return "Job {0} with run number {3} failed on agent {1} at command sequence {4} at {5}.";
            }
            case JOB_FAILED_DUE_TO_CONDITION: {
                return "Job {0} with run number {1} failed on agent {2} at {3} due to unsatisfied job condition: [{4}].";
            }
            case JOB_FAILED_DUE_TO_LICENSE: {
                return "Job {0} with run number {3} failed on agent {1}.  The agent is unlicensed.";
            }
            case JOB_FAILED_DUE_TO_INFORMATICA_LICENSE: {
                return "Job {0} with run number {3} failed on agent {1}.  The agent is not licensed for Informatica commands.";
            }
            case JOB_FAILED_DUE_TO_ORACLE_LICENSE: {
                return "Job {0} with run number {3} failed on agent {1}.  The agent is not licensed for Oracle commands.";
            }
            case JOB_FAILED_DUE_TO_SAP_LICENSE: {
                return "Job {0} with run number {3} failed on agent {1}.  The agent is not licensed for SAP commands.";
            }
            case JOB_FAILED_DUE_TO_UNIVERSAL_CONNECTOR_LICENSE: {
                return "Job {0} with run number {3} failed on agent {1}.  The agent is not licensed for Universal Connector commands.";
            }
            case JOB_CANCELED_DUE_TO_CONDITION: {
                return "Job {0} with run number {1} was canceled on agent {2} at {3} due to unsatisfied job condition: [{4}].";
            }
            case JOB_CANCELED_DUE_TO_TIMERANGE: {
                return "Job {0} with run number {3} was canceled on agent {1}.  The job was outside the allowable time range.";
            }
            case SUITE_CANCELED_DUE_TO_TIMERANGE: {
                return "Job suite {0} with run number {1} was canceled.  The job suite was outside the allowable time range.";
            }
            case JOB_ERRORED_DUE_TO_COMMAND_PLATFORM_MISMATCH: {
                return "Job {0} with run number {3} resulted in an error on agent {1}.  The job contains a command that is incompatible with the Agent platform.";
            }
            case JOB_ERRORED_DUE_TO_PROHIBITED_SEQUEL_COMMAND: {
                return "Job {0} with run number {2} resulted in an error on agent {1}.  The job contains a prohibited IBM i command that is not allowed for a SEQUEL Bundled license.";
            }
            case JOB_HELD_DUE_TO_FAILURE: {
                return "Job {0} on agent {1} has been held to prevent further failures.";
            }
            case JOB_SUITE_HELD_DUE_TO_FAILURE: {
                return "Job Suite {0} has been held to prevent further failures.";
            }
            case JOB_HISTORY_RECORD_DELETED: {
                return "Job History run number {0} for job {1} on Agent {2} was deleted by user {3}.";
            }
            case JOB_HISTORY_RECORD_MISMATCH: {
                return "Agent {0} is reporting that Job {1} with run number {2} ended with status {3}.  A matching history record was not found.";
            }
            case JOB_SUITE_HISTORY_RECORD_DELETED: {
                return "Job History run number {0} for job {1} was deleted by user {2}.";
            }
            case JOB_MARKED: {
                return "Job {0} with run number {2} was not run on agent {1} and was marked as managed.";
            }
            case SAP_LICENSE_INVALID: {
                return "The Automate Schedule Enterprise Server is not licensed for SAP features.";
            }
            case SAP_LICENSE_VALID: {
                return "The Automate Schedule Enterprise Server is licensed for SAP features.";
            }
            case INFORMATICA_LICENSE_INVALID: {
                return "The Automate Schedule Enterprise Server is not licensed for Informatica features.";
            }
            case INFORMATICA_LICENSE_VALID: {
                return "The Automate Schedule Enterprise Server is licensed for Informatica features.";
            }
            case ORACLE_LICENSE_INVALID: {
                return "The Automate Schedule Enterprise Server is not licensed for Oracle features.";
            }
            case ORACLE_LICENSE_VALID: {
                return "The Automate Schedule Enterprise Server is licensed for Oracle features.";
            }
            case MANAGED_JOB_SUBMITTED_BY_USER: {
                return "Managed Job {0} was submitted to agent {1} and job queue {2} at {3} by user {4} with run number {5}.";
            }
            case MANAGED_SUITE_SUBMITTED_BY_USER: {
                return "Managed Suite {0} was submitted at {1} by user {2} with run number {3}.";
            }
            case SKIPPED_JOB_SUBMITTED_BY_USER: {
                return "Skipped Job {0} was submitted to agent {1} and job queue {2} at {3} by user {4} with run number {5}.";
            }
            case JOB_NOT_SUBMITTED_REACTIVE_TIME_RANGE: {
                return "Job {0} was not submitted to agent {1} because it is not within the defined reactivity time range.";
            }
            case JOB_SUITE_NOT_SUBMITTED_REACTIVE_TIME_RANGE: {
                return "Job Suite {0} was not submitted because it is not within the defined reactivity time range.";
            }
            case JOB_RESTARTED_BY_USER: {
                return "Job {0} with run number {1} was restarted on agent {2} at {3} by user {4} with run number {5}.";
            }
            case JOB_SUITE_SUBMITTED_BY_USER: {
                return "Job Suite {0} was submitted at {1} by user {2} with run number {3}.";
            }
            case JOB_SUBMITTED_BY_USER: {
                return "Job {0} was submitted to agent {1} and job queue {2} at {3} by user {4} with run number {5}.";
            }
            case MANAGED_JOB_REMOVED_BY_USER: {
                return "Managed Job {0} with run number {1} was deleted by user {2} at {3}.";
            }
            case MANAGED_JOB_ENDED_BY_USER: {
                return "Managed Job {0} on agent {1} with run number {2} was ended at {3} by user {4} with a status of {5}.";
            }
            case MANAGED_SUITE_ENDED_BY_USER: {
                return "Managed suite {0} with run number {1} was ended at {2} by user {3} with a status of {4}.";
            }
            case JOB_ENDED_BY_USER: {
                return "Job {0} on agent {1} with run number {2} was ended at {3} by user {4} with a status of {5}.";
            }
            case JOB_CANCELED_BY_JOB_MONITOR: {
                return "Job {0} on agent {1} with run number {2} was canceled at {3} by a Job Monitor.";
            }
            case JOB_REMOVED_FROM_QUEUE_BY_USER: {
                return "Job {0} on agent {1} with run number {2} was removed from the job queue at {3} by user {4} with a status of {5}.";
            }
            case JOB_WAS_HELD: {
                return "Job {0} on agent {1} was not submitted for scheduled time {2} because it was held.";
            }
            case JOB_WAS_IGNORED_IN_AGENT_GROUP: {
                return "Job {0} on agent {1} was not submitted for scheduled time {2} because it was ignored in the agent group.";
            }
            case JOB_WAS_IGNORED_UNTIL_IN_AGENT_GROUP: {
                return "Job {0} on agent {1} was not submitted for scheduled time {2} because it was ignored in the agent group until {3}.";
            }
            case JOB_WAS_HELD_NTH_TIME: {
                return "Job {0} on agent {1} was not submitted for scheduled time {2} because it was held for {3} of {4} times.";
            }
            case JOB_WAS_HELD_UNTIL: {
                return "Job {0} on agent {1} was not submitted for scheduled time {2} because it was held until {3}.";
            }
            case JOB_WAS_NOT_RUN: {
                return "Job {0} with run number {3} was not run on agent {1} and was marked with completion code {2} at {5}.";
            }
            case JOB_PRIORITY_CHANGED: {
                return "Priority changed by user {0} for job {1} on agent {2} with run number {3} from {4} to {5}.";
            }
            case JOB_MONITOR_EVENT_OCCURRED: {
                return "{0} Monitor Event occurred for Job {1} with run number {2} on agent {3}.";
            }
            case JOB_MONITOR_EVENT_OCCURRED_LATE_START: {
                return "{0} Monitor Event occurred for Job {1} with run number {2} on agent {3} scheduled to run at {4}.";
            }
            case JOB_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME: {
                return "{0} Monitor Event occurred for Job {1} on agent {2} scheduled to run at {3}.";
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED: {
                return "{0} Monitor Event occurred for Job Suite Member {1} with run number {2} on agent {3} for suite run number {4}.";
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED_LATE_START: {
                return "{0} Monitor Event occurred for Job Suite Member {1} with run number {2} on agent {3} scheduled to run at {4} for suite run number {5}.";
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME: {
                return "{0} Monitor Event occurred for Job Suite Member {1} on agent {2} scheduled to run at {3} for suite run number {4}.";
            }
            case JOB_SUITE_MONITOR_EVENT_OCCURRED: {
                return "{0} Monitor Event occurred for Job Suite {1} with run number {2}.";
            }
            case JOB_SUITE_MONITOR_EVENT_OCCURRED_LATE_START: {
                return "{0} Monitor Event occurred for Job Suite {1} with run number {2} scheduled to run at {4}.";
            }
            case JOB_SUITE_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME: {
                return "{0} Monitor Event occurred for Job Suite {1} scheduled to run at {3}.";
            }
            case MISSED_JOB_COMPLETING: {
                return "Completing the missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_COMPLETING: {
                return "Completing the missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_COMPLETING_AN_ADDITIONAL: {
                return "Completing an additional missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_COMPLETING_AN_ADDITIONAL: {
                return "Completing an additional missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_IGNORING: {
                return "Ignoring the missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_IGNORING: {
                return "Ignoring the missed occurrence of Suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_IGNORING_AN_ADDITIONAL: {
                return "Ignoring an additional missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_IGNORING_AN_ADDITIONAL: {
                return "Ignoring an additional missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_MANAGING_EXIST: {
                return "{0} missed jobs require user action.";
            }
            case MISSED_JOB_MANAGING_EXIST_ONE: {
                return "1 missed job requires user action.";
            }
            case MISSED_JOB_MANAGING: {
                return "Managing the missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_MANAGING: {
                return "Managing the missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_MANAGING_AN_ADDITIONAL: {
                return "Managing an additional missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_MANAGING_AN_ADDITIONAL: {
                return "Managing an additional missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_SUBMITTING_FIRST: {
                return "Submitting the first missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_SUBMITTING_FIRST: {
                return "Submitting the first missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_SUBMITTING_AN_ADDITIONAL: {
                return "Submitting an additional missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_SUBMITTING_AN_ADDITIONAL: {
                return "Submitting an additional missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_FAILING: {
                return "Failing the missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_FAILING: {
                return "Failing the missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_FAILING_AN_ADDITIONAL: {
                return "Failing an additional missed occurrence of job {0} for agent {1} which was scheduled to run at {2}";
            }
            case MISSED_SUITE_FAILING_AN_ADDITIONAL: {
                return "Failing an additional missed occurrence of suite {0} which was scheduled to run at {1}";
            }
            case MISSED_JOB_PROCESS_STARTED: {
                return "Processing missed jobs that were scheduled prior to {0}.";
            }
            case MISSED_JOB_PROCESS_COMPLETED: {
                return "Completed processing {1} missed jobs scheduled prior to {0}. Ignored: {2}, Failed: {3}, Completed: {4}, Ran: {5}, added to Missed Jobs Screen: {6} ";
            }
            case MISSED_JOB_SUBMITTED: {
                return "The history record for job {0} with run number {1} was submitted by the missed job process.  It was never fully submitted before the last shutdown.";
            }
            case MISSED_QUEUED_JOB_IGNORED: {
                return "The history record for queued job {0} with run number {1} was removed due to the missed job action of ignore.";
            }
            case MOVE_NON_WORKDAY_RUN_TO_PRIOR_WORKDAY: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2}, was moved to {3} because the ''Run on non-work day'' option was set to ''Run on nearest prior workday''.";
            }
            case MOVE_NON_WORKDAY_RUN_TO_SUBSEQUENT_WORKDAY: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2}, was moved to {3} because the ''Run on non-work day'' option was set to ''Run on nearest subsequent workday''.";
            }
            case NO_DAILY_CLEANUP_RUNNERS: {
                return "No daily cleanup runners are registered...";
            }
            case NST_CALC_BAD_SCHEDULE_INFO: {
                return "Unable to determine the next scheduled runtime for job {0} on agent {1}, due to corrupted scheduling data. {2} Details: {3}";
            }
            case NST_CALC_ERROR_MULTIPLE_SYSTEMS: {
                return "An error occurred while trying to calculate and update the next scheduled runtimes for all of the {0} agents associated with job {1}. {2} of {0} were successful. Please look for additional detailed messages in this log. Note: This was an unanticipated error and no attempt was made to change or clear the next scheduled runtime, in the database, for the agents that were not processed! Cause: {3}";
            }
            case NST_CALC_RUNTIME_ADJUSTED_DUE_TO_INVALID_DATETIME_DST: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2} {3}, was moved to {4}, because the originally scheduled date/time is invalid, due to the switch to Daylight Saving Time.";
            }
            case NST_CALC_TIME_DATA_NOT_SAVED: {
                return "Unable to save the next scheduled runtime ({0}) for job {1} on agent {2}.";
            }
            case NST_CALC_UNABLE_TO_DETERMINE: {
                return "Unable to determine the next scheduled runtime for job {0} on agent {1}. Cause: {2}";
            }
            case NST_CALC_UNABLE_TO_DETERMINE_MULTIPLE_SYSTEMS: {
                return "Unable to determine the next scheduled runtimes for all of the {0} agents associated with job {1}. {2} of {0} were successful. Please look for additional detailed messages in this log.";
            }
            case NST_CALC_UNABLE_TO_DETERMINE_NOT_SET_TO_NULL: {
                return "Unable to determine the next scheduled runtime for job {0} on agent {1}. {2} Cause: {3}";
            }
            case NST_CALC_UNABLE_TO_DETERMINE_NOT_SET_TO_NULL_JOB_CHANGE: {
                return "Unable to process the job change request for job {0}. {1} Cause: {2}";
            }
            case NST_CALC_UNRECOGNIZED_TIME_ZONE_ID: {
                return "The time zone ID {0}, for job/suite {1} is unrecognized. The server''s time zone ({2}) will be used instead, for the calculation of the next scheduled time.";
            }
            case DAILY_CLEANUP_RUNNERS_ERROR_ENCOUNTERED: {
                return "The {0} daily cleanup runner encounted an error.  {1}";
            }
            case DAILY_CLEANUP_NEXT_WAKEUP: {
                return "The Daily Cleanup process is starting now and will resume on {0}.";
            }
            case PREREQUISITE_STATUS_NOT_ACCEPTED_BY_SPECIAL_INSTANCE: {
                return "Prerequisite status ''{6}'' from {0} ''{1}'' from agent ''{2}'' with scheduled time {3} was not accepted by special instance definition ''{4}'' for reactive job ''{5}''.";
            }
            case PREREQUISITE_STATUS_FOR_AGENTLESS_EVENT_NOT_ACCEPTED_BY_SPECIAL_INSTANCE: {
                return "Prerequisite status ''{5}'' from {0} ''{1}'' with scheduled time {2} was not accepted by special instance definition ''{3}'' for reactive job ''{4}''.";
            }
            case PREREQ_NOT_MET: {
                return "Prerequisites have not been met for job {0} on agent {1} scheduled at {2}.";
            }
            case PREREQ_NOT_MET_FOR_MISSED: {
                return "Prerequisites have not been met for missed job {0} on agent {1} scheduled at {2}.";
            }
            case PRIMARY_LICENSE_EXPIRING_DAYS: {
                return "The Automate Schedule primary license will expire on {0}.";
            }
            case PURGE_OLDER_THAN: {
                return "Purging {0} entries over {1} days old.";
            }
            case PURGE_DELETED_OVER_DAYS: {
                return "Purging {0} entries for deleted jobs over {1} days old.";
            }
            case PURGE_FORECAST: {
                return "Purging forecast entries with default days to keep value {0} on {1}";
            }
            case PURGE_COMPLETE: {
                return "{0} {1} entries older than {2} were deleted.";
            }
            case PURGE_SUITE_HISTORY_NAME: {
                return "Job Suite History";
            }
            case PURGE_JOB_HISTORY_NAME: {
                return "Job History";
            }
            case PURGE_REMOTE_HISTORY_NAME: {
                return "Remote History";
            }
            case PURGE_REMOTE_EVENT_HISTORY_NAME: {
                return "Remote Event History";
            }
            case PURGE_SKYBOT_EVENT_HISTORY_NAME: {
                return "Automate Schedule Event History";
            }
            case PURGE_SAP_INTERCEPTED_JOB_HISTORY_NAME: {
                return "SAP Intercepted Job History";
            }
            case PURGE_SAP_INTERCEPTED_JOB_HISTORY: {
                return "Purging SAP Intercepted Job History entries with days to keep value {0} on {1}.";
            }
            case PURGE_LOGS: {
                return "Purging Log files in {0} older than {1}.";
            }
            case SAP_SKYBOT_REGISTERED_WITH_SLD: {
                return "Successfully registered Automate Schedule with {0} on {1} to the SAP SLD at {2}.";
            }
            case SAP_SLD_REGISTRATION_ERROR: {
                return "Failed to register Automate Schedule with {0} on {1} to the SAP SLD at {2}.  Reason:{3}";
            }
            case ROLLUP_PURGE_RUNNER_NAME: {
                return "Purge Rollup Runner";
            }
            case LOG_PURGE_RUNNER_NAME: {
                return "Log Purge Runner";
            }
            case PURGE_JOB_MONITOR_EVENTS_NAME: {
                return "Job Monitor Event History";
            }
            case PURGE_LOG_SKIPPED: {
                return "System Settings do not allow for automatic purging of {0}.";
            }
            case PURGE_SCHEDULE_LOG_NAME: {
                return "Server History";
            }
            case PURGE_SESSIONS_NAME: {
                return "Sessions";
            }
            case PURGE_SNMP_EVENTS_NAME: {
                return "SNMP Trap Monitor Event  History";
            }
            case PURGE_SYSTEM_MESSAGES_NAME: {
                return "System Message";
            }
            case JOB_MOVED_TO_QUEUE: {
                return "Job {0} with run number {1} was moved from Agent {2} Queue {3} to Agent {4} Queue {5} by user {6}.";
            }
            case JOB_LOAD_BALANCED_BY_USER: {
                return "Job {0} with run number {1} was load balanced from Agent {2} by user {3}.";
            }
            case REACTIVE_JOB_NOT_SUBMITTED_OMITTED_PER_DATE_LIST: {
                return "Reactive job {0} was not submitted to agent {1} because it was omitted per Date List {2}.";
            }
            case REACTIVE_JOB_NOT_SUBMITTED_NON_WORKDAY_RULE: {
                return "Reactive job {0} was not submitted to agent {1} because it was a non-work day and the ''Run on non-work day'' option was set to ''Do not run''.";
            }
            case REACTIVE_JOB_SUITE_NOT_SUBMITTED_OMITTED_PER_DATE_LIST: {
                return "Reactive job suite {0} was not submitted because it was omitted per Date List {2}.";
            }
            case REACTIVE_JOB_SUITE_NOT_SUBMITTED_NON_WORKDAY_RULE: {
                return "Reactive job suite {0} was not submitted because it was a non-work day and the ''Run on non-work day'' option was set to ''Do not run''.";
            }
            case REMOTE_SERVER_APPROVED: {
                return "Remote server {0} was approved by user {1}.";
            }
            case REMOTE_SERVER_CONNECT: {
                return "Remote server {0} has connected.";
            }
            case REMOTE_SERVER_DISCONNECT: {
                return "Remote server {0} has disconnected.";
            }
            case REMOTE_SERVER_UNABLE_TO_CONNECT: {
                return "Unable to connect to remote server {0}.";
            }
            case REMOTE_SERVER_HAS_NOT_YET_CONNECTED: {
                return "Remote server {0} has not yet connected.";
            }
            case REMOTE_SERVER_FORCED_DISCONNECT: {
                return "A change has been made to the IP address and/or listen port for remote server {0} (ID {1}). If there is an active connection to that remote server, based on the old values, it will be terminated and a new connection will be attempted using the new values.";
            }
            case REMOTE_SERVER_DELETED_AND_ACTIVE_CONNECTION: {
                return "The database entry for remote server {0} (ID = {1}) was deleted. There is an active connection to that remote server and it will be ended.";
            }
            case REMOTE_SERVER_DELETED_AND_NO_ACTIVE_CONNECTION: {
                return "The database entry for remote server {0} (ID = {1}) was deleted. There is no active connection to that remote server.";
            }
            case REQUEUED_JOBS: {
                return "Completed processing missed queued jobs. Re-Queued Jobs: {0}.";
            }
            case REPLICATION_IS_NOT_ACTIVE_MESSAGE: {
                return "The Automate Schedule server is not able to access the database replication statistics.  This indicates the standby database is not properly connected.";
            }
            case REPLICATION_IS_NOT_ACTIVE_SUBJECT: {
                return "Automate Schedule database replication is not active.";
            }
            case REPORT_ROWS_LIMIT: {
                return "The {0} exceeded the record limit ({1}) for the report";
            }
            case REQUEUING_AGENT_QUEUES: {
                return "About to process any missed jobs that were on agent queues prior to last shutdown.";
            }
            case RSI_LICENSE_INVALID: {
                return "The Automate Schedule Enterprise Server is not licensed for Robot SCHEDULE features.";
            }
            case RSI_LICENSE_VALID: {
                return "The Automate Schedule Enterprise Server is licensed for Robot SCHEDULE features.";
            }
            case SKYBOT_VARIABLE_SET_BY_API: {
                return "The value of Automate Schedule Variable {0} is changed from {1} to {2}.";
            }
            case SKYBOT_VARIABLE_UNRESOLVED: {
                return "Automate Schedule Variable {0} cannot be resolved.  Reason: {1}";
            }
            case SKYBOT_VARIABLE_VALUE_IS_TOO_LONG: {
                return "Cannot assign the {2}-character value {0} to Automate Schedule Variable {1}.  The maximum length allowed for a Automate Schedule Variable value is {3} characters.";
            }
            case RUNNER_NAME: {
                return "{0} Runner";
            }
            case SAP_COMMAND_BACKLEVEL_AGENT: {
                return "Please update agent {1} to use the SAP command features in the job {0}.";
            }
            case SQL_SERVER_JOB_BACKLEVEL_AGENT: {
                return "Please update agent {1} to use the SQL Server job features in the job {0}.";
            }
            case SAP_INITIAL_POLL_START: {
                return "Initial poll of {0} SAP jobs from SAP System {1} has started.";
            }
            case SAP_INITIAL_POLL_END: {
                return "Initial poll of {0} SAP jobs from SAP System {1} has completed.";
            }
            case SAP_INTERCEPT_CRITERIA_SET: {
                return "SAP Intercept Criteria on SAP System {0} was set with {1} criterions by {2}";
            }
            case SAP_INTERCEPT_CRITERION_SET: {
                return "SAP Intercept Criterion(User:{0}; Job:{1}; Client:{2}) on SAP System {3} set by {4}";
            }
            case SAP_INTERCEPT_POLLING_ENABLED: {
                return "Polling Intercepted jobs is enabled for SAP System Definition {0} every {1} minute(s).";
            }
            case SAP_INTERCEPT_POLLING_DISABLED: {
                return "Polling Intercepted jobs is disabled for SAP System Definition {0}.";
            }
            case SAP_JOBS_DELETED: {
                return "{0} SAP job(s) were removed from Automate Schedule for the SAP System Definition {1} deleted by {2}.";
            }
            case SAP_NEXT_REMOVE_POLL_TIME: {
                return "The next polling of terminal jobs for SAP System {0} will occur at {1}.";
            }
            case SAP_OBSOLETE_JOBS_DELETED: {
                return "{0} SAP job(s) were deleted from Automate Schedule that no longer exist on SAP System {1}.";
            }
            case SAP_POLLING_ENABLED: {
                return "Polling jobs is enabled for SAP System Definition {0} every {1} minute(s).";
            }
            case SAP_REMOVER_ENABLED: {
                return "Polling terminal jobs for SAP System Definition {0} is active.";
            }
            case SAP_POLLING_DISABLED: {
                return "Polling jobs is disabled for SAP System Definition {0}.";
            }
            case SCHEDULED_INTERVAL_JOB_RUN_OMITTED_FOR_DAY: {
                return "All scheduled runs of Interval job {0} on agent {1} have been omitted for {2}, per Date List {3}.";
            }
            case SCHEDULED_JOB_RUN_OMITTED: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2}, was omitted per Date List {3}.";
            }
            case SCHEDULER_BYPASSED_JOB: {
                return "The Scheduler bypassed the processing of job {0} on agent {1}, scheduled for {2} because it determined that it had already processed this occurrence of the job.";
            }
            case SCHEDULER_DRIVER_STARTED: {
                return "The scheduler has started.";
            }
            case SCHEDULER_DRIVER_STARTED_BY_USER: {
                return "The scheduler has been started by {0}.";
            }
            case SCHEDULER_DRIVER_STOPPED_BY_USER: {
                return "The scheduler has been stopped by {0}...no scheduled jobs will run.";
            }
            case SERVER_LICENSED_BY_USER: {
                return "The Server license has been applied by {0}.";
            }
            case SKIP_NON_WORKDAY_RUN_DO_NOT_RUN: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2}, will NOT run at that date/time because it falls on a non-work day and the ''Run on non-work day'' option was set to ''Do not run''.";
            }
            case SKYBOT_SCHEDULER_SERVER_NOTICE: {
                return "Automate Schedule Server Notice";
            }
            case SKYBOT_SCHEDULER_AGENT_DISCONNECT_NOTICE: {
                return "The Automate Schedule Agent {0} has disconnected from the server.";
            }
            case SKYBOT_SCHEDULER_SNMP_TRAP_EVENT_NOTICE: {
                return "Automate Schedule SNMP Trap {0} Event Notice";
            }
            case SKYBOT_SCHEDULER_JOB_STATUS_NOTICE: {
                return "Job {0} with run number {1} on agent {2} entered {3} status.";
            }
            case SKYBOT_SCHEDULER_MEMBER_JOB_STATUS_NOTICE: {
                return "Job {0} with run number {1} on agent {2} for job suite {4} with run number {5} entered {3} status.";
            }
            case SKYBOT_SCHEDULER_MEMBER_JOB_SKIPPED_ON_GROUP_STATUS_NOTICE: {
                return "Job Suite Member {0} on agent group {1} with scheduled time {4} for job suite {2} with run number {3} was skipped.";
            }
            case SKYBOT_SCHEDULER_JOB_SUITE_STATUS_NOTICE: {
                return "Job Suite {0} with run number {1} entered {2} status.";
            }
            case SKYBOT_SCHEDULER_DOES_NOT_HAVE_A_VALID_LICENSE: {
                return "Automate Schedule does not have a valid primary or temporary license.";
            }
            case SKIP_NON_WORKDAY_RUN_PRIOR_WORKDAY_IS_OMIT: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2}, will NOT run at that date/time because it falls on a non-work day and the ''Run on non-work day'' option was set to ''Run on nearest prior workday''. However, the nearest prior workday is {3} and that has been designated an omit date per Date List {4}.";
            }
            case SKIP_NON_WORKDAY_RUN_PRIOR_WORKDAY_IS_RUNDAY: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2}, will NOT run at that date/time because it falls on a non-work day and the ''Run on non-work day'' option was set to ''Run on nearest prior workday''. However, the nearest prior workday is {3} and there are already 1 or more regularly scheduled times on that day when this job is scheduled to run.";
            }
            case SKIP_NON_WORKDAY_RUN_SUBSEQUENT_WORKDAY_IS_OMIT: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2}, will NOT run at that date/time because it falls on a non-work day and the ''Run on non-work day'' option was set to ''Run on nearest subsequent workday''. However, the nearest subsequent workday is {3} and that has been designated an omit date per Date List {4}.";
            }
            case SKIP_NON_WORKDAY_RUN_SUBSEQUENT_WORKDAY_IS_RUNDAY: {
                return "The scheduled run of job {0} on agent {1}, scheduled for {2}, will NOT run at that date/time because it falls on a non-work day and the ''Run on non-work day'' option was set to ''Run on nearest subsequent workday''. However, the nearest subsequent workday is {3} and there are already 1 or more regularly scheduled times on that day when this job is scheduled to run.";
            }
            case SNMP_TRAP_EVENT_OCCURRED: {
                return "SNMP Trap Event {0} Id {1} occurred.";
            }
            case SNMP_TRAP_EVENT_OCCURRED_HELD: {
                return "SNMP Trap Event {0} Id {1} occurred; however the SNMP Trap Monitor is disabled.";
            }
            case SNMP_TRAP_EVENT_OCCURRED_TIME_RANGE: {
                return "SNMP Trap Event {0} Id {1} occurred; however it is outside of the time range specified.";
            }
            case SNMP_TRAP_MONITOR_STARTED: {
                return "SNMP Trap Monitoring has started.";
            }
            case SNMP_TRAP_MONITOR_STOPPED: {
                return "SNMP Trap Monitoring has been stopped.  No SNMP Traps will be processed.";
            }
            case STANDBY_CLOCK_IS_NOT_IN_SYNC_SUBJECT: {
                return "Standby server clock is out of sync with the server clock.";
            }
            case STANDBY_CLOCK_IS_NOT_IN_SYNC_MESSAGE: {
                return "The clock time of the standby server ({0}) is not in synch with the clock time of the master server ({1}).";
            }
            case STARTING_WITH_SCHEDULER_STOPPED: {
                return "Starting the server with the scheduler stopped option.";
            }
            case STARTING_WITH_SCHEDULER_STOPPED_VIA_CONFIG: {
                return "Starting the server with the scheduler stopped by current settings.";
            }
            case SUBMITTED_JOB: {
                return "Job {0} on agent {2} was submitted at {3} with initiation code {1} with run number {4}.";
            }
            case SUBMITTED_SCHEDULED_JOB: {
                return "Job {0} on agent {3} was submitted at {4} with initiation code {1} with run number {5} with scheduled time {2}.";
            }
            case SUITE_ADD_NOTIFICATION: {
                return "The scheduler was notified that suite {0} was added.";
            }
            case SUITE_ALREADY_ACTIVE: {
                return "Suite {0} was not started because it is already active.";
            }
            case SUITE_CHANGE_ERROR: {
                return "Suite {0} has changed and a request was made to recalculate the next scheduled time for the suite. However, an error occurred while trying to perform the recalculations.";
            }
            case SUITE_CHANGE_NOTIFICATION: {
                return "The scheduler was notified that suite {0} was changed.";
            }
            case SUITE_ENDED_BY_USER: {
                return "Suite {0} with run number {1} was ended at {2} by user {3} with a status of {4}.";
            }
            case SUITE_ENDED_BY_JOB_MONITOR: {
                return "Suite {0} with run number {1} was canceled at {2} by a Job Monitor.";
            }
            case SUITE_MEMBER_AGENT_GROUP_EMPTY: {
                return "Suite member {0} was not assigned to any agents when it was time to submit it as part of job suite {1} with run number {2}, because agent group {3} was empty. Suite processing continued as if member {0} had completed normally.";
            }
            case SUITE_MEMBER_ALL_AGENTS_IGNORED: {
                return "Suite member {0} was not assigned to any agents when it was time to submit it as part of job suite {1} with run number {2}, because all agents in agent group {3} were configured to be ignored. Suite processing continued as if member {0} had completed normally.";
            }
            case SUITE_MEMBER_ENDED: {
                return "Suite member {0} on agent {1} with run number {2} was ended with a status of {3} because the suite that it was running as part of was ended with a status of {3}.";
            }
            case SUITE_MEMBER_ENDED_VIA_REMOVAL_FROM_QUEUE: {
                return "Suite member {0} on agent {1} with run number {2} was removed from the agent queue and marked with a status of {3} because the suite that it was running as part of was ended with a status of {3}.";
            }
            case SUITE_MEMBER_NOT_ENDED: {
                return "A request was made to terminate suite member {0} with run number {1}, but either the server was unable to contact the agent or an error occurred while the agent was trying to terminate the job.";
            }
            case SUITE_MEMBER_CHANGE_NOTIFICATION: {
                return "The scheduler was notified that member job {0} was changed.";
            }
            case SUITE_MEMBER_CREATE_HISTORY_ERROR: {
                return "Error while trying to submit Suite member {0} to run on agent {1} as part of job suite {2} with run number {3}. Unable to create the Job History entry.";
            }
            case SUITE_MEMBER_STATUS_CHANGE_ERROR: {
                return "Job Suite processing has been notified of a change in the status of member job {0} on agent {1} to {2}. However, an error occurred while trying to record the member status. This also means that the status for suite {3} with run number {4} may not reflect the change of the member status.";
            }
            case SUITE_MEMBER_SUBMITTED: {
                return "Suite member {0} was submitted to run on agent {1} at {2} with run number {3} as part of job suite {4} with run number {5}.";
            }
            case SUITE_MEMBER_SUBMIT_ERROR: {
                return "Error while trying to submit Suite member {0} as part of job suite {1} with run number {2}.";
            }
            case SUITE_MEMBER_WAS_IGNORED_IN_AGENT_GROUP: {
                return "Suite member {0} was not submitted on agent {1} as part of job suite {2} with run number {3} because it was marked as ignore in the agent group.";
            }
            case SUITE_MEMBER_WAS_IGNORED_UNTIL_IN_AGENT_GROUP: {
                return "Suite member {0} was not submitted on agent {1} as part of job suite {2} with run number {3} because it was marked as ignore in the agent group, until {4}.";
            }
            case SUITE_PREREQS_NOT_MET: {
                return "Prerequisites have not been met for suite {0} scheduled at {1}.";
            }
            case SUITE_PREREQS_NOT_MET_FOR_MISSED: {
                return "Prerequisites have not been met for missed suite {0} scheduled at {1}.";
            }
            case SUITE_MEMBER_WAS_SKIPPED_UNTIL_INCLUDED: {
                return "Suite member {0} (which runs on {1} {2}) was skipped for run number {3} of suite {4} because it is skipped until included.";
            }
            case SUITE_MEMBER_WAS_SKIPPED_NTH_TIME: {
                return "Suite member {0} (which runs on {1} {2}) was skipped for run number {3} of suite {4} because it was skipped for {5} of {6} times.";
            }
            case SUITE_MEMBER_WAS_SKIPPED_UNTIL_DATE: {
                return "Suite member {0} (which runs on {1} {2}) for suite scheduled time {6} was skipped for run number {3} of suite {4} because it is skipped until {5}.";
            }
            case SUITE_MEMBER_WAS_SKIPPED_BY_SPC_INST: {
                return "Suite member {0} (which runs on {1} {2}) for suite scheduled time {6} was skipped for run number {3} of suite {4}, per Special Instance {5}.";
            }
            case SUITE_STARTED: {
                return "Suite {0} started at {1} with initiation code {2} with run number {3}. {4} members.";
            }
            case SUITE_STARTED_SCHEDULED: {
                return "Suite {0} started at {1} with initiation code {2} with run number {3} with scheduled time {5}. {4} members.";
            }
            case SUITE_STATUS_CHANGE_COMPLETED: {
                return "Suite {0} with run number {1} completed at {2}.";
            }
            case SUITE_STATUS_CHANGE_OTHER: {
                return "Suite {0} with run number {1} changed to {3} status at {2}.";
            }
            case SUITE_WAS_HELD: {
                return "Suite {0} was not started for scheduled time {1} because it was held.";
            }
            case SUITE_WAS_HELD_NTH_TIME: {
                return "Suite {0} was not started for scheduled time {1} because it was held for {2} of {3} times.";
            }
            case SUITE_WAS_HELD_UNTIL: {
                return "Suite {0} was not started for scheduled time {1} because it was held until {2}.";
            }
            case TEMPORARY_LICENSE_EXPIRING_DAYS: {
                return "The Automate Schedule trial license will expire on {0}.";
            }
            case UNABLE_TO_PROCESS_COMMAND: {
                return "Unable to process command: {0}";
            }
            case UNSUPPORTED_COMMAND_TYPE: {
                return "Please update Agent {1} to support the command type {2} found in the job {0}.";
            }
            case JOB_PARAMETER_ERROR: {
                return "Job parameter error occurred.";
            }
            case USER_DISABLED: {
                return "Username {0} has been disabled due to maximum number of invalid login attempts.";
            }
            case CONDITIONAL_JOB_ENTER_RETRY_WAIT: {
                return "Job {0} with run number {1} on agent {3} entered Condition Retry-Wait status due to unsatisfied job condition: [{2}]";
            }
            case CONDITIONAL_JOB_RUN_ANYWAY: {
                return "Job {0} with run number {1} on agent {2} will run despite unsatisfied job condition: [{3}].";
            }
            case CONDITIONAL_JOB_RUN_BY_USER: {
                return "Conditional job {0} with run number {1} on agent {2} was manually set to run immediately by user {3}.";
            }
            case CONDITIONAL_JOB_BACKLEVEL_AGENT: {
                return "Please update agent {1} to use new job condition options in job {0}.";
            }
            case CONDITIONAL_JOB_BACKLEVEL_AGENT_RETRY: {
                return "Please update agent {0} to use condition retry options in job {1}.";
            }
            case EMAIL_TARGET_ATTACHMENT: {
                return "Email target attachment";
            }
            case MINUTES_BASED_CLEANUP_RUNNERS_ERROR_ENCOUNTERED: {
                return "The {0} minutes based cleanup runner encounted an error.  {1}";
            }
            case MINUTES_BASED_CLEANUP_NEXT_WAKEUP: {
                return "The minutes based cleanup process is starting now and will resume on {0}.";
            }
            case NO_MINUTES_BASED_CLEANUP_RUNNERS: {
                return "No minutes based cleanup runners are registered...";
            }
            case OUTPUT_DISTRIBUTION_HISTORY: {
                return "Output distribution history";
            }
            case MANUALLY_GENERATE_REPORT: {
                return "User {0} ran the report: {1}";
            }
            case AGENT_TIME_ZONE_CHANGED: {
                return "The Time Zone of Agent {0} has changed from {1} to {2}.";
            }
            case SKYBOT_SCHEDULER_SERVER_NOTICE_MISSED_JOB_MANAGING_EXISTS: {
                return "Automate Schedule Server Notice: {0} missed jobs require user action.";
            }
            case SKYBOT_SCHEDULER_SERVER_NOTICE_MISSED_JOB_MANAGING_EXIST_ONE: {
                return "Automate Schedule Server Notice: One missed job requires user action.";
            }
            case SKYBOT_SCHEDULER_SERVER_NOTICE_AGENT_STOPPED_BY_USER: {
                return "Automate Schedule Server Notice: Agent {0} was stopped by {1}.";
            }
            case SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_DAYS: {
                return "Automate Schedule Server Notice: The Date List {0} will expire in {1} days.";
            }
            case SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_TODAY: {
                return "Automate Schedule Server Notice: The Date List {0} will expire today.";
            }
            case SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_TOMORROW: {
                return "Automate Schedule Server Notice: The Date List {0} will expire tomorrow.";
            }
            case JOB_RUN_IMMEDIATELY_BY_USER: {
                return "Job {0} with run number {1} was run immediately on agent {2} at {3} by user {4}.";
            }
            case SKYBOT_SCHEDULER_STANBY_SERVER_NO_LICENSE: {
                return "There is no valid license for connected standby server {0}.";
            }
            case EXPORT_FILE_CREATED: {
                return "Export file {0} was created by user {1}.";
            }
            case SAP_EVENT_NOT_LICENSED: {
                return "SAP Event {0} History Id {1} occurred on SAP Server {2}; however SAP Module is not licensed.";
            }
            case SAP_EVENT_HELD: {
                return "SAP Event {0} History Id {1} occurred on SAP Server {2}; however the SAP Event Monitor is disabled.";
            }
            case SAP_EVENT_OUTSIDE_TIME_SCOPE: {
                return "SAP Event {0} History Id {1} occurred on SAP Server {2}; however it is outside of the time range specified.";
            }
            case SAP_EVENT_OCCURED: {
                return "SAP Event {0} History Id {1} occurred on SAP Server {2}.";
            }
            case UNIVERSAL_CONNECTOR_LICENSE_INVALID: {
                return "The Automate Schedule Enterprise Server is not licensed for Universal Connector features.";
            }
            case UNIVERSAL_CONNECTOR_LICENSE_VALID: {
                return "The Automate Schedule Enterprise Server is licensed for Universal Connector features.";
            }
        }
        return "Text is not defined for: " + rosettaMsg.toString();
    }

    public static String getMsgText(RosettaMsg rosettaMsg, Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return RosettaMsg.getMsgText(rosettaMsg);
        }
        return MessageUtil.formatMsg((String)RosettaMsg.getMsgText(rosettaMsg), (Object[])objectArray);
    }

    public ScheduleLogEntry newLogEntry() {
        return new ScheduleLogEntry(this);
    }

    public ScheduleLogEntry newLogEntry(String string) {
        return new ScheduleLogEntry(this, string);
    }

    public ScheduleLogEntry newLogEntry(String[] stringArray) {
        return new ScheduleLogEntry(this, stringArray);
    }

    public ScheduleLogEntry newLogEntry(String[] stringArray, long l) {
        return new ScheduleLogEntry(this, stringArray, l);
    }

    public ScheduleLogEntry newLogEntry(String[] stringArray, long l, long l2) {
        return new ScheduleLogEntry(this, stringArray, l, l2);
    }

    public ScheduleLogEntry newLogEntry(String[] stringArray, long l, long l2, long l3) {
        return new ScheduleLogEntry(this, stringArray, l, l2, l3);
    }

    public ScheduleLogEntry newLogEntry(String[] stringArray, long l, long l2, long l3, long l4, long l5) {
        return new ScheduleLogEntry(this, stringArray, l, l2, l3, l4, l5);
    }

    public ScheduleLogEntry newLogEntryForSuite(String[] stringArray, long l, long l2) {
        return new ScheduleLogEntry(this, stringArray, 0L, 0L, 0L, l, l2);
    }

    public ScheduleLogEntry newLogEntryForSuite(String[] stringArray, long l) {
        return new ScheduleLogEntry(this, stringArray, 0L, 0L, 0L, l, 0L);
    }

    public SystemMessage newSystemMessage() {
        return new SystemMessage(this);
    }

    public SystemMessage newSystemMessage(String string) {
        return new SystemMessage(this, string);
    }

    public SystemMessage newSystemMessage(String[] stringArray) {
        return new SystemMessage(this, stringArray);
    }
}

