/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.webservice;

import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.dm.webservices.WebServiceRequestParametersDM;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestParameter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class WebServiceRequestParameterDMJdbc
extends AbstractHelpingDatabaseManager
implements WebServiceRequestParametersDM {
    private static final String objDesc = "Web Service Request Parameters";
    private static final String WEB_SERVICE__REQUEST_PARAMETER_TABLE = "web_service_parameters";
    private static final String COMMON_SQL_SELECT = "SELECT name, value, line_number";
    private String webServiceRequestParameterTable;

    public WebServiceRequestParameterDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.WebServiceRequestParameterDM");
        this.webServiceRequestParameterTable = string2 + "." + WEB_SERVICE__REQUEST_PARAMETER_TABLE;
    }

    @Override
    public void loadWebServiceRequestParameters(WebServiceRequest webServiceRequest, Connection connection) throws NoDataException, ResourceUnavailableException, BadDataException {
        String string = "SELECT name, value, line_number FROM " + this.webServiceRequestParameterTable + " WHERE web_service_command_id=? ";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, webServiceRequest.getOID());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                WebServiceRequestParameter webServiceRequestParameter = new WebServiceRequestParameter();
                webServiceRequestParameter.setName(resultSet.getString("name"));
                webServiceRequestParameter.setValue(resultSet.getString("value"));
                webServiceRequestParameter.setLineNumber(resultSet.getInt("line_number"));
                webServiceRequest.addParameter(webServiceRequestParameter);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for Web Service request id {1}.", (Object[])new Object[]{objDesc, Long.toString(webServiceRequest.getOID())});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                WebServiceRequestParameterDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        WebServiceRequestParameterDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }
}

