/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.access.scheduler.ForecastDMJdbc;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectChangeObserver;
import com.helpsystems.enterprise.core.scheduler.CronExpressionsDM;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsDM;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsType;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges;
import com.helpsystems.enterprise.core.scheduler.RuntimeRangesDM;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import com.helpsystems.enterprise.core.scheduler.RuntimesDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_CronExpression;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DateList;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayCount;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayOfPeriod;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_TimedInterval;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ScheduleInfoDMJdbc
extends AbstractDatabaseManager
implements ScheduleInfoDM {
    private static final String JOB_TABLE = "jobs";
    private static final String FORECAST_SCHEDULE_TABLE = "forecast_schedules";
    private static final String AGENT_EVENT_TABLE = "agent_event_monitors";
    private String jobTable;
    private String forecastScheduleTable;
    private String agentEventTable;
    private JobDateObjectsDM jobDateObjectsDM;
    private RuntimesDM runtimesDM;
    private RuntimeRangesDM runtimeRangesDM;
    private CronExpressionsDM cronExpressionsDM;
    private AgentGroupDM agentGroupDM;
    private CalendarObjectCache cache;
    private Calendar cloneOnly_GMTCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));

    public ScheduleInfoDMJdbc(String string, String string2, String string3, RuntimesDM runtimesDM, RuntimeRangesDM runtimeRangesDM, CalendarObjectDM calendarObjectDM, JobDateObjectsDM jobDateObjectsDM, CronExpressionsDM cronExpressionsDM, AgentGroupDM agentGroupDM) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        ValidationHelper.checkForNull((String)"RuntimesDM", (Object)runtimesDM);
        ValidationHelper.checkForNull((String)"RuntimeRangesDM", (Object)runtimeRangesDM);
        ValidationHelper.checkForNull((String)"CalendarObjectDM", (Object)calendarObjectDM);
        ValidationHelper.checkForNull((String)"JobDateObjectsDM", (Object)jobDateObjectsDM);
        ValidationHelper.checkForNull((String)"CronExpressionsDM", (Object)cronExpressionsDM);
        ValidationHelper.checkForNull((String)"AgentGroupDM", (Object)agentGroupDM);
        this.jobTable = string2 + "." + JOB_TABLE;
        this.forecastScheduleTable = string2 + "." + FORECAST_SCHEDULE_TABLE;
        this.agentEventTable = string2 + "." + AGENT_EVENT_TABLE;
        this.setName(string3);
        this.runtimesDM = runtimesDM;
        this.runtimeRangesDM = runtimeRangesDM;
        this.jobDateObjectsDM = jobDateObjectsDM;
        this.cronExpressionsDM = cronExpressionsDM;
        this.agentGroupDM = agentGroupDM;
        this.cache = new CalendarObjectCache(calendarObjectDM);
        this.cloneOnly_GMTCalendar.clear();
    }

    @Override
    public ScheduleInfo get(int n) throws NoDataException, BadDataException, ResourceUnavailableException {
        String string = "SELECT id, target_id, target_type, schedule_type, timezone_type, calendar_id, day_count_base_date, day_count_interval, timed_interval_base_datetime, timed_interval_minutes, timed_interval_display_preference, day_type, non_workday_option, late_start_monitor_selected, update_counter, job_type, timezone FROM " + this.jobTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ScheduleInfo scheduleInfo = this.get(n, TypeOfSchedule.REGULAR, resultSet);
                return scheduleInfo;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Schedule Information for job {0} was not found.", (Object[])new Object[]{n});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving Schedule Information for job {0}.", (Object[])new Object[]{n});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ScheduleInfo getScheduleInfoForForecastSchedule(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        String string = "SELECT t1.id, target_id, target_type, t1.schedule_type, timezone_type, t1.calendar_id, t1.day_type, t1.non_workday_option, FALSE AS late_start_monitor_selected, update_counter, job_type, timezone FROM " + this.forecastScheduleTable + " t1 JOIN " + this.jobTable + " t2 " + "ON parent_id = t2.id WHERE t1.id=? AND (parent_type=? OR parent_type=?)";
        String string2 = "SELECT t1.id, target_id, target_type, schedule_type, timezone_type, calendar_id, day_type, non_workday_option, FALSE AS late_start_monitor_selected, '987654' AS update_counter, '77777' AS job_type, 'xxxxx' AS timezone FROM " + this.forecastScheduleTable + " t1 JOIN " + this.agentEventTable + " t2 " + "ON parent_id = t2.id WHERE t1.id=? AND parent_type=?";
        String string3 = string + " UNION ALL " + string2;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string3);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, ForecastDMJdbc.ForecastScheduleParentType.JOB.persistanceCode());
            preparedStatement.setString(3, ForecastDMJdbc.ForecastScheduleParentType.JOB_SUITE.persistanceCode());
            preparedStatement.setLong(4, l);
            preparedStatement.setString(5, ForecastDMJdbc.ForecastScheduleParentType.AGENT_EVENT.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ScheduleInfo scheduleInfo = this.get(l, TypeOfSchedule.FORECAST, resultSet);
                return scheduleInfo;
            }
            try {
                String string4 = MessageUtil.formatMsg((String)"Schedule Information for forecast schedule {0} was not found.", (Object[])new Object[]{l});
                throw new NoDataException(string4);
            }
            catch (SQLException sQLException) {
                String string5 = MessageUtil.formatMsg((String)"SQL error while retrieving Schedule Information for forecast schedule {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string5, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void setCalendarObjectChangeNotifier(CalendarObjectChangeNotifier calendarObjectChangeNotifier) {
        ValidationHelper.checkForNull((String)"CalendarObject Change Notifier", (Object)calendarObjectChangeNotifier);
        calendarObjectChangeNotifier.addCalendarObjectChangeObserver(this.cache);
        this.cache.calendarObjectChangeNotifier = calendarObjectChangeNotifier;
    }

    private ScheduleInfo get(long l, TypeOfSchedule typeOfSchedule, ResultSet resultSet) throws BadDataException, ResourceUnavailableException {
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        ScheduleInfo scheduleInfo = null;
        try {
            ScheduleJobProxy.ScheduleType scheduleType = this.getScheduleType(l, typeOfSchedule, resultSet);
            if (scheduleType == null || scheduleType == ScheduleJobProxy.ScheduleType.UNSCHEDULED || scheduleType == ScheduleJobProxy.ScheduleType.REACTIVITY_DATE_LIST || scheduleType == ScheduleJobProxy.ScheduleType.REACTIVITY_DAY_OF_PERIOD || scheduleType == ScheduleJobProxy.ScheduleType.REACTIVITY_DAY_OF_WEEK || scheduleType == ScheduleJobProxy.ScheduleType.SAP_RUN_INTERCEPT) {
                return null;
            }
            JobType jobType = this.getJobType(l, typeOfSchedule, resultSet);
            boolean bl = jobType == JobType.SUITE;
            switch (scheduleType) {
                case DAY_COUNT: {
                    int n;
                    scheduleInfo = new ScheduleInfo_DayCount();
                    for (n = 1; n <= 13; ++n) {
                        try {
                            this.getDataFromRS(resultSet, (ScheduleInfo_DayCount)scheduleInfo, l, typeOfSchedule, bl, n);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            exceptionErrorList.addException((Exception)runtimeException);
                        }
                    }
                    break;
                }
                case DAY_OF_PERIOD: {
                    int n;
                    scheduleInfo = new ScheduleInfo_DayOfPeriod();
                    for (n = 1; n <= 12; ++n) {
                        try {
                            this.getDataFromRS(resultSet, (ScheduleInfo_DayOfPeriod)scheduleInfo, l, typeOfSchedule, bl, n);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            exceptionErrorList.addException((Exception)runtimeException);
                        }
                    }
                    break;
                }
                case DAY_OF_WEEK: {
                    int n;
                    scheduleInfo = new ScheduleInfo_DayOfWeek();
                    for (n = 1; n <= 11; ++n) {
                        try {
                            this.getDataFromRS(resultSet, (ScheduleInfo_DayOfWeek)scheduleInfo, l, typeOfSchedule, bl, n);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            exceptionErrorList.addException((Exception)runtimeException);
                        }
                    }
                    break;
                }
                case DATE_LIST: {
                    int n;
                    scheduleInfo = new ScheduleInfo_DateList();
                    for (n = 1; n <= 12; ++n) {
                        try {
                            this.getDataFromRS(resultSet, (ScheduleInfo_DateList)scheduleInfo, l, typeOfSchedule, bl, n);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            exceptionErrorList.addException((Exception)runtimeException);
                        }
                    }
                    break;
                }
                case TIMED_INTERVAL: {
                    int n;
                    scheduleInfo = new ScheduleInfo_TimedInterval();
                    for (n = 1; n <= 14; ++n) {
                        try {
                            this.getDataFromRS(resultSet, (ScheduleInfo_TimedInterval)scheduleInfo, l, typeOfSchedule, bl, n);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            exceptionErrorList.addException((Exception)runtimeException);
                        }
                    }
                    break;
                }
                case CRON_EXPRESSION: {
                    int n;
                    scheduleInfo = new ScheduleInfo_CronExpression();
                    for (n = 1; n <= 9; ++n) {
                        try {
                            this.getDataFromRS(resultSet, (ScheduleInfo_CronExpression)scheduleInfo, l, typeOfSchedule, bl, n);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            exceptionErrorList.addException((Exception)runtimeException);
                        }
                    }
                    break;
                }
                default: {
                    exceptionErrorList.addException((Exception)new IllegalArgumentException("Unrecognized schedule type: " + scheduleType));
                }
            }
            try {
                scheduleInfo.validate();
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            if (exceptionErrorList.getErrorCount() > 0) {
                String string = MessageUtil.formatMsg((String)"One or more errors occurred while retrieving the Schedule Information for {0} {1}.", (Object[])new Object[]{this.associatedObjectText(typeOfSchedule), l});
                throw new BadDataException(string, (Object)scheduleInfo, (ErrorList)exceptionErrorList);
            }
            return scheduleInfo;
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while retrieving Schedule Information for {0} {1}.", (Object[])new Object[]{this.associatedObjectText(typeOfSchedule), l});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    private void getDataFromRS(ResultSet resultSet, ScheduleInfo_CronExpression scheduleInfo_CronExpression, long l, TypeOfSchedule typeOfSchedule, boolean bl, int n) throws SQLException, ResourceUnavailableException {
        switch (n) {
            case 1: {
                scheduleInfo_CronExpression.setTargetID(resultSet.getInt("target_id"));
                break;
            }
            case 2: {
                String string = resultSet.getString("target_type");
                this.constructTargetType(string, bl, scheduleInfo_CronExpression);
                break;
            }
            case 3: {
                if (scheduleInfo_CronExpression.getTargetType() != ScheduleInfo.TargetType.AGENT_GROUP) break;
                Connection connection = resultSet.getStatement().getConnection();
                long l2 = scheduleInfo_CronExpression.getTargetID();
                scheduleInfo_CronExpression.setAgentGroupType(this.retrieveAgentGroupType(l2, connection));
                break;
            }
            case 4: {
                String string = resultSet.getString("timezone_type");
                this.constructTimeZoneType(string, bl, scheduleInfo_CronExpression);
                break;
            }
            case 5: {
                int n2 = resultSet.getInt("calendar_id");
                scheduleInfo_CronExpression.setCalendarObject(this.getCalendarObject(n2));
                break;
            }
            case 6: {
                if (scheduleInfo_CronExpression.getTimeZoneType() != ScheduleInfo.TimeZoneType.JOB) break;
                scheduleInfo_CronExpression.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                break;
            }
            case 7: {
                Connection connection = resultSet.getStatement().getConnection();
                try {
                    String string = this.cronExpressionsDM.getForJob(l, connection);
                    scheduleInfo_CronExpression.setCronExpressionString(string);
                    break;
                }
                catch (Exception exception) {
                    throw new ResourceUnavailableException("Error retrieving cron expression for jobID " + l, (Throwable)exception);
                }
            }
            case 8: {
                Connection connection = resultSet.getStatement().getConnection();
                this.loadOmitDates(scheduleInfo_CronExpression, l, typeOfSchedule, connection);
                break;
            }
            case 9: {
                scheduleInfo_CronExpression.setLateStartJob(resultSet.getBoolean("late_start_monitor_selected"));
                break;
            }
            case 10: {
                scheduleInfo_CronExpression.setUpdateCounter(resultSet.getInt("update_counter"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Pass number argument exceeds maximum.");
            }
        }
    }

    private void getDataFromRS(ResultSet resultSet, ScheduleInfo_DayCount scheduleInfo_DayCount, long l, TypeOfSchedule typeOfSchedule, boolean bl, int n) throws SQLException, ResourceUnavailableException {
        Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
        switch (n) {
            case 1: {
                scheduleInfo_DayCount.setTargetID(resultSet.getInt("target_id"));
                break;
            }
            case 2: {
                String string = resultSet.getString("target_type");
                this.constructTargetType(string, bl, scheduleInfo_DayCount);
                break;
            }
            case 3: {
                if (scheduleInfo_DayCount.getTargetType() != ScheduleInfo.TargetType.AGENT_GROUP) break;
                Connection connection = resultSet.getStatement().getConnection();
                long l2 = scheduleInfo_DayCount.getTargetID();
                scheduleInfo_DayCount.setAgentGroupType(this.retrieveAgentGroupType(l2, connection));
                break;
            }
            case 4: {
                String string = resultSet.getString("timezone_type");
                this.constructTimeZoneType(string, bl, scheduleInfo_DayCount);
                break;
            }
            case 5: {
                int n2 = resultSet.getInt("calendar_id");
                scheduleInfo_DayCount.setCalendarObject(this.getCalendarObject(n2));
                break;
            }
            case 6: {
                if (scheduleInfo_DayCount.getTimeZoneType() != ScheduleInfo.TimeZoneType.JOB) break;
                scheduleInfo_DayCount.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                break;
            }
            case 7: {
                Connection connection = resultSet.getStatement().getConnection();
                this.loadOmitDates(scheduleInfo_DayCount, l, typeOfSchedule, connection);
                break;
            }
            case 8: {
                scheduleInfo_DayCount.setLateStartJob(resultSet.getBoolean("late_start_monitor_selected"));
                break;
            }
            case 9: {
                String string = Convert.trimR((String)resultSet.getString("day_type"));
                scheduleInfo_DayCount.setDayType(this.convertToDayType(string));
                break;
            }
            case 10: {
                Date date = resultSet.getDate("day_count_base_date", calendar);
                if (date != null) {
                    calendar.setTime(date);
                    int n3 = this.yyyymmdd(calendar);
                    scheduleInfo_DayCount.setBaseDate(n3);
                    break;
                }
                scheduleInfo_DayCount.setBaseDate(0);
                break;
            }
            case 11: {
                scheduleInfo_DayCount.setDayCountInterval(resultSet.getInt("day_count_interval"));
                break;
            }
            case 12: {
                Connection connection = resultSet.getStatement().getConnection();
                Runtimes runtimes = this.getRuntimes(l, typeOfSchedule, scheduleInfo_DayCount.getScheduleType(), scheduleInfo_DayCount.getCalendarObject(), connection);
                scheduleInfo_DayCount.setRuntimes(runtimes);
                break;
            }
            case 13: {
                scheduleInfo_DayCount.setUpdateCounter(resultSet.getInt("update_counter"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Pass number argument exceeds maximum.");
            }
        }
    }

    private void getDataFromRS(ResultSet resultSet, ScheduleInfo_DayOfPeriod scheduleInfo_DayOfPeriod, long l, TypeOfSchedule typeOfSchedule, boolean bl, int n) throws SQLException, ResourceUnavailableException {
        switch (n) {
            case 1: {
                scheduleInfo_DayOfPeriod.setTargetID(resultSet.getInt("target_id"));
                break;
            }
            case 2: {
                String string = resultSet.getString("target_type");
                this.constructTargetType(string, bl, scheduleInfo_DayOfPeriod);
                break;
            }
            case 3: {
                if (scheduleInfo_DayOfPeriod.getTargetType() != ScheduleInfo.TargetType.AGENT_GROUP) break;
                Connection connection = resultSet.getStatement().getConnection();
                long l2 = scheduleInfo_DayOfPeriod.getTargetID();
                scheduleInfo_DayOfPeriod.setAgentGroupType(this.retrieveAgentGroupType(l2, connection));
                break;
            }
            case 4: {
                String string = resultSet.getString("timezone_type");
                this.constructTimeZoneType(string, bl, scheduleInfo_DayOfPeriod);
                break;
            }
            case 5: {
                int n2 = resultSet.getInt("calendar_id");
                scheduleInfo_DayOfPeriod.setCalendarObject(this.getCalendarObject(n2));
                break;
            }
            case 6: {
                if (scheduleInfo_DayOfPeriod.getTimeZoneType() != ScheduleInfo.TimeZoneType.JOB) break;
                scheduleInfo_DayOfPeriod.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                break;
            }
            case 7: {
                Connection connection = resultSet.getStatement().getConnection();
                this.loadOmitDates(scheduleInfo_DayOfPeriod, l, typeOfSchedule, connection);
                break;
            }
            case 8: {
                scheduleInfo_DayOfPeriod.setLateStartJob(resultSet.getBoolean("late_start_monitor_selected"));
                break;
            }
            case 9: {
                String string = Convert.trimR((String)resultSet.getString("non_workday_option"));
                scheduleInfo_DayOfPeriod.setNonWorkdayOption(this.convertToNonWorkdayOption(string));
                break;
            }
            case 10: {
                String string = Convert.trimR((String)resultSet.getString("day_type"));
                scheduleInfo_DayOfPeriod.setDayType(this.convertToDayType(string));
                break;
            }
            case 11: {
                Connection connection = resultSet.getStatement().getConnection();
                Runtimes runtimes = this.getRuntimes(l, typeOfSchedule, scheduleInfo_DayOfPeriod.getScheduleType(), scheduleInfo_DayOfPeriod.getCalendarObject(), scheduleInfo_DayOfPeriod.getDayType(), connection);
                scheduleInfo_DayOfPeriod.setRuntimes(runtimes);
                break;
            }
            case 12: {
                scheduleInfo_DayOfPeriod.setUpdateCounter(resultSet.getInt("update_counter"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Pass number argument exceeds maximum.");
            }
        }
    }

    private void getDataFromRS(ResultSet resultSet, ScheduleInfo_DayOfWeek scheduleInfo_DayOfWeek, long l, TypeOfSchedule typeOfSchedule, boolean bl, int n) throws SQLException, ResourceUnavailableException {
        switch (n) {
            case 1: {
                scheduleInfo_DayOfWeek.setTargetID(resultSet.getInt("target_id"));
                break;
            }
            case 2: {
                String string = resultSet.getString("target_type");
                this.constructTargetType(string, bl, scheduleInfo_DayOfWeek);
                break;
            }
            case 3: {
                if (scheduleInfo_DayOfWeek.getTargetType() != ScheduleInfo.TargetType.AGENT_GROUP) break;
                Connection connection = resultSet.getStatement().getConnection();
                long l2 = scheduleInfo_DayOfWeek.getTargetID();
                scheduleInfo_DayOfWeek.setAgentGroupType(this.retrieveAgentGroupType(l2, connection));
                break;
            }
            case 4: {
                String string = resultSet.getString("timezone_type");
                this.constructTimeZoneType(string, bl, scheduleInfo_DayOfWeek);
                break;
            }
            case 5: {
                int n2 = resultSet.getInt("calendar_id");
                scheduleInfo_DayOfWeek.setCalendarObject(this.getCalendarObject(n2));
                break;
            }
            case 6: {
                if (scheduleInfo_DayOfWeek.getTimeZoneType() != ScheduleInfo.TimeZoneType.JOB) break;
                scheduleInfo_DayOfWeek.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                break;
            }
            case 7: {
                Connection connection = resultSet.getStatement().getConnection();
                this.loadOmitDates(scheduleInfo_DayOfWeek, l, typeOfSchedule, connection);
                break;
            }
            case 8: {
                scheduleInfo_DayOfWeek.setLateStartJob(resultSet.getBoolean("late_start_monitor_selected"));
                break;
            }
            case 9: {
                String string = Convert.trimR((String)resultSet.getString("non_workday_option"));
                scheduleInfo_DayOfWeek.setNonWorkdayOption(this.convertToNonWorkdayOption(string));
                break;
            }
            case 10: {
                Connection connection = resultSet.getStatement().getConnection();
                Runtimes runtimes = this.getRuntimes(l, typeOfSchedule, scheduleInfo_DayOfWeek.getScheduleType(), scheduleInfo_DayOfWeek.getCalendarObject(), connection);
                scheduleInfo_DayOfWeek.setRuntimes(runtimes);
                break;
            }
            case 11: {
                scheduleInfo_DayOfWeek.setUpdateCounter(resultSet.getInt("update_counter"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Pass number argument exceeds maximum.");
            }
        }
    }

    private void getDataFromRS(ResultSet resultSet, ScheduleInfo_DateList scheduleInfo_DateList, long l, TypeOfSchedule typeOfSchedule, boolean bl, int n) throws SQLException, ResourceUnavailableException {
        switch (n) {
            case 1: {
                scheduleInfo_DateList.setTargetID(resultSet.getInt("target_id"));
                break;
            }
            case 2: {
                String string = resultSet.getString("target_type");
                this.constructTargetType(string, bl, scheduleInfo_DateList);
                break;
            }
            case 3: {
                if (scheduleInfo_DateList.getTargetType() != ScheduleInfo.TargetType.AGENT_GROUP) break;
                Connection connection = resultSet.getStatement().getConnection();
                long l2 = scheduleInfo_DateList.getTargetID();
                scheduleInfo_DateList.setAgentGroupType(this.retrieveAgentGroupType(l2, connection));
                break;
            }
            case 4: {
                String string = resultSet.getString("timezone_type");
                this.constructTimeZoneType(string, bl, scheduleInfo_DateList);
                break;
            }
            case 5: {
                int n2 = resultSet.getInt("calendar_id");
                scheduleInfo_DateList.setCalendarObject(this.getCalendarObject(n2));
                break;
            }
            case 6: {
                if (scheduleInfo_DateList.getTimeZoneType() != ScheduleInfo.TimeZoneType.JOB) break;
                scheduleInfo_DateList.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                break;
            }
            case 7: {
                Connection connection = resultSet.getStatement().getConnection();
                this.loadOmitDates(scheduleInfo_DateList, l, typeOfSchedule, connection);
                break;
            }
            case 8: {
                scheduleInfo_DateList.setLateStartJob(resultSet.getBoolean("late_start_monitor_selected"));
                break;
            }
            case 9: {
                String string = Convert.trimR((String)resultSet.getString("non_workday_option"));
                scheduleInfo_DateList.setNonWorkdayOption(this.convertToNonWorkdayOption(string));
                break;
            }
            case 10: {
                Connection connection = resultSet.getStatement().getConnection();
                try {
                    DateObject dateObject;
                    switch (typeOfSchedule) {
                        case REGULAR: {
                            dateObject = this.jobDateObjectsDM.get(JobDateObjectsType.RUN_DATE_OBJECTS, l, connection);
                            break;
                        }
                        case FORECAST: {
                            dateObject = this.jobDateObjectsDM.getDateObjectAssociatedWithForecastSchedule(l, JobDateObjectsType.RUN_DATE_OBJECTS, connection);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Type of Schedule {0} is not supported by this method.", (Object[])new Object[]{typeOfSchedule}));
                        }
                    }
                    scheduleInfo_DateList.setRunDates(dateObject);
                    break;
                }
                catch (BadDataException badDataException) {
                    DateObject dateObject = (DateObject)badDataException.getLoadedObject();
                    if (dateObject == null) {
                        dateObject = new DateObject();
                    }
                    scheduleInfo_DateList.setRunDates(dateObject);
                    String string = this.extractMessages(badDataException);
                    throw new RuntimeException(MessageUtil.formatMsg((String)"Corrupted run dates. Details: {0}", (Object[])new Object[]{string}));
                }
            }
            case 11: {
                Connection connection = resultSet.getStatement().getConnection();
                Runtimes runtimes = this.getRuntimes(l, typeOfSchedule, scheduleInfo_DateList.getScheduleType(), scheduleInfo_DateList.getCalendarObject(), connection);
                scheduleInfo_DateList.setRuntimes(runtimes);
                break;
            }
            case 12: {
                scheduleInfo_DateList.setUpdateCounter(resultSet.getInt("update_counter"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Pass number argument exceeds maximum.");
            }
        }
    }

    private void getDataFromRS(ResultSet resultSet, ScheduleInfo_TimedInterval scheduleInfo_TimedInterval, long l, TypeOfSchedule typeOfSchedule, boolean bl, int n) throws SQLException, ResourceUnavailableException {
        Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
        switch (n) {
            case 1: {
                scheduleInfo_TimedInterval.setTargetID(resultSet.getInt("target_id"));
                break;
            }
            case 2: {
                String string = resultSet.getString("target_type");
                this.constructTargetType(string, bl, scheduleInfo_TimedInterval);
                break;
            }
            case 3: {
                if (scheduleInfo_TimedInterval.getTargetType() != ScheduleInfo.TargetType.AGENT_GROUP) break;
                Connection connection = resultSet.getStatement().getConnection();
                long l2 = scheduleInfo_TimedInterval.getTargetID();
                scheduleInfo_TimedInterval.setAgentGroupType(this.retrieveAgentGroupType(l2, connection));
                break;
            }
            case 4: {
                String string = resultSet.getString("timezone_type");
                this.constructTimeZoneType(string, bl, scheduleInfo_TimedInterval);
                break;
            }
            case 5: {
                int n2 = resultSet.getInt("calendar_id");
                scheduleInfo_TimedInterval.setCalendarObject(this.getCalendarObject(n2));
                break;
            }
            case 6: {
                if (scheduleInfo_TimedInterval.getTimeZoneType() != ScheduleInfo.TimeZoneType.JOB) break;
                scheduleInfo_TimedInterval.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                break;
            }
            case 8: {
                Connection connection = resultSet.getStatement().getConnection();
                this.loadOmitDates(scheduleInfo_TimedInterval, l, typeOfSchedule, connection);
                break;
            }
            case 7: {
                scheduleInfo_TimedInterval.setLateStartJob(resultSet.getBoolean("late_start_monitor_selected"));
                break;
            }
            case 9: {
                Timestamp timestamp = resultSet.getTimestamp("timed_interval_base_datetime", calendar);
                if (timestamp != null) {
                    Calendar calendar2 = (Calendar)this.cloneOnly_GMTCalendar.clone();
                    calendar2.setTimeInMillis(timestamp.getTime());
                    scheduleInfo_TimedInterval.setBaseDateTime(calendar2);
                    break;
                }
                scheduleInfo_TimedInterval.setBaseDateTime(null);
                break;
            }
            case 10: {
                scheduleInfo_TimedInterval.setMinutes(resultSet.getInt("timed_interval_minutes"));
                break;
            }
            case 11: {
                String string = Convert.trimR((String)resultSet.getString("timed_interval_display_preference"));
                scheduleInfo_TimedInterval.setDisplayPref(ScheduleInfo_TimedInterval.DisplayPref.persistanceCodeToEnum(string));
                break;
            }
            case 12: {
                String string = Convert.trimR((String)resultSet.getString("day_type"));
                scheduleInfo_TimedInterval.setDayType(this.convertToDayType(string));
                break;
            }
            case 13: {
                Connection connection = resultSet.getStatement().getConnection();
                int n3 = (int)l;
                RuntimeRanges runtimeRanges = this.runtimeRangesDM.get(n3, scheduleInfo_TimedInterval.getScheduleType(), scheduleInfo_TimedInterval.getCalendarObject(), connection);
                scheduleInfo_TimedInterval.setRuntimeRanges(runtimeRanges);
                break;
            }
            case 14: {
                scheduleInfo_TimedInterval.setUpdateCounter(resultSet.getInt("update_counter"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Pass number argument exceeds maximum.");
            }
        }
    }

    private String associatedObjectText(TypeOfSchedule typeOfSchedule) {
        switch (typeOfSchedule) {
            case REGULAR: {
                return "Job";
            }
            case FORECAST: {
                return "Forecast Schedule";
            }
        }
        return "??";
    }

    private void constructTargetType(String string, boolean bl, ScheduleInfo scheduleInfo) {
        if (!bl) {
            scheduleInfo.setTargetType(ScheduleInfo.TargetType.persistanceCodeToEnum(string));
        }
    }

    private void constructTimeZoneType(String string, boolean bl, ScheduleInfo scheduleInfo) {
        ScheduleInfo.TimeZoneType timeZoneType = bl ? (string == null || string.trim().isEmpty() ? ScheduleInfo.TimeZoneType.SERVER : ScheduleInfo.TimeZoneType.persistanceCodeToEnum(string)) : ScheduleInfo.TimeZoneType.persistanceCodeToEnum(string);
        scheduleInfo.setTimeZoneToUse(timeZoneType);
    }

    private CalendarObject.DayType convertToDayType(String string) {
        return CalendarObject.DayType.persistanceCodeToEnum(string);
    }

    private ScheduleInfo.NonWorkdayOption convertToNonWorkdayOption(String string) {
        return ScheduleInfo.NonWorkdayOption.persistanceCodeToEnum(string);
    }

    private String extractMessages(BadDataException badDataException) {
        Exception[] exceptionArray;
        String string = badDataException.getMessage();
        for (Exception exception : exceptionArray = ((ExceptionErrorList)badDataException.getErrorList()).getExceptions()) {
            string = string + " " + exception.getMessage();
        }
        return string;
    }

    private CalendarObject getCalendarObject(long l) throws ResourceUnavailableException {
        try {
            return this.cache.get(l);
        }
        catch (NoDataException noDataException) {
            throw new IllegalStateException("Calendar does not exist.");
        }
        catch (BadDataException badDataException) {
            String string = badDataException.getErrorList().getOptionPaneMessage();
            String string2 = MessageUtil.formatMsg((String)"Error while retrieving Calendar information.\n{0}", (Object[])new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    private JobType getJobType(long l, TypeOfSchedule typeOfSchedule, ResultSet resultSet) throws ResourceUnavailableException {
        try {
            return JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while retrieving the Job Type code for {0} {1}.", (Object[])new Object[]{this.associatedObjectText(typeOfSchedule), l});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    private ScheduleJobProxy.ScheduleType getScheduleType(long l, TypeOfSchedule typeOfSchedule, ResultSet resultSet) throws ResourceUnavailableException {
        String string;
        try {
            string = Convert.trimR((String)resultSet.getString("schedule_type"));
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving Schedule Type code for {0} {1}.", (Object[])new Object[]{this.associatedObjectText(typeOfSchedule), l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        if (string != null && string.length() > 0) {
            return ScheduleJobProxy.ScheduleType.persistanceCodeToEnum(string);
        }
        return null;
    }

    private Runtimes getRuntimes(long l, TypeOfSchedule typeOfSchedule, ScheduleJobProxy.ScheduleType scheduleType, CalendarObject calendarObject, Connection connection) throws ResourceUnavailableException {
        switch (typeOfSchedule) {
            case REGULAR: {
                return this.runtimesDM.get(l, scheduleType, calendarObject, connection);
            }
            case FORECAST: {
                return this.runtimesDM.getForecastScheduleRuntimes(l, scheduleType, calendarObject, connection);
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Type of Schedule {0} is not supported by this method.", (Object[])new Object[]{typeOfSchedule}));
    }

    private Runtimes getRuntimes(long l, TypeOfSchedule typeOfSchedule, ScheduleJobProxy.ScheduleType scheduleType, CalendarObject calendarObject, CalendarObject.DayType dayType, Connection connection) throws ResourceUnavailableException {
        switch (typeOfSchedule) {
            case REGULAR: {
                return this.runtimesDM.get(l, scheduleType, calendarObject, dayType, connection);
            }
            case FORECAST: {
                return this.runtimesDM.getForecastScheduleRuntimes(l, scheduleType, calendarObject, dayType, connection);
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Type of Schedule {0} is not supported by this method.", (Object[])new Object[]{typeOfSchedule}));
    }

    private void loadOmitDates(ScheduleInfo scheduleInfo, long l, TypeOfSchedule typeOfSchedule, Connection connection) throws ResourceUnavailableException {
        DateObject dateObject;
        try {
            switch (typeOfSchedule) {
                case REGULAR: {
                    dateObject = this.jobDateObjectsDM.get(JobDateObjectsType.OMIT_DATE_OBJECTS, l, connection);
                    break;
                }
                case FORECAST: {
                    dateObject = this.jobDateObjectsDM.getDateObjectAssociatedWithForecastSchedule(l, JobDateObjectsType.OMIT_DATE_OBJECTS, connection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Type of Schedule {0} is not supported by this method.", (Object[])new Object[]{typeOfSchedule}));
                }
            }
        }
        catch (BadDataException badDataException) {
            DateObject dateObject2 = (DateObject)badDataException.getLoadedObject();
            scheduleInfo.setOmitDates(dateObject2);
            String string = this.extractMessages(badDataException);
            throw new RuntimeException(MessageUtil.formatMsg((String)"Corrupted omit dates. Details: {0}", (Object[])new Object[]{string}));
        }
        scheduleInfo.setOmitDates(dateObject);
    }

    private AgentGroupType retrieveAgentGroupType(long l, Connection connection) throws ResourceUnavailableException {
        try {
            AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(l, connection);
            return agentGroupProxy.getAgentGroupType();
        }
        catch (DataException dataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve the agent group type because no agent group was found whose id is {0}.", (Object[])new Object[]{l}));
        }
    }

    private int yyyymmdd(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        return n * 10000 + n2 * 100 + n3;
    }

    private class CalendarObjectCache
    implements CalendarObjectChangeObserver {
        private Map<Long, CalendarObject> cacheMap;
        private CalendarObjectDM calendarObjectDM;
        private CalendarObjectChangeNotifier calendarObjectChangeNotifier;

        private CalendarObjectCache(CalendarObjectDM calendarObjectDM) {
            ValidationHelper.checkForNull((String)"CalendarObjectDM", (Object)calendarObjectDM);
            this.calendarObjectDM = calendarObjectDM;
            this.cacheMap = new HashMap<Long, CalendarObject>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void calendarObjectChanged(long l) {
            Map<Long, CalendarObject> map = this.cacheMap;
            synchronized (map) {
                this.cacheMap.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CalendarObject get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
            if (this.calendarObjectChangeNotifier == null) {
                return this.calendarObjectDM.get(l);
            }
            Map<Long, CalendarObject> map = this.cacheMap;
            synchronized (map) {
                CalendarObject calendarObject = this.cacheMap.get(l);
                if (calendarObject == null) {
                    calendarObject = this.calendarObjectDM.get(l);
                    this.cacheMap.put(l, calendarObject);
                }
                return calendarObject;
            }
        }
    }

    private static enum TypeOfSchedule {
        REGULAR,
        FORECAST;

    }
}

