/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges;
import com.helpsystems.enterprise.core.scheduler.RuntimeRangesDM;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_Basic;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.Runtimes_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.TimeRange;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RuntimeRangesDMJdbc
extends AbstractDatabaseManager
implements RuntimeRangesDM {
    private static final Logger logger = Logger.getLogger(RuntimeRangesDMJdbc.class);
    private static final String BASIC_TABLE = "basic_runtime_ranges";
    private static final String DAY_OF_WEEK_TABLE = "day_of_week_runtime_ranges";
    private String basicTable;
    private String dayOfWeekTable;

    public RuntimeRangesDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.basicTable = string2 + "." + BASIC_TABLE;
        this.dayOfWeekTable = string2 + "." + DAY_OF_WEEK_TABLE;
        this.setName(string3);
    }

    @Override
    public RuntimeRanges get(int n, ScheduleJobProxy.ScheduleType scheduleType, CalendarObject calendarObject, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Schedule Type", (Object)scheduleType);
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        switch (scheduleType) {
            case TIMED_INTERVAL: {
                if (this.hasBasicRuntimeRanges(n, connection)) {
                    return this.basicRuntimeRanges(n, connection);
                }
                RuntimeRanges runtimeRanges = this.dayOfWeekRuntimeRanges(n, calendarObject, connection);
                if (runtimeRanges.isEmpty()) {
                    LocalHHMM localHHMM = this.toLocalHHMM(0);
                    LocalHHMM localHHMM2 = this.toLocalHHMM(2359);
                    TimeRange timeRange = new TimeRange(localHHMM, localHHMM2);
                    runtimeRanges = new RuntimeRanges_Basic(timeRange);
                }
                return runtimeRanges;
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"It is invalid to request to retrieve runtime ranges for Schedule Type {0}. ", (Object[])new Object[]{scheduleType}));
    }

    private RuntimeRanges basicRuntimeRanges(int n, Connection connection) throws ResourceUnavailableException {
        boolean bl;
        PreparedStatement preparedStatement;
        RuntimeRanges_Basic runtimeRanges_Basic = new RuntimeRanges_Basic();
        String string = "SELECT runtime_range_begin, runtime_range_end FROM " + this.basicTable + " WHERE job_id=?";
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string);
            bl = false;
        }
        try {
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                LocalHHMM localHHMM = this.toLocalHHMM(resultSet.getInt("runtime_range_begin"));
                LocalHHMM localHHMM2 = this.toLocalHHMM(resultSet.getInt("runtime_range_end"));
                runtimeRanges_Basic.addRuntimeRange(new TimeRange(localHHMM, localHHMM2));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL Error while retrieving the runtime ranges for job {0}.", (Object[])new Object[]{n});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            }
        }
        return runtimeRanges_Basic;
    }

    private RuntimeRanges dayOfWeekRuntimeRanges(int n, CalendarObject calendarObject, Connection connection) throws ResourceUnavailableException {
        boolean bl;
        PreparedStatement preparedStatement;
        RuntimeRanges_DayOfWeek runtimeRanges_DayOfWeek = new RuntimeRanges_DayOfWeek(calendarObject);
        String string = "SELECT runtime_range_begin, runtime_range_end, runcode_mon, runcode_tue, runcode_wed, runcode_thu, runcode_fri, runcode_sat, runcode_sun FROM " + this.dayOfWeekTable + " WHERE job_id=?";
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string);
            bl = false;
        }
        try {
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                LocalHHMM localHHMM = this.toLocalHHMM(resultSet.getInt("runtime_range_begin"));
                LocalHHMM localHHMM2 = this.toLocalHHMM(resultSet.getInt("runtime_range_end"));
                TimeRange timeRange = new TimeRange(localHHMM, localHHMM2);
                Runtimes_DayOfWeek.RunCode runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_mon"));
                runtimeRanges_DayOfWeek.addRuntimeRange(CalendarObject.DayOfWeek.MON, runCode, timeRange);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_tue"));
                runtimeRanges_DayOfWeek.addRuntimeRange(CalendarObject.DayOfWeek.TUE, runCode, timeRange);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_wed"));
                runtimeRanges_DayOfWeek.addRuntimeRange(CalendarObject.DayOfWeek.WED, runCode, timeRange);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_thu"));
                runtimeRanges_DayOfWeek.addRuntimeRange(CalendarObject.DayOfWeek.THU, runCode, timeRange);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_fri"));
                runtimeRanges_DayOfWeek.addRuntimeRange(CalendarObject.DayOfWeek.FRI, runCode, timeRange);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_sat"));
                runtimeRanges_DayOfWeek.addRuntimeRange(CalendarObject.DayOfWeek.SAT, runCode, timeRange);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_sun"));
                runtimeRanges_DayOfWeek.addRuntimeRange(CalendarObject.DayOfWeek.SUN, runCode, timeRange);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL Error while retrieving the runtime ranges for job {0}.", (Object[])new Object[]{n});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            }
        }
        return runtimeRanges_DayOfWeek;
    }

    private boolean hasBasicRuntimeRanges(int n, Connection connection) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.basicTable + " WHERE job_id=?";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            return this.doCount(string, objectArray, connection) > 0;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = MessageUtil.formatMsg((String)"Error while checking if Basic Runtime Ranges exist for job {0}.", (Object[])new Object[]{n});
            throw new ResourceUnavailableException(string2, (Throwable)resourceUnavailableException);
        }
    }

    private LocalHHMM toLocalHHMM(int n) {
        int n2 = n / 100;
        int n3 = n - n2 * 100;
        return new LocalHHMM(n2, n3);
    }
}

