/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPConnectionType;
import com.helpsystems.enterprise.core.busobj.sap.SAPSecuritySetting;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPXBPVersion;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemDefinitionsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class SAPSystemDefinitionsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPSystemDefinitionsDM {
    private static Logger logger = Logger.getLogger(SAPSystemDefinitionsDMJdbc.class);
    private static final String objDesc = "SAP System Definition";
    private static final String SAP_SYSTEM_DEFINITIONS_TABLE = "sap_system_definitions";
    private static final String COMMON_SQL_SELECT = "SELECT id, name, description, sap_system_id, sap_system_number, sap_application_server,sap_use_snc, sap_snc_name, registered_with_sld_utc, poll_intercepted_jobs, poll_interval_seconds, sap_router_string, sap_security_setting, default_environment_id, xmi_audit_level, poll_jobs, poll_job_interval_seconds, xbp_version, sld_local_system_name, sld_computer_name, sld_host, sld_port, sld_user, sld_encrypted_password, sld_password_salt, sld_register, time_zone, connection_type, message_server, group_or_server";
    private static final int FULL_NUMBER_OF_PASSES = 30;
    private String sapSystemDefinitionsTable;

    public SAPSystemDefinitionsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPSystemDefinitionsDM");
        this.sapSystemDefinitionsTable = string2 + "." + SAP_SYSTEM_DEFINITIONS_TABLE;
    }

    @Override
    public ArrayList<SAPSystemDefinition> getAll() throws NoDataException, BadDataException, ResourceUnavailableException {
        ArrayList<SAPSystemDefinition> arrayList = new ArrayList<SAPSystemDefinition>();
        String string = "SELECT id, name, description, sap_system_id, sap_system_number, sap_application_server,sap_use_snc, sap_snc_name, registered_with_sld_utc, poll_intercepted_jobs, poll_interval_seconds, sap_router_string, sap_security_setting, default_environment_id, xmi_audit_level, poll_jobs, poll_job_interval_seconds, xbp_version, sld_local_system_name, sld_computer_name, sld_host, sld_port, sld_user, sld_encrypted_password, sld_password_salt, sld_register, time_zone, connection_type, message_server, group_or_server FROM " + this.sapSystemDefinitionsTable;
        SAPSystemDefinitionGenerator sAPSystemDefinitionGenerator = new SAPSystemDefinitionGenerator(19);
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPSystemDefinition sAPSystemDefinition = (SAPSystemDefinition)((Object)sAPSystemDefinitionGenerator.generateObject(resultSet));
                arrayList.add(sAPSystemDefinition);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s.", (Object[])new Object[]{objDesc});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    @Override
    public ArrayList<SAPSystemDefinition> getAllForPollingJobs() throws NoDataException, BadDataException, ResourceUnavailableException {
        ArrayList<SAPSystemDefinition> arrayList = new ArrayList<SAPSystemDefinition>();
        String string = "SELECT id, name, description, sap_system_id, sap_system_number, sap_application_server,sap_use_snc, sap_snc_name, registered_with_sld_utc, poll_intercepted_jobs, poll_interval_seconds, sap_router_string, sap_security_setting, default_environment_id, xmi_audit_level, poll_jobs, poll_job_interval_seconds, xbp_version, sld_local_system_name, sld_computer_name, sld_host, sld_port, sld_user, sld_encrypted_password, sld_password_salt, sld_register, time_zone, connection_type, message_server, group_or_server FROM " + this.sapSystemDefinitionsTable + " WHERE poll_jobs = true";
        SAPSystemDefinitionGenerator sAPSystemDefinitionGenerator = new SAPSystemDefinitionGenerator(19);
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPSystemDefinition sAPSystemDefinition = (SAPSystemDefinition)((Object)sAPSystemDefinitionGenerator.generateObject(resultSet));
                arrayList.add(sAPSystemDefinition);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s.", (Object[])new Object[]{objDesc});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ArrayList<SAPSystemDefinition> getAllForSLDRegistration() {
        ArrayList<SAPSystemDefinition> arrayList;
        block8: {
            arrayList = new ArrayList<SAPSystemDefinition>();
            AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                wrappedConnection = super.getConnectionOrFail();
                String string = "SELECT id, name, description, sap_system_id, sap_system_number, sap_application_server,sap_use_snc, sap_snc_name, registered_with_sld_utc, poll_intercepted_jobs, poll_interval_seconds, sap_router_string, sap_security_setting, default_environment_id, xmi_audit_level, poll_jobs, poll_job_interval_seconds, xbp_version, sld_local_system_name, sld_computer_name, sld_host, sld_port, sld_user, sld_encrypted_password, sld_password_salt, sld_register, time_zone, connection_type, message_server, group_or_server FROM " + this.sapSystemDefinitionsTable + " WHERE sld_register = TRUE";
                SAPSystemDefinitionGenerator sAPSystemDefinitionGenerator = new SAPSystemDefinitionGenerator(30);
                preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    SAPSystemDefinition sAPSystemDefinition = (SAPSystemDefinition)((Object)sAPSystemDefinitionGenerator.generateObject(resultSet));
                    arrayList.add(sAPSystemDefinition);
                }
                SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s.", (Object[])new Object[]{objDesc});
                logger.error((Object)string, (Throwable)sQLException);
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error while retrieving the {0}s.", (Object[])new Object[]{objDesc}), (Throwable)exception);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    @Override
    public SAPSystemDefinition get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            SAPSystemDefinition sAPSystemDefinition;
            String string = "SELECT id, name, description, sap_system_id, sap_system_number, sap_application_server,sap_use_snc, sap_snc_name, registered_with_sld_utc, poll_intercepted_jobs, poll_interval_seconds, sap_router_string, sap_security_setting, default_environment_id, xmi_audit_level, poll_jobs, poll_job_interval_seconds, xbp_version, sld_local_system_name, sld_computer_name, sld_host, sld_port, sld_user, sld_encrypted_password, sld_password_salt, sld_register, time_zone, connection_type, message_server, group_or_server FROM " + this.sapSystemDefinitionsTable + " WHERE id=?";
            SAPSystemDefinitionGenerator sAPSystemDefinitionGenerator = new SAPSystemDefinitionGenerator(30);
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            SAPSystemDefinition sAPSystemDefinition2 = sAPSystemDefinition = (SAPSystemDefinition)((Object)sAPSystemDefinitionGenerator.generateObject(resultSet));
            SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return sAPSystemDefinition2;
        }
        try {
            try {
                throw new NoDataException("SAP System Definition not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public void updateToSLDRegistered(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        String string = "UPDATE " + this.sapSystemDefinitionsTable + " SET registered_with_sld_utc=?, updated_at=? WHERE id=?";
        Timestamp timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, timestamp.getTime());
            preparedStatement.setTimestamp(2, timestamp);
            preparedStatement.setLong(3, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = "SQL Error updating SAP System Definition ID " + l;
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            SAPSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
    }

    private class SAPSystemDefinitionGenerator
    extends AbstractBusObjGenerator {
        public SAPSystemDefinitionGenerator(int n) {
            super(n, SAPSystemDefinitionsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPSystemDefinition();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPSystemDefinition sAPSystemDefinition = (SAPSystemDefinition)((Object)object);
            switch (n) {
                case 1: {
                    sAPSystemDefinition.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    sAPSystemDefinition.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    sAPSystemDefinition.setDescription(string);
                    break;
                }
                case 4: {
                    String string = resultSet.getString("sap_system_id");
                    sAPSystemDefinition.setR3name(string);
                    break;
                }
                case 5: {
                    sAPSystemDefinition.setSystemNumber(String.valueOf(resultSet.getInt("sap_system_number")));
                    break;
                }
                case 6: {
                    sAPSystemDefinition.setAshost(resultSet.getString("sap_application_server"));
                    break;
                }
                case 7: {
                    sAPSystemDefinition.setUseSNC(resultSet.getBoolean("sap_use_snc"));
                    break;
                }
                case 8: {
                    String string = resultSet.getString("sap_snc_name");
                    if (string == null) {
                        string = "";
                    }
                    sAPSystemDefinition.setSncName(string);
                    break;
                }
                case 9: {
                    sAPSystemDefinition.setRegisteredWithSLDMS(resultSet.getLong("registered_with_sld_utc"));
                    break;
                }
                case 10: {
                    sAPSystemDefinition.setPollInterceptedJobs(resultSet.getBoolean("poll_intercepted_jobs"));
                    break;
                }
                case 11: {
                    sAPSystemDefinition.setPollInterceptIntervalSeconds(resultSet.getInt("poll_interval_seconds"));
                    break;
                }
                case 12: {
                    String string = resultSet.getString("sap_router_string");
                    if (string == null) {
                        string = "";
                    }
                    sAPSystemDefinition.setRouter(string);
                    break;
                }
                case 13: {
                    int n2 = resultSet.getInt("sap_security_setting");
                    if (n2 <= 0) {
                        n2 = 4;
                    }
                    sAPSystemDefinition.setSecuritySetting(SAPSecuritySetting.persistanceCodeToEnum(n2));
                    break;
                }
                case 14: {
                    sAPSystemDefinition.setDefaultEnvironmentID(resultSet.getLong("default_environment_id"));
                    break;
                }
                case 15: {
                    SAPXMIAuditLevel sAPXMIAuditLevel = SAPXMIAuditLevel.persistanceCodeToEnum(resultSet.getInt("xmi_audit_level"));
                    sAPSystemDefinition.setXMIAuditLevel(sAPXMIAuditLevel);
                    break;
                }
                case 16: {
                    sAPSystemDefinition.setPollJobs(resultSet.getBoolean("poll_jobs"));
                    break;
                }
                case 17: {
                    sAPSystemDefinition.setPollJobIntervalSeconds(resultSet.getInt("poll_job_interval_seconds"));
                    break;
                }
                case 18: {
                    SAPXBPVersion sAPXBPVersion = SAPXBPVersion.persistanceCodeToEnum(resultSet.getString("xbp_version"));
                    sAPSystemDefinition.setXbpVersion(sAPXBPVersion);
                    break;
                }
                case 19: {
                    sAPSystemDefinition.setTimeZoneString(resultSet.getString("time_zone"));
                    break;
                }
                case 20: {
                    sAPSystemDefinition.setSLDLocalSystemName(resultSet.getString("sld_local_system_name"));
                    break;
                }
                case 21: {
                    sAPSystemDefinition.setSLDComputerName(resultSet.getString("sld_computer_name"));
                    break;
                }
                case 22: {
                    sAPSystemDefinition.setSLDHost(resultSet.getString("sld_host"));
                    break;
                }
                case 23: {
                    sAPSystemDefinition.setSLDPort(resultSet.getInt("sld_port"));
                    break;
                }
                case 24: {
                    sAPSystemDefinition.setSLDUser(resultSet.getString("sld_user"));
                    break;
                }
                case 25: {
                    sAPSystemDefinition.setSLDEncryptedPassword(resultSet.getString("sld_encrypted_password"));
                    break;
                }
                case 26: {
                    String string = resultSet.getString("sld_password_salt");
                    if (string == null) {
                        string = "";
                    }
                    sAPSystemDefinition.setSLDPasswordSalt(string);
                    break;
                }
                case 27: {
                    sAPSystemDefinition.setSLDEnabled(resultSet.getBoolean("sld_register"));
                    break;
                }
                case 28: {
                    int n3 = SAPConnectionType.persistanceCodeToEnum(resultSet.getInt("connection_type")).persistanceCode();
                    sAPSystemDefinition.setConnectionType(n3);
                    break;
                }
                case 29: {
                    sAPSystemDefinition.setMessageServer(resultSet.getString("message_server"));
                    break;
                }
                case 30: {
                    sAPSystemDefinition.setGroupOrServer(resultSet.getString("group_or_server"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

