/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSimple;
import com.helpsystems.enterprise.core.dm.sap.SAPJobsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.apache.log4j.Logger;

public class SAPJobsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPJobsDM {
    private static Logger logger = Logger.getLogger(SAPJobsDMJdbc.class);
    private static final String sap_job = "SAP Job";
    private static final String SAP_JOBS_TABLE = "sap_jobs";
    private static final String COMMON_SELECT = "SELECT id, sap_system_definition_id, name, sap_job_count, sap_job_status, sap_planned_start_utc, sap_event_identifier, sap_periodic, sap_job_start_utc, sap_job_end_utc, sap_initiator";
    private String sapJobsTable;

    public SAPJobsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPJobsDM");
        this.sapJobsTable = string2 + "." + SAP_JOBS_TABLE;
    }

    @Override
    public SAPJobSimple getSAPJobForCopy(long l) throws NoDataException, ResourceUnavailableException, BadDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            SAPJobSimple sAPJobSimple;
            String string = "SELECT id, sap_system_definition_id, name, sap_job_count, sap_job_status, sap_planned_start_utc, sap_event_identifier, sap_periodic, sap_job_start_utc, sap_job_end_utc, sap_initiator FROM " + this.sapJobsTable + " WHERE id=?";
            SAPJobGenerator sAPJobGenerator = new SAPJobGenerator(11);
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            SAPJobSimple sAPJobSimple2 = sAPJobSimple = (SAPJobSimple)sAPJobGenerator.generateObject(resultSet);
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return sAPJobSimple2;
        }
        try {
            try {
                throw new NoDataException("SAP Job not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command_id {1}.", (Object[])new Object[]{sap_job, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public void save(SAPJobSimple sAPJobSimple) throws ResourceUnavailableException, NotSavedException {
        String string = "INSERT INTO " + this.sapJobsTable + " (" + "sap_system_definition_id, name, sap_job_count, sap_job_status, " + "sap_event_identifier, sap_periodic, sap_initiator, " + "sap_planned_start_utc, sap_job_start_utc, " + "sap_job_end_utc) VALUES(?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            preparedStatement.setLong(1, sAPJobSimple.getSapSystemDefinitionID());
            preparedStatement.setString(2, sAPJobSimple.getJobName());
            preparedStatement.setString(3, sAPJobSimple.getJobCount());
            preparedStatement.setString(4, sAPJobSimple.getJobStatusAsString());
            preparedStatement.setString(5, sAPJobSimple.getEventIdentifier());
            preparedStatement.setBoolean(6, sAPJobSimple.getPeriodic());
            preparedStatement.setString(7, sAPJobSimple.getJobInitiator());
            this.setLong(8, preparedStatement, sAPJobSimple.getPlannedStartMS());
            this.setLong(9, preparedStatement, sAPJobSimple.getJobStartTimeMS());
            this.setLong(10, preparedStatement, sAPJobSimple.getJobEndTimeMS());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                String string2 = MessageUtil.formatMsg((String)"Unable to add the SAP job {0}.", (Object[])new Object[]{sAPJobSimple.getNameAndCount()});
                throw new NotSavedException(string2);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error saving SAP Job. ", (Throwable)sQLException);
        }
        finally {
            super.closeConnection((Statement)preparedStatement);
        }
    }

    @Override
    public ArrayList<SAPJobSimple> save(Collection<SAPJobSimple> collection) throws ResourceUnavailableException, NotSavedException {
        ArrayList<SAPJobSimple> arrayList = new ArrayList<SAPJobSimple>();
        logger.debug((Object)("About to save " + collection.size() + " SAP job(s) to the Automate Schedule database."));
        String string = "INSERT INTO " + this.sapJobsTable + " (" + "sap_system_definition_id, name, sap_job_count, sap_job_status, " + "sap_event_identifier, sap_periodic, sap_initiator, " + "sap_planned_start_utc, sap_job_start_utc, " + "sap_job_end_utc) VALUES(?,?,?,?,?,?,?,?,?,?)";
        SAPJobSimple sAPJobSimple2 = null;
        Object var5_5 = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            for (SAPJobSimple sAPJobSimple2 : collection) {
                preparedStatement.setLong(1, sAPJobSimple2.getSapSystemDefinitionID());
                preparedStatement.setString(2, sAPJobSimple2.getJobName());
                preparedStatement.setString(3, sAPJobSimple2.getJobCount());
                preparedStatement.setString(4, sAPJobSimple2.getJobStatusAsString());
                preparedStatement.setString(5, sAPJobSimple2.getEventIdentifier());
                preparedStatement.setBoolean(6, sAPJobSimple2.getPeriodic());
                preparedStatement.setString(7, sAPJobSimple2.getJobInitiator());
                this.setLong(8, preparedStatement, sAPJobSimple2.getPlannedStartMS());
                this.setLong(9, preparedStatement, sAPJobSimple2.getJobStartTimeMS());
                this.setLong(10, preparedStatement, sAPJobSimple2.getJobEndTimeMS());
                try {
                    preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage().contains("duplicate key value")) {
                        logger.debug((Object)("The SAP Job record for " + sAPJobSimple2.getNameAndCount() + " on SAP System Definition ID " + sAPJobSimple2.getSapSystemDefinitionID() + " already exists in the Automate Schedule database."));
                        logger.trace((Object)sQLException.getMessage());
                        arrayList.add(sAPJobSimple2);
                        continue;
                    }
                    logger.error((Object)("Error saving SAP Job " + sAPJobSimple2.getNameAndCount()), (Throwable)sQLException);
                }
            }
        }
        catch (SQLException sQLException) {
            String string2 = "Error saving SAP Job";
            if (sAPJobSimple2 != null) {
                string2 = string2 + " " + sAPJobSimple2.getNameAndCount();
            }
            throw new ResourceUnavailableException("." + string2, (Throwable)sQLException);
        }
        finally {
            super.closeConnection((Statement)preparedStatement);
        }
        return arrayList;
    }

    @Override
    public boolean delete(SAPJobProxy sAPJobProxy) throws ResourceUnavailableException, DataException {
        boolean bl = false;
        String string = "DELETE FROM " + this.sapJobsTable + " WHERE sap_system_definition_id=? AND name=? AND sap_job_count=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, sAPJobProxy.getSapSystemDefinitionID());
            preparedStatement.setString(2, sAPJobProxy.getJobName());
            preparedStatement.setString(3, sAPJobProxy.getJobCount());
            int n = preparedStatement.executeUpdate();
            logger.trace((Object)("Deleted " + n + " record(s) from the Automate Schedule database."));
            if (n == 1) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error deleting " + sAPJobProxy.getNameAndCount(), (Throwable)sQLException);
        }
        finally {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Collection<SAPJobProxy> collection) throws ResourceUnavailableException, DataException {
        int n = 0;
        String string = "DELETE FROM " + this.sapJobsTable + " WHERE sap_system_definition_id=? AND name=? AND sap_job_count=?";
        Iterator<SAPJobProxy> iterator = collection.iterator();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            while (iterator.hasNext()) {
                SAPJobProxy sAPJobProxy = iterator.next();
                try {
                    preparedStatement.setLong(1, sAPJobProxy.getSapSystemDefinitionID());
                    preparedStatement.setString(2, sAPJobProxy.getJobName());
                    preparedStatement.setString(3, sAPJobProxy.getJobCount());
                    int n2 = preparedStatement.executeUpdate();
                    n += n2;
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("SQL Error removing terminal SAP Job " + sAPJobProxy.getNameAndCount()), (Throwable)sQLException);
                }
            }
        }
        finally {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Stack<Long> stack) throws ResourceUnavailableException, DataException {
        int n = 0;
        String string = "DELETE FROM " + this.sapJobsTable + " WHERE id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            while (!stack.isEmpty()) {
                Long l = stack.pop();
                try {
                    preparedStatement.setLong(1, l);
                    int n2 = preparedStatement.executeUpdate();
                    n += n2;
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("SQL Error removing terminal SAP Job with ID " + l), (Throwable)sQLException);
                }
            }
        }
        finally {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAll(long l) throws ResourceUnavailableException, DataException {
        String string = "DELETE FROM " + this.sapJobsTable + " WHERE sap_system_definition_id=?";
        int n = 0;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            logger.error((Object)("SQL Error deleting all SAP jobs for SAP System Definition ID " + l), (Throwable)sQLException);
        }
        finally {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        return n;
    }

    @Override
    public void update(SAPJobProxy sAPJobProxy) throws Exception {
        ArrayList<SAPJobProxy> arrayList = new ArrayList<SAPJobProxy>();
        arrayList.add(sAPJobProxy);
        int n = this.update(arrayList);
        logger.debug((Object)(n + " SAP Jobs were updated in Automate Schedule."));
        if (n == 0) {
            throw new Exception("Automate Schedule record for " + sAPJobProxy.getNameAndCount() + " was not updated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(Collection<SAPJobProxy> collection) throws ResourceUnavailableException, DataException {
        int n = 0;
        String string = "UPDATE " + this.sapJobsTable + " SET sap_job_status=?, sap_periodic=?, " + "sap_planned_start_utc=?, " + "sap_job_start_utc=?, sap_job_end_utc=? " + "WHERE sap_system_definition_id=? " + "AND name=? AND sap_job_count=?";
        Iterator<SAPJobProxy> iterator = collection.iterator();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            while (iterator.hasNext()) {
                SAPJobProxy sAPJobProxy = iterator.next();
                try {
                    preparedStatement.setString(1, sAPJobProxy.getJobStatusAsString());
                    preparedStatement.setBoolean(2, sAPJobProxy.getPeriodic());
                    this.setLong(3, preparedStatement, sAPJobProxy.getPlannedStartMS());
                    this.setLong(4, preparedStatement, sAPJobProxy.getJobStartTimeMS());
                    this.setLong(5, preparedStatement, sAPJobProxy.getJobEndTimeMS());
                    preparedStatement.setLong(6, sAPJobProxy.getSapSystemDefinitionID());
                    preparedStatement.setString(7, sAPJobProxy.getJobName());
                    preparedStatement.setString(8, sAPJobProxy.getJobCount());
                    int n2 = preparedStatement.executeUpdate();
                    n += n2;
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("SQL Error updating SAP Job " + sAPJobProxy.getNameAndCount()), (Throwable)sQLException);
                }
            }
        }
        finally {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateToConfirmed(SAPJobSimple sAPJobSimple) throws ResourceUnavailableException, DataException {
        int n = 0;
        String string = "UPDATE " + this.sapJobsTable + " SET confirmed=true " + "WHERE sap_system_definition_id=? " + "AND name=? AND sap_job_count=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            try {
                preparedStatement.setLong(1, sAPJobSimple.getSapSystemDefinitionID());
                preparedStatement.setString(2, sAPJobSimple.getJobName());
                preparedStatement.setString(3, sAPJobSimple.getJobCount());
                int n2 = preparedStatement.executeUpdate();
                n += n2;
            }
            catch (SQLException sQLException) {
                logger.error((Object)("SQL Error updating SAP Job " + sAPJobSimple.getNameAndCount()), (Throwable)sQLException);
            }
        }
        finally {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateToConfirmed(Collection<SAPJobSimple> collection) throws ResourceUnavailableException, DataException {
        int n = 0;
        String string = "UPDATE " + this.sapJobsTable + " SET confirmed=true " + "WHERE sap_system_definition_id=? " + "AND name=? AND sap_job_count=?";
        Iterator<SAPJobSimple> iterator = collection.iterator();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            while (iterator.hasNext()) {
                SAPJobProxy sAPJobProxy = iterator.next();
                try {
                    preparedStatement.setLong(1, sAPJobProxy.getSapSystemDefinitionID());
                    preparedStatement.setString(2, sAPJobProxy.getJobName());
                    preparedStatement.setString(3, sAPJobProxy.getJobCount());
                    int n2 = preparedStatement.executeUpdate();
                    n += n2;
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("SQL Error updating SAP Job " + sAPJobProxy.getNameAndCount()), (Throwable)sQLException);
                }
            }
        }
        finally {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateToUnconfirmed(Collection<SAPJobSimple> collection) {
        int n = 0;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            String string = "UPDATE " + this.sapJobsTable + " SET confirmed=false " + "WHERE sap_system_definition_id=? " + "AND name=? AND sap_job_count=?";
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            for (SAPJobProxy sAPJobProxy : collection) {
                try {
                    preparedStatement.setLong(1, sAPJobProxy.getSapSystemDefinitionID());
                    preparedStatement.setString(2, sAPJobProxy.getJobName());
                    preparedStatement.setString(3, sAPJobProxy.getJobCount());
                    n += preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("SQL Error updating SAP Job " + sAPJobProxy.getNameAndCount() + " to unconfirmed."), (Throwable)sQLException);
                }
            }
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error updating SAP jobs to unconfirmed.", (Throwable)resourceUnavailableException);
        }
        finally {
            SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
        }
        return n;
    }

    private void setLong(int n, PreparedStatement preparedStatement, long l) throws SQLException {
        if (l != 0L) {
            preparedStatement.setLong(n, l);
        } else {
            preparedStatement.setNull(n, -5);
        }
    }

    @Override
    public HashMap<String, SAPJobProxy> getNonTerminalForSystemDefinitionID(long l) throws ResourceUnavailableException, DataException {
        HashMap<String, SAPJobProxy> hashMap = new HashMap<String, SAPJobProxy>();
        String string = "SELECT id, sap_system_definition_id, name, sap_job_count, sap_job_status, sap_planned_start_utc, sap_event_identifier, sap_periodic, sap_job_start_utc, sap_job_end_utc, sap_initiator FROM " + this.sapJobsTable + " WHERE sap_system_definition_id=? AND" + " sap_job_status IN ('R','I','Y','P','S')";
        SAPJobGenerator sAPJobGenerator = new SAPJobGenerator(11);
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPJobProxy sAPJobProxy = (SAPJobProxy)sAPJobGenerator.generateObject(resultSet);
                hashMap.put(sAPJobProxy.getNameAndCount(), sAPJobProxy);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s for SAP System Definition ID {1}.", (Object[])new Object[]{sap_job, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return hashMap;
    }

    @Override
    public HashMap<String, SAPJobProxy> getTerminalForSystemDefinitionID(long l) throws ResourceUnavailableException, DataException {
        HashMap<String, SAPJobProxy> hashMap = new HashMap<String, SAPJobProxy>();
        String string = "SELECT id, sap_system_definition_id, name, sap_job_count, sap_job_status FROM " + this.sapJobsTable + " WHERE sap_system_definition_id=? AND sap_job_status IN ('A','F')";
        SAPJobGenerator sAPJobGenerator = new SAPJobGenerator(5);
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPJobProxy sAPJobProxy = (SAPJobProxy)sAPJobGenerator.generateObject(resultSet);
                hashMap.put(sAPJobProxy.getNameAndCount(), sAPJobProxy);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the terminal {0}s for SAP System Definition ID {1}.", (Object[])new Object[]{sap_job, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return hashMap;
    }

    @Override
    public Stack<Long> getTerminalSAPJobIDsForSystemDefinitionID(long l) throws ResourceUnavailableException, DataException {
        Stack<Long> stack = new Stack<Long>();
        String string = "SELECT id FROM " + this.sapJobsTable + " WHERE sap_system_definition_id=? AND sap_job_status IN ('A','F')";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                stack.push(resultSet.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the terminal {0}s for SAP System Definition ID {1}.", (Object[])new Object[]{sap_job, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return stack;
    }

    @Override
    public HashMap<String, SAPJobSimple> getUnconfirmedSAPJobs(long l, int n) throws ResourceUnavailableException, DataException {
        HashMap<String, SAPJobSimple> hashMap = new HashMap<String, SAPJobSimple>();
        String string = "SELECT id, sap_system_definition_id, name, sap_job_count, sap_job_status FROM " + this.sapJobsTable + " WHERE sap_system_definition_id=? AND confirmed = false LIMIT " + n;
        SAPJobGenerator sAPJobGenerator = new SAPJobGenerator(5);
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPJobSimple sAPJobSimple = (SAPJobSimple)sAPJobGenerator.generateObject(resultSet);
                hashMap.put(sAPJobSimple.getNameAndCount(), sAPJobSimple);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the next {0} unconfirmed {1}s for SAP System Definition ID {2}.", (Object[])new Object[]{n, sap_job, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return hashMap;
    }

    @Override
    public boolean hasJobsForSystem(long l) throws ResourceUnavailableException, DataException {
        boolean bl = false;
        String string = "SELECT id FROM " + this.sapJobsTable + " WHERE sap_system_definition_id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s for SAP System Definition ID {1}.", (Object[])new Object[]{sap_job, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return bl;
    }

    private class SAPJobGenerator
    extends AbstractBusObjGenerator {
        public SAPJobGenerator(int n) {
            super(n, SAPJobsDMJdbc.sap_job);
        }

        protected Object constructObject() {
            return new SAPJobSimple();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPJobSimple sAPJobSimple = (SAPJobSimple)object;
            switch (n) {
                case 1: {
                    sAPJobSimple.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sAPJobSimple.setSapSystemDefinitionID(resultSet.getLong("sap_system_definition_id"));
                    break;
                }
                case 3: {
                    sAPJobSimple.setJobName(resultSet.getString("name"));
                    break;
                }
                case 4: {
                    sAPJobSimple.setJobCount(resultSet.getString("sap_job_count"));
                    break;
                }
                case 5: {
                    sAPJobSimple.setJobStatusAsString(resultSet.getString("sap_job_status"));
                    break;
                }
                case 6: {
                    sAPJobSimple.setPlannedStartMS(resultSet.getLong("sap_planned_start_utc"));
                    break;
                }
                case 7: {
                    sAPJobSimple.setEventIdentifier(resultSet.getString("sap_event_identifier"));
                    break;
                }
                case 8: {
                    sAPJobSimple.setPeriodic(resultSet.getBoolean("sap_periodic"));
                    break;
                }
                case 9: {
                    sAPJobSimple.setJobStartTimeMS(resultSet.getLong("sap_job_start_utc"));
                    break;
                }
                case 10: {
                    sAPJobSimple.setJobEndTimeMS(resultSet.getLong("sap_job_end_utc"));
                    break;
                }
                case 11: {
                    sAPJobSimple.setJobInitiator(resultSet.getString("sap_initiator"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

