/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.EventHistoryXRef;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventHistory;
import com.helpsystems.enterprise.core.dm.EventHistoryXRefDM;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.sap.SAPEventHistoryDM;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SAPEventHistoryDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPEventHistoryDM {
    private static final Logger logger = Logger.getLogger(SAPEventHistoryDMJdbc.class);
    private ReactivityAM reactivityAM;
    private EventHistoryXRefDM eventHistoryXRefDM;
    private static final String objDesc = "SAP Event";
    private static final String SAP_EVENT_HISTORY_TABLE = "sap_event_histories";
    private String sapEventsTable;

    public SAPEventHistoryDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, EventHistoryXRefDM eventHistoryXRefDM) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPEventHistoryDM");
        this.eventHistoryXRefDM = eventHistoryXRefDM;
        this.sapEventsTable = string2 + "." + SAP_EVENT_HISTORY_TABLE;
    }

    public void setReactivityAM(ReactivityAM reactivityAM) {
        ValidationHelper.checkForNull((String)"ReactivityAM", (Object)reactivityAM);
        this.reactivityAM = reactivityAM;
    }

    @Override
    public SAPEventHistory get(long l) throws ResourceUnavailableException, DataException {
        return this.get(l, null);
    }

    @Override
    public SAPEventHistory get(long l, Connection connection) throws DataException, ResourceUnavailableException {
        SAPEventHistory sAPEventHistory = new SAPEventHistory();
        sAPEventHistory.setOID(l);
        sAPEventHistory = (SAPEventHistory)super.get(connection, (Object)sAPEventHistory);
        if (sAPEventHistory == null) {
            throw new NoDataException("The SAP Event History for id " + l + " was not found.");
        }
        return sAPEventHistory;
    }

    @Override
    public SAPEventHistory save(SAPEventHistory sAPEventHistory, Connection connection) throws ResourceUnavailableException, DataException {
        SAPEventHistory sAPEventHistory2 = (SAPEventHistory)super.save(connection, (Object)sAPEventHistory);
        this.reactivityAM.notifySAPEvent(connection, sAPEventHistory2);
        return sAPEventHistory2;
    }

    @Override
    public List<SAPEventHistory> getRelatedSAPEventHistory(JobHistory jobHistory) throws ResourceUnavailableException {
        ArrayList<SAPEventHistory> arrayList = new ArrayList<SAPEventHistory>(5);
        try {
            EventHistoryXRef[] eventHistoryXRefArray = this.eventHistoryXRefDM.getListForJobHistory(jobHistory.getId(), PrereqEventType.SAP_MONITOR_EVENT);
            if (eventHistoryXRefArray != null && eventHistoryXRefArray.length > 0) {
                for (int i = 0; i < eventHistoryXRefArray.length; ++i) {
                    long l = eventHistoryXRefArray[i].getEventHistoryID();
                    SAPEventHistory sAPEventHistory = this.get(l);
                    arrayList.add(sAPEventHistory);
                }
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException(exception.getMessage(), (Throwable)exception);
        }
        return arrayList;
    }
}

