/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.uc.UniversalConnectorCommand;
import com.helpsystems.enterprise.core.uc.UniversalConnectorCommandDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UniversalConnectorCommandDMJdbc
extends AbstractDatabaseManager
implements UniversalConnectorCommandDM {
    private static final String CMD_TABLE = "universal_connector_commands";
    private static final String PARMS_TABLE = "uc_command_parameters";
    private static final String SERVER_TABLE = "universal_connector_servers";
    private String cmdTable;
    private String parmsTable;
    private String serverTable;

    public UniversalConnectorCommandDMJdbc(String string, String string2, String string3) {
        super(string);
        this.cmdTable = string2 + "." + CMD_TABLE;
        this.parmsTable = string2 + "." + PARMS_TABLE;
        this.serverTable = string2 + "." + SERVER_TABLE;
        this.setName("ENTERPRISE.UniversalConnectorCommandDM");
    }

    @Override
    public UniversalConnectorCommand get(long l, Connection connection) throws NoDataException, ResourceUnavailableException {
        boolean bl;
        PreparedStatement preparedStatement;
        String string = "SELECT c.id, c.interface_id, c.interface_name, c.template_uuid, c.template_name, s.base_url, COALESCE(s.username, '') AS username, COALESCE(s.encrypted_password, '') AS encrypted_password, COALESCE(s.password_salt, '') AS password_salt, c.retrieve_log FROM " + this.cmdTable + " c LEFT OUTER JOIN " + this.serverTable + " s ON c.universal_connector_server_id = s.id" + " WHERE c.command_id =?";
        ResultSet resultSet = null;
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string);
            bl = false;
        }
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                UniversalConnectorCommandGenerator universalConnectorCommandGenerator = new UniversalConnectorCommandGenerator();
                UniversalConnectorCommand universalConnectorCommand = (UniversalConnectorCommand)universalConnectorCommandGenerator.generateObject(resultSet);
                return universalConnectorCommand;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Could not find the Universal Connector Command associated with command ID {0}.", (Object[])new Object[]{l}));
            }
            catch (BadDataException badDataException) {
                String string2 = this.extractMessages(badDataException);
                throw new RuntimeException(MessageUtil.formatMsg((String)"The Universal Connector Command associated with command ID {0} contains corrupted data. Details: {0}", (Object[])new Object[]{string2}));
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"Error while retrieving the Universal Connector Command associated with command ID {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            } else {
                UniversalConnectorCommandDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
        }
    }

    private String extractMessages(BadDataException badDataException) {
        Exception[] exceptionArray;
        String string = badDataException.getMessage();
        for (Exception exception : exceptionArray = ((ExceptionErrorList)badDataException.getErrorList()).getExceptions()) {
            string = string + " " + exception.getMessage();
        }
        return string;
    }

    private List<NameValuePair> getParmsFromDatabase(long l, Connection connection) throws ResourceUnavailableException {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        String string = "SELECT name, value FROM " + this.parmsTable + " WHERE universal_connector_command_id =? ORDER BY line_number ASC";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = Convert.trimR((String)resultSet.getString("name"));
                String string3 = Convert.trimR((String)resultSet.getString("value"));
                int n = DataType.STRING.persistanceCode;
                if (string2.equalsIgnoreCase("http.proxyPort")) {
                    n = DataType.INTEGER.persistanceCode;
                }
                Object object = this.valueAsObject(string3, n);
                arrayList.add(new NameValuePair(string2, object));
            }
        }
        catch (SQLException sQLException) {
            try {
                String string4 = MessageUtil.formatMsg((String)"Error while retrieving the Universal Connector Command parameters associated with universal connector command ID {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string4, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                UniversalConnectorCommandDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        UniversalConnectorCommandDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    private DataType dataType(int n) {
        try {
            return DataType.persistanceCodeToEnum(n);
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Data-type code {0} is unrecognized.", (Object[])new Object[]{n}));
        }
    }

    private Object valueAsObject(String string, int n) {
        if (string == null) {
            return null;
        }
        DataType dataType = null;
        dataType = this.dataType(n);
        try {
            switch (dataType) {
                case STRING: {
                    return string;
                }
                case INTEGER: {
                    return Integer.parseInt(string);
                }
                case LONG: {
                    return Long.parseLong(string);
                }
                case BOOLEAN: {
                    if (string.equalsIgnoreCase("true") || string.equals("1")) {
                        return Boolean.TRUE;
                    }
                    if (string.equalsIgnoreCase("false") || string.equals("0")) {
                        return Boolean.FALSE;
                    }
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"{0} is not a valid representation of a boolean value.", (Object[])new Object[]{string}));
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Data type {0} is not supported by this method.", (Object[])new Object[]{dataType}));
        }
        catch (Exception exception) {
            String string2 = dataType != null ? dataType.toString() : String.valueOf(n);
            String string3 = MessageUtil.formatMsg((String)"Universal Connector parameter data-type conversion error. {0} Parameter value in the database (type=String) = {1}. Parameter data-type, per the database = {2}.", (Object[])new Object[]{exception.getMessage(), string, string2});
            throw new IllegalStateException(string3);
        }
    }

    private static enum DataType implements PersistableEnum<Integer>
    {
        STRING(1),
        INTEGER(2),
        LONG(3),
        BOOLEAN(4),
        FLOAT(5),
        OBJECT(6),
        STRING_ARRAY(21),
        INTEGER_ARRAY(22),
        LONG_ARRAY(23),
        BOOLEAN_ARRAY(24),
        FLOAT_ARRAY(25),
        OBJECT_ARRAY(26);

        private int persistanceCode;
        private static PersistanceCodeToEnumMap<Integer, DataType> map;

        private DataType(int n2) {
            this.persistanceCode = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.persistanceCode;
        }

        private static DataType persistanceCodeToEnum(int n) {
            DataType dataType = map.get(n);
            if (dataType == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return dataType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])DataType.values());
        }
    }

    private class NameValuePair {
        private String name;
        private Object value;

        private NameValuePair(String string, Object object) {
            if (string == null) {
                throw new IllegalArgumentException("Name may not be null");
            }
            this.name = string;
            this.value = object;
        }
    }

    private class UniversalConnectorCommandGenerator
    extends AbstractBusObjGenerator {
        private Map<String, String> agentParms;
        private Map<String, Object> ucParms;

        public UniversalConnectorCommandGenerator() {
            super(11, "Universal Connector Command");
            this.agentParms = new HashMap<String, String>();
            this.ucParms = new LinkedHashMap<String, Object>();
        }

        protected Object constructObject() {
            return new UniversalConnectorCommand();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            UniversalConnectorCommand universalConnectorCommand = (UniversalConnectorCommand)object;
            switch (n) {
                case 1: {
                    universalConnectorCommand.setAgentParms(this.agentParms);
                    universalConnectorCommand.setUcParms(this.ucParms);
                    break;
                }
                case 2: {
                    String string = Convert.trimR((String)resultSet.getString("base_url"));
                    if (string == null) {
                        string = "unknown server";
                    }
                    this.agentParms.put("server-url", string);
                    break;
                }
                case 3: {
                    this.agentParms.put("username", Convert.trimR((String)resultSet.getString("username")));
                    break;
                }
                case 4: {
                    this.agentParms.put("encrypted-password", Convert.trimR((String)resultSet.getString("encrypted_password")));
                    break;
                }
                case 5: {
                    this.agentParms.put("password-salt", Convert.trimR((String)resultSet.getString("password_salt")));
                    break;
                }
                case 6: {
                    long l = resultSet.getLong("interface_id");
                    this.agentParms.put("interface-id", Long.toString(l));
                    break;
                }
                case 7: {
                    String string = Convert.trimR((String)resultSet.getString("interface_name"));
                    this.agentParms.put("interface-name", string);
                    break;
                }
                case 8: {
                    this.agentParms.put("template-uuid", Convert.trimR((String)resultSet.getString("template_uuid")));
                    break;
                }
                case 9: {
                    this.agentParms.put("template-name", Convert.trimR((String)resultSet.getString("template_name")));
                    break;
                }
                case 10: {
                    Connection connection = resultSet.getStatement().getConnection();
                    long l = resultSet.getLong("id");
                    List list = UniversalConnectorCommandDMJdbc.this.getParmsFromDatabase(l, connection);
                    for (NameValuePair nameValuePair : list) {
                        this.ucParms.put(nameValuePair.name, nameValuePair.value);
                    }
                    break;
                }
                case 11: {
                    this.agentParms.put("retrieve_log", String.valueOf(resultSet.getBoolean("retrieve_log")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

