/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.ExistsAlreadyException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageDM;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SystemMessageDMJdbc
extends AbstractHelpingDatabaseManager
implements SystemMessageDM {
    private static final String TABLE_NAME = "system_messages";
    private static final Logger logger = Logger.getLogger(SystemMessageDMJdbc.class);

    public SystemMessageDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, String string3) {
        super(string, string3, sQLManagerHelper);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
    }

    @Override
    public void save(SystemMessage systemMessage) throws NotSavedException, ExistsAlreadyException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"System Message", (Object)systemMessage);
        this.insert(systemMessage);
    }

    private void insert(SystemMessage systemMessage) throws NotSavedException, ExistsAlreadyException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = super.getConnection();
            super.insert((Connection)wrappedConnection, (Object)systemMessage);
        }
        catch (Throwable throwable) {
            throw new NotSavedException("System Message was not saved.", throwable);
        }
        finally {
            SystemMessageDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    @Override
    public int purge(int n) throws ResourceUnavailableException {
        int n2;
        String string = RosettaMsg.PURGE_SYSTEM_MESSAGES_NAME.newLogEntry().getMessageText();
        String[] stringArray = new String[]{string, String.valueOf(n)};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_OLDER_THAN.newLogEntry(stringArray);
        logger.debug((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write(scheduleLogEntry);
        String string2 = "delete from " + super.qualifyLibrary() + TABLE_NAME + " where timestamp_utc < ? and acknowledged = true";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string2);
            long l = DateTranslator.getDaysOldAsMilliseconds((long)n);
            preparedStatement.setLong(1, l);
            int n3 = preparedStatement.executeUpdate();
            if (n3 > 0) {
                Date date = new Date(l);
                String[] stringArray2 = new String[]{String.valueOf(n3), string, ScheduleLogger.formatTimeStamp(date)};
                ScheduleLogEntry scheduleLogEntry2 = RosettaMsg.PURGE_COMPLETE.newLogEntry(stringArray2);
                logger.debug((Object)scheduleLogEntry2.getMessageText());
                ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry2);
            }
            n2 = n3;
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error purging System Messages.", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SystemMessageDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        SystemMessageDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return n2;
    }
}

