/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.ReplicationHeartbeat;
import com.helpsystems.enterprise.core.busobj.ReplicationStatistics;
import com.helpsystems.enterprise.core.dm.ReplicationDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ReplicationDMJdbc
extends AbstractDatabaseManager
implements ReplicationDM {
    private static Logger logger = Logger.getLogger(ReplicationDMJdbc.class);
    private static final String HEARTBEATS_TABLE = "replication_heartbeats";
    private String heartbeats_table;

    public ReplicationDMJdbc(String string, String string2) {
        super(string);
        this.setName("ENTERPRISE.ReplicationDM");
        this.heartbeats_table = string2 + "." + HEARTBEATS_TABLE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateReplicationHeartbeat(long l, long l2) throws NoDataException, ResourceUnavailableException {
        String string = "update " + this.heartbeats_table + " set heartbeat_timestamp_utc=? where id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating replication heartbeat: " + ScheduleLogger.formatTimeStampSecs(l2)));
        }
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            if (n == 0) {
                throw new NoDataException("No record was updated for the Replication Heartbeat.");
            }
            if (n > 1) {
                throw new IllegalStateException(n + " records were updated for the Replication Heartbeat.");
            }
        }
        catch (NoDataException noDataException) {
            try {
                throw noDataException;
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (Exception exception) {
                    throw new ResourceUnavailableException("Error updating the Replication Heartbeat.", (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                ReplicationDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        ReplicationDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public ReplicationHeartbeat getReplicationHeartbeat(long l) throws NoDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block7: {
            String string = "select id, heartbeat_timestamp_utc from " + this.heartbeats_table + " where id=?";
            wrappedConnection = null;
            preparedStatement = null;
            resultSet = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Retrieving Replication Heartbeat.");
            }
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block7;
            ReplicationHeartbeat replicationHeartbeat = new ReplicationHeartbeat();
            replicationHeartbeat.setId(resultSet.getLong("id"));
            replicationHeartbeat.setHeartbeatTimestampUTC(resultSet.getLong("heartbeat_timestamp_utc"));
            ReplicationHeartbeat replicationHeartbeat2 = replicationHeartbeat;
            ReplicationDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return replicationHeartbeat2;
        }
        try {
            try {
                throw new NoDataException("No record was found for the Replication Heartbeat.");
            }
            catch (NoDataException noDataException) {
                throw noDataException;
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Error retrieving the Replication Heartbeat.", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            ReplicationDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public ReplicationStatistics getReplicationStatistics() throws NoDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block9: {
            String string = "select * from pg_stat_replication";
            wrappedConnection = null;
            preparedStatement = null;
            resultSet = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Retrieving Replication Statistics.");
            }
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block9;
            ReplicationStatistics replicationStatistics = new ReplicationStatistics();
            try {
                replicationStatistics.setProcpid(resultSet.getInt("pid"));
                replicationStatistics.setSentLocation(resultSet.getString("sent_lsn"));
                replicationStatistics.setWriteLocation(resultSet.getString("write_lsn"));
                replicationStatistics.setFlushLocation(resultSet.getString("flush_lsn"));
                replicationStatistics.setReplayLocation(resultSet.getString("replay_lsn"));
            }
            catch (SQLException sQLException) {
                replicationStatistics.setProcpid(resultSet.getInt("procpid"));
                replicationStatistics.setSentLocation(resultSet.getString("sent_location"));
                replicationStatistics.setWriteLocation(resultSet.getString("write_location"));
                replicationStatistics.setFlushLocation(resultSet.getString("flush_location"));
                replicationStatistics.setReplayLocation(resultSet.getString("replay_location"));
            }
            replicationStatistics.setUsesysid(resultSet.getLong("usesysid"));
            replicationStatistics.setUsename(resultSet.getString("usename"));
            replicationStatistics.setApplicationName(resultSet.getString("application_name"));
            replicationStatistics.setClientAddr(resultSet.getString("client_addr"));
            replicationStatistics.setClientHostName(resultSet.getString("client_hostname"));
            replicationStatistics.setClientPort(resultSet.getInt("client_port"));
            replicationStatistics.setBackendStart(resultSet.getTimestamp("backend_start"));
            replicationStatistics.setState(resultSet.getString("state"));
            replicationStatistics.setSyncPriority(resultSet.getInt("sync_priority"));
            replicationStatistics.setSyncState(resultSet.getString("sync_state"));
            ReplicationStatistics replicationStatistics2 = replicationStatistics;
            ReplicationDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return replicationStatistics2;
        }
        try {
            try {
                throw new NoDataException("Replication Statistics are not available. Replication is not active.");
            }
            catch (NoDataException noDataException) {
                throw noDataException;
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Error retrieving the Replication Statistics.", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            ReplicationDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
            throw throwable;
        }
    }
}

