/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.dm.JobMonitorEventsDM;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class JobMonitorEventsDMJdbc
extends AbstractHelpingDatabaseManager
implements JobMonitorEventsDM {
    private static final Logger logger = Logger.getLogger(JobMonitorEventsDMJdbc.class);
    private ReactivityAM reactivityAM;
    private static final String TABLE = "job_monitor_events";
    private String table;

    public JobMonitorEventsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.JobMonitorEventsDM");
        this.table = string2 + "." + TABLE;
    }

    public void setReactivityAM(ReactivityAM reactivityAM) {
        ValidationHelper.checkForNull((String)"ReactivityAM", (Object)reactivityAM);
        this.reactivityAM = reactivityAM;
    }

    @Override
    public JobMonitorEvent get(long l) throws ResourceUnavailableException, DataException {
        return this.get(l, null);
    }

    @Override
    public JobMonitorEvent get(long l, Connection connection) throws DataException, ResourceUnavailableException {
        JobMonitorEvent jobMonitorEvent = new JobMonitorEvent();
        jobMonitorEvent.setID(l);
        jobMonitorEvent = (JobMonitorEvent)((Object)super.get(connection, (Object)jobMonitorEvent));
        if (jobMonitorEvent == null) {
            throw new NoDataException("The Job Monitor Event for oid " + l + " was not found.");
        }
        return jobMonitorEvent;
    }

    @Override
    public JobMonitorEvent save(JobMonitorEvent jobMonitorEvent, Connection connection) throws ResourceUnavailableException, DataException {
        JobMonitorEvent jobMonitorEvent2 = (JobMonitorEvent)((Object)super.save(connection, (Object)jobMonitorEvent));
        this.reactivityAM.notifyJobMonitorEvent(jobMonitorEvent2);
        return jobMonitorEvent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purgeHistory(int n) throws DataException, ResourceUnavailableException, SQLException {
        long l;
        int n2;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block4: {
            int n3;
            wrappedConnection = null;
            preparedStatement = null;
            n2 = 0;
            try {
                wrappedConnection = this.getConnection();
                l = DateTranslator.getDaysOldAsMilliseconds((long)n);
                if (l >= 0L) break block4;
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.ERROR_CALCULATING_PURGE_DATE.newLogEntry();
                logger.debug((Object)scheduleLogEntry.getMessageText());
                ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry);
                n3 = 0;
            }
            catch (Throwable throwable) {
                JobMonitorEventsDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
            JobMonitorEventsDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
            return n3;
        }
        Date date = new Date(l);
        String string = "DELETE FROM " + super.qualifyLibrary() + "JOB_MONITOR_EVENTS" + " WHERE EVENT_DETECTION_TIME_UTC < ?";
        String string2 = RosettaMsg.PURGE_JOB_MONITOR_EVENTS_NAME.newLogEntry().getMessageText();
        String[] stringArray = new String[]{string2, String.valueOf(n)};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_OLDER_THAN.newLogEntry(stringArray);
        logger.debug((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry);
        preparedStatement = wrappedConnection.prepareStatement(string);
        Timestamp timestamp = new Timestamp(date.getTime());
        preparedStatement.setLong(1, timestamp.getTime());
        n2 = preparedStatement.executeUpdate();
        if (n2 > 0) {
            String[] stringArray2 = new String[]{String.valueOf(n2), string2, ScheduleLogger.formatTimeStamp(date)};
            ScheduleLogEntry scheduleLogEntry2 = RosettaMsg.PURGE_COMPLETE.newLogEntry(stringArray2);
            ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry2);
            logger.debug((Object)scheduleLogEntry2.getMessageText());
        }
        int n4 = n2;
        JobMonitorEventsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return n4;
    }
}

