/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.access.ResultSetDataSet;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.CachingDataSet;
import com.helpsystems.enterprise.core.busobj.AgentEventFile;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentEventProcess;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.busobj.DirectoryEvent;
import com.helpsystems.enterprise.core.busobj.FileEvent;
import com.helpsystems.enterprise.core.busobj.ManualEvent;
import com.helpsystems.enterprise.core.busobj.ProcessEvent;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.AgentEventRefreshAM;
import com.helpsystems.enterprise.core.dm.RefreshNotificationException;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AgentEventMonitorDMJdbc
extends AbstractHelpingDatabaseManager
implements AgentEventMonitorDM {
    private static final Logger logger = Logger.getLogger(AgentEventMonitorDMJdbc.class);
    private boolean connectedToEntServer;
    private AgentEventRefreshAM eventRefreshAM;

    public AgentEventMonitorDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.AgentEventMonitorDM");
    }

    private PreparedStatement getStmt(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string, 1004, 1007);
    }

    @Override
    public AgentEventMonitor get(long l, Connection connection) throws ResourceUnavailableException, DataException {
        AgentEventMonitor agentEventMonitor = new AgentEventMonitor();
        agentEventMonitor.setOID(l);
        agentEventMonitor = connection == null ? (AgentEventMonitor)((Object)super.get((Object)agentEventMonitor)) : (AgentEventMonitor)((Object)super.get(connection, (Object)agentEventMonitor));
        if (agentEventMonitor == null) {
            throw new NoDataException("The requested AgentEventMonitor was not found.");
        }
        return agentEventMonitor;
    }

    @Override
    public AgentEventMonitor get(String string, Connection connection) throws ResourceUnavailableException, DataException {
        AgentEventMonitor agentEventMonitor = new AgentEventMonitor();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("getName", string);
        AgentEventMonitor[] agentEventMonitorArray = (AgentEventMonitor[])super.search(connection, (Object)agentEventMonitor, hashMap);
        if (agentEventMonitorArray != null && agentEventMonitorArray.length == 1) {
            return agentEventMonitorArray[0];
        }
        return null;
    }

    @Override
    public AgentEventMonitor[] getList() throws ResourceUnavailableException, DataException {
        AgentEventMonitor[] agentEventMonitorArray;
        String string = "select ID, event_monitor_type, name, description, target_ID, disabled, cycle_time, from_time, to_time, days_to_retain, system_defaults_for_event_log_purge, target_type, timezone_type from AGENT_EVENT_MONITORS";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DataSet dataSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = this.getStmt((Connection)wrappedConnection, string);
            AgentEventMonitorGenerator agentEventMonitorGenerator = new AgentEventMonitorGenerator();
            int n = -1;
            resultSet = preparedStatement.executeQuery();
            dataSet = ResultSetDataSet.createDataSet((ResultSet)resultSet, (BusinessObjectGenerator)agentEventMonitorGenerator, (int)n, (int)100);
            if (wrappedConnection.isClosed()) {
                wrappedConnection = null;
            }
            CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
            AgentEventMonitor[] agentEventMonitorArray2 = new AgentEventMonitor[cachingDataSet.size()];
            for (int i = 0; i < agentEventMonitorArray2.length; ++i) {
                AgentEventMonitor agentEventMonitor = (AgentEventMonitor)((Object)cachingDataSet.get(i));
                agentEventMonitorArray2[i] = this.getFullEvent(agentEventMonitor, (Connection)wrappedConnection);
            }
            agentEventMonitorArray = agentEventMonitorArray2;
        }
        catch (Exception exception) {
            try {
                throw new ResourceUnavailableException("Could not get a list of Agent Event Monitors", (Throwable)exception);
            }
            catch (Throwable throwable) {
                AgentEventMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AgentEventMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return agentEventMonitorArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AgentEventMonitor getFullEvent(AgentEventMonitor agentEventMonitor, Connection connection) throws ResourceUnavailableException {
        if (agentEventMonitor == null) {
            return null;
        }
        boolean bl = false;
        Connection connection2 = null;
        try {
            if (connection == null) {
                connection2 = this.getConnection();
            } else {
                connection2 = connection;
                bl = true;
            }
            switch (agentEventMonitor.getType()) {
                case 0: {
                    ManualEvent manualEvent = new ManualEvent();
                    manualEvent.clone(agentEventMonitor);
                    ManualEvent manualEvent2 = manualEvent;
                    return manualEvent2;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    FileEvent fileEvent = new FileEvent();
                    fileEvent.clone(agentEventMonitor);
                    fileEvent.setAgentEventFile(this.getAgentFileEvent(fileEvent, connection2));
                    FileEvent fileEvent2 = fileEvent;
                    return fileEvent2;
                }
                case 201: 
                case 202: 
                case 203: 
                case 204: {
                    DirectoryEvent directoryEvent = new DirectoryEvent();
                    directoryEvent.clone(agentEventMonitor);
                    directoryEvent.setAgentEventFile(this.getAgentDirectoryEvent(directoryEvent, connection2));
                    DirectoryEvent directoryEvent2 = directoryEvent;
                    return directoryEvent2;
                }
                case 301: 
                case 302: {
                    ProcessEvent processEvent = new ProcessEvent();
                    processEvent.clone(agentEventMonitor);
                    processEvent.setAgentEventProcess(this.getAgentProcessEvent(processEvent, connection2));
                    ProcessEvent processEvent2 = processEvent;
                    return processEvent2;
                }
            }
            return agentEventMonitor;
        }
        catch (SQLException sQLException) {
            String string = "Error trying to get connection for Agent event monitor.";
            logger.debug((Object)string, (Throwable)sQLException);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        finally {
            if (!bl) {
                AgentEventMonitorDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
    }

    private AgentEventFile getAgentFileEvent(FileEvent fileEvent, Connection connection) {
        AgentEventFile agentEventFile = new AgentEventFile();
        try {
            return (AgentEventFile)((Object)super.get(connection, (Object)fileEvent.getAgentEventFile()));
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)"Unable to fetch file event second-level data.", (Throwable)resourceUnavailableException);
            agentEventFile.setOID(fileEvent.getOID());
            return agentEventFile;
        }
        catch (DataException dataException) {
            logger.debug((Object)"Unable to fetch file event second-level data.", (Throwable)dataException);
            agentEventFile.setOID(fileEvent.getOID());
            return agentEventFile;
        }
    }

    private AgentEventFile getAgentDirectoryEvent(DirectoryEvent directoryEvent, Connection connection) {
        AgentEventFile agentEventFile = new AgentEventFile(2);
        try {
            return (AgentEventFile)((Object)super.get(connection, (Object)directoryEvent.getAgentEventFile()));
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)"Unable to fetch dir event second-level data.", (Throwable)resourceUnavailableException);
            agentEventFile.setOID(directoryEvent.getOID());
            return agentEventFile;
        }
        catch (DataException dataException) {
            logger.debug((Object)"Unable to fetch dir event second-level data.", (Throwable)dataException);
            agentEventFile.setOID(directoryEvent.getOID());
            return agentEventFile;
        }
    }

    private AgentEventProcess getAgentProcessEvent(ProcessEvent processEvent, Connection connection) {
        AgentEventProcess agentEventProcess = new AgentEventProcess();
        try {
            return (AgentEventProcess)((Object)super.get(connection, (Object)processEvent.getAgentEventProcess()));
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)"Unable to fetch process event second-level data.", (Throwable)resourceUnavailableException);
            agentEventProcess.setOID(processEvent.getOID());
            return agentEventProcess;
        }
        catch (DataException dataException) {
            logger.debug((Object)"Unable to fetch process event second-level data.", (Throwable)dataException);
            agentEventProcess.setOID(processEvent.getOID());
            return agentEventProcess;
        }
    }

    @Override
    public boolean isAgentUsed(AgentProxy agentProxy) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM AGENT_EVENT_MONITORS WHERE target_ID=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        return this.getCount(preparedStatement, agentProxy.getOid()) > 0;
    }

    private int getCount(PreparedStatement preparedStatement, Object object) throws ResourceUnavailableException {
        ResultSet resultSet = null;
        try {
            preparedStatement.setObject(1, object);
            int n = 0;
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n += resultSet.getInt(1);
            }
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            String string = "Error while executing the SQL statement in the getCount method.";
            logger.debug((Object)string, (Throwable)sQLException);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private void resyncAgentEvents(long l) throws RefreshNotificationException {
        if (!this.connectedToEntServer) {
            logger.warn((Object)("Agent Event Monitor resync skipped for agent OID " + l + ".  AgentEventMonitorDMJdbc is not connected to the Enterprise Server."));
            return;
        }
        if (this.eventRefreshAM == null) {
            logger.warn((Object)("eventRefreshAM is not set.  Unable to notify agent with OID: " + l));
            throw new RefreshNotificationException(l);
        }
        try {
            this.eventRefreshAM.refreshEventsForAgent(l);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to notify the Enterprise Server that Agent " + l + " needs to have its Event Monitors refreshed."), (Throwable)exception);
            throw new RefreshNotificationException(l, (Throwable)exception);
        }
    }

    @Override
    public void setAgentEventRefreshAM(boolean bl, AgentEventRefreshAM agentEventRefreshAM) {
        this.connectedToEntServer = bl;
        this.eventRefreshAM = agentEventRefreshAM;
    }

    @Override
    public void synchronizeEventsOnAgent(long l) throws RefreshNotificationException {
        this.resyncAgentEvents(l);
    }

    @Override
    public AgentEventMonitor[] getEventsForAgent(long l) throws ResourceUnavailableException {
        AgentEventMonitor[] agentEventMonitorArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ID, event_monitor_type, name, ");
        stringBuilder.append("description, target_ID, disabled, cycle_time, from_time, to_time, ");
        stringBuilder.append("days_to_retain, system_defaults_for_event_log_purge, target_type, timezone_type ");
        stringBuilder.append("from ");
        stringBuilder.append("AGENT_EVENT_MONITORS");
        stringBuilder.append(" where ");
        stringBuilder.append("(target_type='");
        stringBuilder.append(ScheduleInfo.TargetType.AGENT.persistanceCode());
        stringBuilder.append("' and target_ID = ? )");
        stringBuilder.append(" or ");
        stringBuilder.append("(target_type='");
        stringBuilder.append(ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode());
        stringBuilder.append("' and target_ID in (select agent_group_id from ");
        stringBuilder.append("agent_group_agents");
        stringBuilder.append(" where agent_id = ?) )");
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DataSet dataSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = this.getStmt((Connection)wrappedConnection, stringBuilder.toString());
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            AgentEventMonitorGenerator agentEventMonitorGenerator = new AgentEventMonitorGenerator();
            int n = -1;
            resultSet = preparedStatement.executeQuery();
            dataSet = ResultSetDataSet.createDataSet((ResultSet)resultSet, (BusinessObjectGenerator)agentEventMonitorGenerator, (int)n, (int)100);
            if (wrappedConnection.isClosed()) {
                wrappedConnection = null;
            }
            CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
            AgentEventMonitor[] agentEventMonitorArray2 = new AgentEventMonitor[cachingDataSet.size()];
            for (int i = 0; i < agentEventMonitorArray2.length; ++i) {
                AgentEventMonitor agentEventMonitor = (AgentEventMonitor)((Object)cachingDataSet.get(i));
                agentEventMonitorArray2[i] = this.getFullEvent(agentEventMonitor, (Connection)wrappedConnection);
            }
            agentEventMonitorArray = agentEventMonitorArray2;
        }
        catch (Exception exception) {
            try {
                throw new ResourceUnavailableException("Could not get a list of Agent Event Monitors used by Automate Schedule Agent " + l, (Throwable)exception);
            }
            catch (Throwable throwable) {
                AgentEventMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AgentEventMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return agentEventMonitorArray;
    }

    @Override
    public AgentEventMonitor[] getAgentEventMonitorsByAgentGroupId(long l) throws ResourceUnavailableException, DataException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("getTargetID", l);
        hashMap.put("getTargetType", ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode());
        return (AgentEventMonitor[])super.search((Object)new AgentEventMonitor(), hashMap);
    }

    private class AgentEventMonitorGenerator
    extends AbstractBusObjGenerator {
        static final int numPassesToMake = 12;

        AgentEventMonitorGenerator() {
            super(12, AgentEventMonitor.class.getName());
        }

        private Object constructObject(ResultSet resultSet) throws SQLException {
            AgentEventMonitor agentEventMonitor = null;
            int n = -1;
            n = resultSet.getInt("event_monitor_type");
            switch (n) {
                case 0: {
                    agentEventMonitor = new ManualEvent();
                    agentEventMonitor.setType(n);
                    return agentEventMonitor;
                }
                case 301: 
                case 302: {
                    agentEventMonitor = new ProcessEvent();
                    agentEventMonitor.setType(n);
                    return agentEventMonitor;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    agentEventMonitor = new FileEvent();
                    agentEventMonitor.setType(n);
                    return agentEventMonitor;
                }
                case 201: 
                case 202: 
                case 203: 
                case 204: {
                    agentEventMonitor = new DirectoryEvent();
                    agentEventMonitor.setType(n);
                    return agentEventMonitor;
                }
            }
            throw new IllegalArgumentException("Unsupported event type: " + Integer.toString(n));
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException {
            AgentEventMonitor agentEventMonitor = this.getType(resultSet, object);
            switch (n) {
                case 1: {
                    agentEventMonitor.setName(resultSet.getString("name"));
                    break;
                }
                case 2: {
                    agentEventMonitor.setDescription(resultSet.getString("description"));
                    break;
                }
                case 3: {
                    agentEventMonitor.setOID(resultSet.getInt("ID"));
                    break;
                }
                case 4: {
                    agentEventMonitor.setTargetID(resultSet.getInt("target_ID"));
                    break;
                }
                case 5: {
                    agentEventMonitor.setDisabled(resultSet.getBoolean("disabled"));
                    break;
                }
                case 6: {
                    agentEventMonitor.setCycle(resultSet.getInt("cycle_time"));
                    break;
                }
                case 7: {
                    agentEventMonitor.setFromTime(resultSet.getInt("from_time"));
                    break;
                }
                case 8: {
                    agentEventMonitor.setToTime(resultSet.getInt("to_time"));
                    break;
                }
                case 9: {
                    agentEventMonitor.setDaysToRetainHistory(resultSet.getInt("days_to_retain"));
                    break;
                }
                case 10: {
                    agentEventMonitor.setUseDefaultsForHistoryPurge(resultSet.getBoolean("system_defaults_for_event_log_purge"));
                    break;
                }
                case 11: {
                    String string = resultSet.getString("target_type");
                    agentEventMonitor.setTargetType(ScheduleInfo.TargetType.persistanceCodeToEnum(string));
                    break;
                }
                case 12: {
                    String string = resultSet.getString("timezone_type");
                    agentEventMonitor.setTimeZoneType(ScheduleInfo.TimeZoneType.persistanceCodeToEnum(string));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass #" + n + " exceeds maximum.");
                }
            }
        }

        private AgentEventMonitor getType(ResultSet resultSet, Object object) throws SQLException {
            AgentEventMonitor agentEventMonitor = (AgentEventMonitor)((Object)object);
            if (object instanceof ManualEvent || object instanceof DirectoryEvent || object instanceof FileEvent || object instanceof ProcessEvent) {
                return agentEventMonitor;
            }
            int n = resultSet.getInt("type");
            switch (n) {
                case 0: {
                    agentEventMonitor = new ManualEvent();
                    agentEventMonitor.setType(0);
                    return agentEventMonitor;
                }
                case 301: 
                case 302: {
                    agentEventMonitor = new ProcessEvent();
                    agentEventMonitor.setType(n);
                    return agentEventMonitor;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    agentEventMonitor = new FileEvent();
                    agentEventMonitor.setType(n);
                    return agentEventMonitor;
                }
                case 201: 
                case 202: 
                case 203: 
                case 204: {
                    agentEventMonitor = new DirectoryEvent();
                    agentEventMonitor.setType(n);
                    return agentEventMonitor;
                }
            }
            throw new IllegalArgumentException("Unsupported event type: " + Integer.toString(n));
        }

        public Object generateObject(ResultSet resultSet) throws BadDataException, SQLException, ResourceUnavailableException {
            ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
            if (resultSet == null) {
                throw new NullPointerException("Result set may not be null.");
            }
            Object object = this.constructObject(resultSet);
            if (object == null) {
                throw new NullPointerException("Business object may not be null.");
            }
            for (int i = 1; i <= 12; ++i) {
                try {
                    this.getDataFromRS(resultSet, object, i);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    exceptionErrorList.addException((Exception)runtimeException);
                }
            }
            try {
                this.validate(object);
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            if (exceptionErrorList.getErrorCount() > 0) {
                throw new BadDataException("Unable to fully restore " + AgentEventMonitor.class.getName(), object, (ErrorList)exceptionErrorList);
            }
            return object;
        }

        protected Object constructObject() {
            return null;
        }
    }
}

