/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.automate;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTaskCommand;
import com.helpsystems.enterprise.core.dm.automate.AutoMateCommandsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class AutoMateCommandsDMJdbc
extends AbstractHelpingDatabaseManager
implements AutoMateCommandsDM {
    private static final String objDesc = "AutoMate Task Command";
    private static final String AUTOMATE_COMMANDS_TABLE = "automate_commands";
    private String autoMateCommandsTable;

    public AutoMateCommandsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.AutoMateCommandsDM");
        this.autoMateCommandsTable = string2 + "." + AUTOMATE_COMMANDS_TABLE;
    }

    @Override
    public AutoMateTaskCommand getAutoMateTaskCommandViaCommandID(long l) throws NoDataException, ResourceUnavailableException, BadDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            AutoMateTaskCommand autoMateTaskCommand;
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id, command_id, automate_system_definition_id, task_path, task_id, must_be_enabled, run_by_id FROM " + this.autoMateCommandsTable + " WHERE command_id=?";
            AutoMateTaskCommandGenerator autoMateTaskCommandGenerator = new AutoMateTaskCommandGenerator(7);
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            AutoMateTaskCommand autoMateTaskCommand2 = autoMateTaskCommand = (AutoMateTaskCommand)autoMateTaskCommandGenerator.generateObject(resultSet);
            AutoMateCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return autoMateTaskCommand2;
        }
        try {
            try {
                throw new NoDataException("AutoMate Task Command not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            AutoMateCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private class AutoMateTaskCommandGenerator
    extends AbstractBusObjGenerator {
        public AutoMateTaskCommandGenerator(int n) {
            super(n, AutoMateCommandsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new AutoMateTaskCommand();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AutoMateTaskCommand autoMateTaskCommand = (AutoMateTaskCommand)object;
            switch (n) {
                case 1: {
                    autoMateTaskCommand.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    autoMateTaskCommand.setCommandID(resultSet.getLong("command_id"));
                    break;
                }
                case 3: {
                    autoMateTaskCommand.setAutoMateSystemDefinitionID(resultSet.getLong("automate_system_definition_id"));
                    break;
                }
                case 4: {
                    autoMateTaskCommand.setTaskPath(resultSet.getString("task_path"));
                    break;
                }
                case 5: {
                    autoMateTaskCommand.setTaskID(resultSet.getString("task_id"));
                    break;
                }
                case 6: {
                    autoMateTaskCommand.setTaskMustBeEnabled(resultSet.getBoolean("must_be_enabled"));
                    break;
                }
                case 7: {
                    autoMateTaskCommand.setRunByID(resultSet.getBoolean("run_by_id"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

