/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class CheckTCPService
extends AbstractJobConditionValidator {
    private static final Logger logger = Logger.getLogger(CheckTCPService.class);

    public boolean checkCondition(JobCondition jobCondition) {
        return jobCondition.isConditionChoice() ? this.isAvailableService(jobCondition) : !this.isAvailableService(jobCondition);
    }

    private boolean isAvailableService(JobCondition jobCondition) {
        return this.checkForTCPService(jobCondition.getConditionData().trim(), jobCondition.getConditionVar1(), jobCondition.getConditionVar2());
    }

    private boolean checkForTCPService(String string, int n, int n2) {
        if (n2 > 0) {
            return this.checkTCPServiceWithTimeout(string, n, n2);
        }
        return this.checkTCPService(string, n);
    }

    /*
     * Exception decompiling
     */
    private boolean checkTCPServiceWithTimeout(String var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkTCPService(String string, int n) {
        boolean bl = false;
        Socket socket = null;
        try {
            socket = new Socket(InetAddress.getByName(string), n);
            bl = true;
            this.closeSocketQuietly(socket);
        }
        catch (UnknownHostException unknownHostException) {
            bl = false;
            logger.debug((Object)"UnknownHostException. ", (Throwable)unknownHostException);
            this.closeSocketQuietly(socket);
        }
        catch (IOException iOException) {
            bl = false;
            logger.debug((Object)"IOException. ", (Throwable)iOException);
            this.closeSocketQuietly(socket);
            {
                catch (Throwable throwable) {
                    this.closeSocketQuietly(socket);
                    throw throwable;
                }
            }
        }
        return bl;
    }

    public String toString(JobCondition jobCondition) {
        return "Checking TCP Service.";
    }

    private void closeSocketQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                logger.debug((Object)"Problem occured when closing the socket ", (Throwable)iOException);
            }
        }
    }
}

