/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.ha;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.busobj.ReplicationHeartbeat;
import com.helpsystems.enterprise.core.dm.ReplicationDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.peer.AgentPeer;
import org.apache.log4j.Logger;

public class ReplicationHeartbeatMonitor
implements Runnable {
    private static final Logger logger = Logger.getLogger(ReplicationHeartbeatMonitor.class);
    public static final String HEARTBEAT_THREAD_NAME = "ReplicationHeartbeatMonitor";
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long HEARRTBEAT_INTERVAL = 600000L;
    private static final long MAX_HEARRTBEAT_AGE_MINUTES = 30L;
    private static final long MAX_HEARRTBEAT_AGE_MILLIS = 1800000L;
    private static final long MIN_NOTIFICATION_INTERVAL = 21600000L;
    private boolean stop = false;
    AgentPeer agentPeer = null;

    public ReplicationHeartbeatMonitor(AgentPeer agentPeer) {
        this.agentPeer = agentPeer;
    }

    @Override
    public void run() {
        long l;
        ReplicationDM replicationDM = null;
        long l2 = l = System.currentTimeMillis();
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        while (true) {
            try {
                while (true) {
                    if (this.stop) {
                        return;
                    }
                    l3 = l2 / 600000L * 600000L + 600000L + 60000L;
                    l5 = l3 - l + 100L;
                    if (l5 < 60000L) {
                        l5 = 60000L;
                    }
                    do {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Waiting " + l5 + "ms for next Replication heartbeat interval: " + ScheduleLogger.formatTimeStampSecs((long)l3)));
                        }
                        if (l5 > 0L) {
                            try {
                                Thread.sleep(l5);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        l = System.currentTimeMillis();
                        l5 = 3000L;
                    } while (l3 > l);
                    if (this.stop) {
                        return;
                    }
                    l = System.currentTimeMillis();
                    if (replicationDM == null) {
                        replicationDM = (ReplicationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReplicationDM");
                    }
                    ReplicationHeartbeat replicationHeartbeat = replicationDM.getReplicationHeartbeat(1L);
                    long l6 = l - replicationHeartbeat.getHeartbeatTimestampUTC();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Replication Heartbeat: " + ScheduleLogger.formatTimeStampSecs((long)replicationHeartbeat.getHeartbeatTimestampUTC())));
                    }
                    if (l6 > 1800000L) {
                        logger.warn((Object)("Stale Replication heartbeat detected: " + ScheduleLogger.formatTimeStampSecs((long)replicationHeartbeat.getHeartbeatTimestampUTC())));
                        long l7 = l - l4;
                        if (l7 > 21600000L) {
                            l4 = l;
                            try {
                                String string = "Automate Schedule standby replication heartbeat is more than 30 minutes old.";
                                String string2 = "The replication heartbeat timestamp from the standby server database is: " + ScheduleLogger.formatTimeStampSecs((long)replicationHeartbeat.getHeartbeatTimestampUTC()) + ". " + "The standy server time is: " + ScheduleLogger.formatTimeStampSecs((long)replicationHeartbeat.getHeartbeatTimestampUTC()) + ".";
                                this.agentPeer.sendStandbyEmail(string, string2);
                            }
                            catch (Throwable throwable) {
                                logger.error((Object)"Error sending stale heartbeat notification.", throwable);
                            }
                        }
                    }
                    l2 = l;
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)"An error occurred in the Heartbeat process.", throwable);
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean bl) {
        this.stop = bl;
    }
}

