/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileTransferAM;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class StandbyBackupFileTransferRunner
implements Runnable {
    private static final long serialVersionUID = 3577570090558761403L;
    private static Logger logger = Logger.getLogger(StandbyBackupFileTransferRunner.class);
    public static final String THREAD_NAME = "Standby backup file transfer runner thread";
    private static final int NORMAL_CHECK_TIME = 10000;
    private static final int STARTUP_TIME = 30000;
    private AgentPeer serverPeer = null;
    private boolean isShutdown = false;
    private StandbyBackupFileTransferAM standbyBackupFileTransferAM;
    private StandbyBackupFileQueueAM standbyBackupFileQueueAM;

    public StandbyBackupFileTransferRunner(AgentPeer agentPeer) {
        this.serverPeer = agentPeer;
        this.standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.StandbyBackupFileQueueAM");
    }

    private StandbyBackupFileTransferAM getStandbyBackupFileTransferAM() {
        PeerID[] peerIDArray;
        if (this.standbyBackupFileTransferAM == null && (peerIDArray = this.serverPeer.getConnectedStandbyServer()) != null && peerIDArray.length > 0) {
            PeerID peerID = peerIDArray[0];
            this.standbyBackupFileTransferAM = (StandbyBackupFileTransferAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.StandbyBackupFileTransferAM");
        }
        return this.standbyBackupFileTransferAM;
    }

    @Override
    public void run() {
        int n = 30000;
        this.isShutdown = false;
        logger.info((Object)"StandbyBackupFileTransferRunner has started.");
        while (!this.isShutdown) {
            try {
                if (!this.isStandbyConnected() || !this.standbyBackupFileQueueAM.dataQueueHasData()) {
                    Thread.sleep(n);
                    n = 10000;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isStandbyConnected()) continue;
            try {
                while (this.isStandbyConnected() && this.serverPeer != null && !this.serverPeer.isShutdownRequested() && this.serverPeer.isStartupComplete() && this.serverPeer.isReadyForConnections() && this.standbyBackupFileQueueAM.dataQueueHasData()) {
                    this.processStandbyBackupFileTransfer();
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"StandbyBackupFileTransferRunner failed with the following error.", throwable);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        logger.info((Object)"StandbyBackupFileTransferRunner has ended.");
    }

    private void processStandbyBackupFileTransfer() {
        StandbyBackupFile standbyBackupFile = null;
        try {
            standbyBackupFile = this.standbyBackupFileQueueAM.getStandbyBackupFile();
        }
        catch (IOException iOException) {
            logger.info((Object)"Failed to get next standby file queue entry.", (Throwable)iOException);
            standbyBackupFile = null;
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (standbyBackupFile != null) {
            if (standbyBackupFile.getActionType() == 0) {
                String string = standbyBackupFile.getFullFileName();
                File file = new File(string);
                if (file.exists()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Copying file to standby server: " + string));
                    }
                    this.getStandbyBackupFileTransferAM().transferStandbyBackupFile(standbyBackupFile);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("File not available for transfer to standby: " + string));
                }
            } else if (standbyBackupFile.getActionType() == 1) {
                String string = standbyBackupFile.getFullFileName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting file on standby server: " + string));
                }
                this.getStandbyBackupFileTransferAM().purgeStandbyBackupFile(standbyBackupFile);
            }
        }
    }

    public void shutdown() {
        this.isShutdown = true;
    }

    private boolean isStandbyConnected() {
        return this.serverPeer.getConnectedStandbyServer().length > 0;
    }
}

