/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.access.service.JdbcServiceDescriptor;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.service.Service;
import com.helpsystems.common.core.service.ServiceException;
import com.helpsystems.common.core.xml.ObjectPair;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.common.tl.event.PeerConnectEvent;
import com.helpsystems.common.tl.event.PeerDisconnectEvent;
import com.helpsystems.common.tl.event.PeerLoggingLevelUpdatedEvent;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.common.tl.module.ModuleDescriptor;
import com.helpsystems.enterprise.access.EnterpriseDatabase;
import com.helpsystems.enterprise.core.busobj.EnterpriseService;
import com.helpsystems.enterprise.core.dm.AgentStatusAM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.SchedulerStatusAM;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.NotificationCredentials;
import com.helpsystems.enterprise.peer.ReportRunner;
import com.helpsystems.enterprise.peer.StandbyChecker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.w3c.dom.Document;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ServicePeer
extends AgentPeer {
    private static final String SERVICE_LOG4J_FILENAME_KEY = "log4j.appender.R.File";
    private static final Logger logger = Logger.getLogger(ServicePeer.class);
    public static final String PRODUCT_NAME = "schent-mp";
    private static PeerID serverPeerID = null;
    private static PeerDescriptor master = null;
    private static int localServerPort = 0;
    private static NotificationCredentials creds = new NotificationCredentials();
    private JdbcServiceDescriptor jdbcSrvDesc;
    private EnterpriseService service = null;
    private Service jdbcService;
    private static final String SERVER_CONFIG_PATH = "webapps/automate-schedule/WEB-INF/config";
    private static final String SERVER_CONFIG_FILE = "entServer.xml";

    private ServicePeer(PeerDescriptor peerDescriptor, AgentPeerConfig agentPeerConfig) throws PeerStartupException {
        super(peerDescriptor, agentPeerConfig);
        peerDescriptor.setType(8);
    }

    @Override
    public void startup() throws PeerStartupException {
        AgentPeerConfig agentPeerConfig = (AgentPeerConfig)this.getConfig();
        if (this.service.getLocalService()) {
            this.startConnectionPool(agentPeerConfig);
        }
        ModuleDescriptor[] moduleDescriptorArray = agentPeerConfig.getModuleDescriptorsForProduct(PRODUCT_NAME);
        ModuleDescriptor moduleDescriptor = null;
        if (moduleDescriptorArray.length > 0) {
            moduleDescriptor = moduleDescriptorArray[0];
        } else {
            moduleDescriptor = new ModuleDescriptor();
            moduleDescriptor.setProductName(PRODUCT_NAME);
            agentPeerConfig.addModuleDescriptor(moduleDescriptor);
        }
        System.out.println("about to start services...");
        try {
            this.startServices();
        }
        catch (ServiceException serviceException) {
            throw new PeerStartupException("One of the required services failed to load.", (Throwable)serviceException);
        }
        this.loadAllDefinedModules();
        if (!System.getProperty("os.name").startsWith("Windows")) {
            try {
                ServicePeer.captureSignal("HUP");
            }
            catch (Exception exception) {}
        } else {
            SignalHandler signalHandler = new SignalHandler(){

                @Override
                public void handle(Signal signal) {
                    String string = signal.getName() + " caught, exiting.";
                    logger.debug((Object)string);
                    System.out.println(string);
                    System.out.flush();
                    System.exit(1);
                }
            };
            Signal.handle(new Signal("INT"), signalHandler);
            Signal.handle(new Signal("TERM"), signalHandler);
            Signal.handle(new Signal("ABRT"), signalHandler);
        }
        this.addListener(new ServicePeerListener());
    }

    private void setLoggingLevel(int n) {
        try {
            Level level;
            int n2 = n;
            if (n2 == -1) {
                level = (IPeerInfoManager)ManagerRegistry.getManagerStartsWith((BasicIdentifier)serverPeerID, (String)"PEER.PeerInfoManager");
                n2 = level.getLoggingLevel();
            }
            level = Level.toLevel((int)n2);
            Logger.getRootLogger().setLevel(level);
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Unable to set logging level to server levels.", throwable);
        }
    }

    private void setService(EnterpriseService enterpriseService) {
        this.service = enterpriseService;
    }

    public static void main(String[] stringArray) {
        EnterpriseService enterpriseService = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray != null && stringArray.length == 1 && stringArray[0].contains(":")) {
            String[] stringArray2 = stringArray[0].split(":");
            if (stringArray2.length != 3) {
                ServicePeer.exit(1, "Please specify the <Enterprise Server port>:<the Service Port>: and the Service <Class> name on the command line.");
            }
            string = stringArray2[0];
            string2 = stringArray2[1];
            string3 = stringArray2[2];
        } else if (stringArray.length != 3 && stringArray.length > 5) {
            ServicePeer.exit(1, "Please specify the Enterprise Server port, the Service Port,  and the Service Class name, and optionally, the Enterprise Server Address and Administrator password on the command line.");
        } else {
            System.out.println("Processing: " + stringArray[0] + "  " + stringArray[1] + "  " + stringArray[2]);
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ServicePeer.exit(1, "Invalid server port specified: " + string);
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            ServicePeer.exit(1, "Invalid servicePort specified: " + stringArray[1]);
        }
        if (n2 == 0) {
            n2 = -1234;
        }
        String string4 = null;
        String string5 = null;
        if (stringArray.length > 3) {
            string4 = stringArray[3];
            if (stringArray.length > 4) {
                string5 = stringArray[4];
            }
        }
        String string6 = string3;
        try {
            if (!string6.toLowerCase().startsWith("com.helpsystems.enterprise.peer")) {
                ServicePeer.exit(1, "Class " + string3 + " is not an EnterpriseService.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            ServicePeer.exit(1, "Class " + string3 + " is not an EnterpriseService.");
        }
        try {
            enterpriseService = (EnterpriseService)Class.forName(string6).newInstance();
            enterpriseService.setServicePort(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            ServicePeer.exit(1, "Class " + string3 + " is not an EnterpriseService.");
        }
        AgentPeerConfig agentPeerConfig = null;
        try {
            agentPeerConfig = ServicePeer.getServerConfig(enterpriseService, n);
        }
        catch (Exception exception) {
            ServicePeer.exit(1, "Could not find config file...");
        }
        PeerDescriptor peerDescriptor = null;
        try {
            System.out.println("Creating PeerDescriptor using port: " + enterpriseService.getServicePort() + "::" + n2 + " service type: " + enterpriseService.getClass());
            peerDescriptor = PeerDescriptor.createLocalPeerDescriptor((int)n2, (int)8);
        }
        catch (Throwable throwable) {
            ServicePeer.exit(1, "Could not create peer descriptor...");
        }
        ServicePeer servicePeer = null;
        try {
            System.out.println("Registering the service " + enterpriseService.getServiceName() + "...");
            System.out.println(peerDescriptor.getPort() + ":" + peerDescriptor.getTypeAsString());
            System.out.println((Object)agentPeerConfig.getMode());
            servicePeer = new ServicePeer(peerDescriptor, agentPeerConfig);
            servicePeer.setService(enterpriseService);
        }
        catch (Throwable throwable) {
            ServicePeer.exit(2, "Unable to Register the " + enterpriseService.getServiceName() + " service peer.", throwable);
        }
        try {
            System.out.println("Starting the service " + enterpriseService.getServiceName() + "...");
            servicePeer.startup();
        }
        catch (Throwable throwable) {
            ServicePeer.exit(2, "Unable to start the " + enterpriseService.getServiceName() + " service peer.", throwable);
        }
        try {
            PeerDescriptor peerDescriptor2 = null;
            if (enterpriseService.getLocalService()) {
                peerDescriptor2 = PeerDescriptor.createLocalPeerDescriptor((int)n, (int)6);
            } else {
                peerDescriptor2 = new PeerDescriptor();
                peerDescriptor2.setPort(n);
                peerDescriptor2.setType(6);
                peerDescriptor2.addAddress(string4);
                if (enterpriseService instanceof StandbyChecker) {
                    ((StandbyChecker)enterpriseService).setAdminPwd(string5);
                    ((StandbyChecker)enterpriseService).setRelMod(servicePeer.getRelMod().toString());
                    ((StandbyChecker)enterpriseService).setServicePeer(servicePeer);
                    ((StandbyChecker)enterpriseService).setLocalServerPort(localServerPort);
                }
            }
            servicePeer.setMaster(peerDescriptor2);
            servicePeer.setMaster(peerDescriptor2);
            System.out.println("Connecting " + enterpriseService.getServiceName() + " to " + peerDescriptor2.findName() + "...");
            do {
                if ((serverPeerID = servicePeer.connectToPeer(peerDescriptor2, (Serializable)((Object)creds))) != null) continue;
                System.out.println("Waiting to connect " + enterpriseService.getServiceName() + " to " + peerDescriptor2.findName() + "...");
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            } while (serverPeerID == null);
            enterpriseService.registerServiceToServerPeer(serverPeerID);
            if (serverPeerID.getPeerDescriptor().getType() != 6) {
                ServicePeer.exit(3, "Unable to connect to the Server.  Service " + enterpriseService.getServiceName() + " can only be started when Enterprise Server is running.");
            }
            System.out.println("Connected " + enterpriseService.getServiceName() + " to PEERID " + serverPeerID.toString());
            ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)servicePeer));
        }
        catch (Throwable throwable) {
            ServicePeer.exit(3, "Unable to connect to the Server.", throwable);
        }
    }

    private static String getAgentPeerConfigPath() {
        String string;
        String string2 = System.getenv("SERVER_CONFIG_PATH");
        if (string2 == null || string2.trim().length() < 1) {
            string2 = SERVER_CONFIG_PATH;
        }
        if ((string = System.getenv("SERVER_CONFIG_FILE")) == null || string.trim().length() < 1) {
            string = SERVER_CONFIG_FILE;
        }
        return string2 + File.separator + string;
    }

    private static AgentPeerConfig getServerConfig(EnterpriseService enterpriseService, int n) {
        Object object;
        String string = ServicePeer.getAgentPeerConfigPath();
        System.out.println("Service Peer is loading config file: " + string);
        AgentPeerConfig agentPeerConfig = null;
        File file = new File(string);
        if (file.exists()) {
            try {
                object = XMLUtil.loadXML((String)file.getAbsolutePath());
                agentPeerConfig = (AgentPeerConfig)((Object)XMLReflector.readObject((Document)object));
                localServerPort = agentPeerConfig.getListenPort();
            }
            catch (Throwable throwable) {
                String string2 = "Error loading configuration file: " + file.getAbsolutePath();
                File file2 = new File("report_runner_error.log");
                try {
                    FileWriter fileWriter = new FileWriter(file2);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string2);
                    bufferedWriter.write("\n");
                    bufferedWriter.write("Path is: " + file.getPath());
                    bufferedWriter.write("\n");
                    bufferedWriter.write("Config Path: " + string);
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(1);
            }
        } else {
            object = enterpriseService.getServiceLogFileName();
            File file3 = new File((String)object);
            String string3 = "Configuration file does not exist: " + file.getAbsolutePath();
            try {
                FileWriter fileWriter = new FileWriter(file3);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(string3);
                bufferedWriter.write("\n");
                bufferedWriter.write("Path is: " + file.getPath());
                bufferedWriter.write("\n");
                bufferedWriter.write("Config Path: " + string);
                bufferedWriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ServicePeer.exit(1, string3);
        }
        agentPeerConfig.setMode(AgentPeerConfig.AgentMode.SERVICE);
        if (enterpriseService instanceof ReportRunner) {
            agentPeerConfig.setServiceType(AgentPeerConfig.ServiceType.REPORTRUNNER);
        }
        agentPeerConfig.setListenPort(-1235);
        object = new PeerDescriptor();
        object.setType(6);
        object.setPort(n);
        agentPeerConfig.setMaster((PeerDescriptor)object);
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.rootLogger", (Object)"INFO,R"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.Append", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R", (Object)"org.apache.log4j.RollingFileAppender"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.layout.ConversionPattern", (Object)"%d{yyyy-MM-dd HH:mm:ss,SSS} %5p [%t] - %m%n"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.MaxBackupIndex", (Object)"5"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)SERVICE_LOG4J_FILENAME_KEY, (Object)enterpriseService.getServiceLogFileName()));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.MaxFileSize", (Object)"20480KB"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.layout", (Object)"org.apache.log4j.PatternLayout"));
        return agentPeerConfig;
    }

    private void setMaster(PeerDescriptor peerDescriptor) {
        master = peerDescriptor;
    }

    private static void exit(int n, String string) {
        ServicePeer.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        if (logger != null) {
            logger.error((Object)string, throwable);
        }
        System.exit(n);
    }

    public static void captureSignal(String string) {
        Signal signal = new Signal(string);
        SignalHandler signalHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                logger.debug((Object)("I sensed a tremor in the force...  Named: " + signal.getName()));
            }
        };
        Signal.handle(signal, signalHandler);
    }

    private void startConnectionPool(AgentPeerConfig agentPeerConfig) {
        String string = ServicePeer.getRailsEnvironment();
        logger.debug((Object)("Starting Connection Pool . : " + string));
        this.jdbcSrvDesc = (JdbcServiceDescriptor)agentPeerConfig.getServiceDescriptor(string);
        if (this.jdbcSrvDesc == null) {
            String string2 = "The JdbcServiceDescriptor was not loaded for the " + string + " rails environment.";
            throw new RuntimeException(string2);
        }
        try {
            this.jdbcService = EnterpriseDatabase.start((JdbcServiceDescriptor)this.jdbcSrvDesc);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string3 = "Error starting JDBC connection pool.";
            logger.error((Object)string3, (Throwable)resourceUnavailableException);
            throw new RuntimeException(string3, resourceUnavailableException);
        }
    }

    private static String getRailsEnvironment() {
        String string = System.getenv("RAILS_ENV");
        if (string != null) {
            return string.toUpperCase();
        }
        return "DEVELOPMENT";
    }

    @Override
    protected void initLog4j() {
        Properties properties = this.config.getLog4jProperties();
        if (properties == null || properties.size() == 0) {
            System.out.println("Skipping init log4j...  no Props from you.");
            return;
        }
        Logger.getRootLogger().removeAllAppenders();
        PropertyConfigurator.configure((Properties)properties);
        Logger logger = Logger.getRootLogger();
        Enumeration enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof RollingFileAppender)) continue;
            RollingFileAppender rollingFileAppender = (RollingFileAppender)e;
            rollingFileAppender.rollOver();
        }
        ServicePeer.logger.info((Object)("Logging Configured . . . . : " + properties.getProperty(SERVICE_LOG4J_FILENAME_KEY)));
    }

    @Override
    protected String getHtmlSection(String string) {
        if ("general".equals(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.getHtmlSection(string));
            stringBuffer.append("<h2>Service Information:</h2>");
            stringBuffer.append("<table><tr><td><b>Service Name:</b></td><td>");
            stringBuffer.append(this.service.getServiceName());
            stringBuffer.append("</td></tr>");
            stringBuffer.append("<tr><td><b>Automate Schedule Server: </b><td>");
            stringBuffer.append(this.makeBasicLink(master));
            stringBuffer.append("</td></tr>");
            stringBuffer.append("<tr><td><b>JDBC Service Status:</b></td><td>");
            stringBuffer.append(Service.getStatusString((int)this.jdbcService.getStatus()));
            stringBuffer.append("</td></tr>");
            stringBuffer.append(this.service.getServiceStatistics());
            stringBuffer.append("</table>\n");
            stringBuffer.append("<br>");
            stringBuffer.append(this.service.getServiceInfo());
            return stringBuffer.toString();
        }
        if ("log".equals(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<h2>Log:</h2>\n");
            stringBuffer.append(ServicePeer.getLogTail((String)this.config.getLog4jProperties().getProperty(SERVICE_LOG4J_FILENAME_KEY), (int)5000));
            return stringBuffer.toString();
        }
        return super.getHtmlSection(string);
    }

    public PeerID getServerPeerID() {
        return serverPeerID;
    }

    private class ServicePeerListener
    implements SimpleEventListener {
        private ServicePeerListener() {
        }

        public void serviceEvent(GenericEvent genericEvent) {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("*** ServicePeer is processing Event: " + genericEvent.toString()));
                    logger.trace((Object)("Our Master Server is " + master.findName()));
                }
                if (genericEvent instanceof PeerDisconnectEvent) {
                    PeerDescriptor peerDescriptor;
                    if (serverPeerID == null) {
                        PeerID peerID = ((PeerDisconnectEvent)genericEvent).getPeerID();
                        PeerDescriptor peerDescriptor2 = peerID.getPeerDescriptor();
                        logger.debug((Object)("We received, but did not process the PeerDisconnectEvent " + genericEvent + " from PD " + peerDescriptor2.findName()));
                        return;
                    }
                    PeerID peerID = ((PeerDisconnectEvent)genericEvent).getPeerID();
                    if (peerID.equals((Object)serverPeerID)) {
                        ServicePeer.exit(4, "Enterprise Server " + serverPeerID.getPeerDescriptor().findName() + " is no longer available.");
                    }
                    if ((peerDescriptor = peerID.getPeerDescriptor()).getType() == 6) {
                        ServicePeer.exit(5, "Enterprise Server " + peerDescriptor + " is no longer available.  Service " + ServicePeer.this.service.getServiceName() + ".");
                    }
                    logger.debug((Object)("We received, but did not process the PeerDisconnectEvent " + genericEvent + " from PD " + peerDescriptor.findName()));
                } else if (genericEvent instanceof PeerConnectEvent) {
                    PeerDescriptor peerDescriptor;
                    PeerID peerID;
                    if (serverPeerID == null) {
                        peerID = ((PeerConnectEvent)genericEvent).getPeerID();
                        peerDescriptor = peerID.getPeerDescriptor();
                        logger.debug((Object)("Connected to peer " + peerDescriptor.findName()));
                        if (peerDescriptor.getType() == 6) {
                            serverPeerID = peerID;
                        } else {
                            logger.debug((Object)("Could not register to to peer " + peerDescriptor.findName()));
                            return;
                        }
                    }
                    peerID = (EnterpriseServerAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)serverPeerID, (String)"ENTERPRISE.EnterpriseServerAM");
                    ManagerRegistry.registerManager((IAbstractManager)peerID);
                    peerDescriptor = (SchedulerStatusAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)serverPeerID, (String)"ENTERPRISE.SchedulerStatusAM");
                    ManagerRegistry.registerManager((IAbstractManager)peerDescriptor);
                    AgentStatusAM agentStatusAM = (AgentStatusAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)serverPeerID, (String)"ENTERPRISE.AgentStatusAM");
                    ManagerRegistry.registerManager((IAbstractManager)agentStatusAM);
                    ServicePeer.this.setLoggingLevel(-1);
                    ServicePeer.this.setStartupComplete(true);
                    ServicePeer.this.service.startService();
                } else if (genericEvent instanceof PeerLoggingLevelUpdatedEvent) {
                    ServicePeer.this.setLoggingLevel(((PeerLoggingLevelUpdatedEvent)genericEvent).getLoggingLevel());
                    genericEvent.setServiced(true);
                }
            }
            catch (Throwable throwable) {
                System.out.println("Service Peer Error: ");
                Throwable throwable2 = null;
                for (Throwable throwable3 = throwable; throwable3 != null; throwable3 = throwable3.getCause()) {
                    System.out.println("\t" + throwable3.getClass().getName() + ": " + throwable3.getMessage());
                    throwable2 = throwable3;
                    if (throwable3.getCause() != null) continue;
                    StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
                    for (int i = 0; i < stackTraceElementArray.length; ++i) {
                        System.out.println("\t\t" + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + " [" + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber() + "]");
                    }
                }
                logger.error((Object)("Service Peer Error: " + throwable.getMessage()), throwable);
            }
        }
    }
}

