/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.EnterpriseGlobals;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import junit.framework.TestCase;

public class AgentPeerTest
extends TestCase {
    AgentPeer peer;
    AgentPeerConfig config;
    PeerDescriptor desc;

    protected void setUp() throws Exception {
        super.setUp();
        this.desc = new PeerDescriptor("192.168.1.90", AgentPeer.DEFAULT_SERVER_PORT, 4, "Windows XP");
        this.config = AgentPeerConfig.getDefaultAgentPeer();
        this.peer = new AgentPeer(this.desc, this.config);
        this.peer.startup();
    }

    protected void tearDown() throws Exception {
        this.peer.shutdown();
        this.peer = null;
        this.config = null;
        this.desc = null;
        super.tearDown();
    }

    public void testGetRelMod() throws Exception {
        AgentPeerTest.assertEquals((Object)EnterpriseGlobals.PRODUCT_RELMOD, (Object)this.peer.getRelMod());
    }

    public void testGetConnectedAgentsDoesNotIncludeItself() {
        PeerID[] peerIDArray = this.peer.getConnectedAgents();
        if (peerIDArray.length > 0) {
            for (PeerID peerID : peerIDArray) {
                if (!peerID.equals((Object)this.peer.getRemotePeerID())) continue;
                AgentPeerTest.fail((String)"getConnectedAgents() included itself");
            }
        }
    }

    public void testGetAgentConfig() {
        AgentPeerConfig agentPeerConfig = this.peer.getAgentConfig();
        AgentPeerTest.assertEquals((Object)((Object)this.config), (Object)((Object)agentPeerConfig));
    }

    public void testIsServer() {
        AgentPeerTest.assertTrue((boolean)this.peer.isServer());
    }

    public void testIsClient() {
        AgentPeerTest.assertFalse((boolean)this.peer.isClient());
    }
}

