/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.dm.CommonMRHelper;
import com.helpsystems.common.core.dm.SystemInformationDM;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SystemNameUtil {
    private static final Logger logger = Logger.getLogger(SystemNameUtil.class);
    private static final HashMap<BasicIdentifier, String> nameMap = new HashMap();

    private SystemNameUtil() {
    }

    public static void clearCache() {
        nameMap.clear();
    }

    public static String getSystemName(BasicIdentifier basicIdentifier) {
        String string = null;
        if (basicIdentifier != null && (string = nameMap.get(basicIdentifier)) == null) {
            try {
                SystemInformationDM systemInformationDM = CommonMRHelper.getSystemInformationDM(basicIdentifier);
                if (systemInformationDM != null) {
                    string = systemInformationDM.getSystemName();
                    nameMap.put(basicIdentifier, string);
                }
            }
            catch (Exception exception) {
                logger.debug((Object)"Error getting system name.", (Throwable)exception);
            }
        }
        return string;
    }
}

