/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MorphClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(MorphClassLoader.class);
    private HashMap<String, Class> cacheMap = new HashMap();
    private byte[] targetClass;
    private int classnameIndex;
    private String originalName;
    private String originalPackage;

    public MorphClassLoader(String string) throws IOException {
        super(MorphClassLoader.class.getClassLoader());
        int n;
        String string2 = string.replace('.', '/');
        String string3 = string2 + ".class";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string3);
        if (inputStream == null) {
            throw new IOException("Unable to find resource " + string2);
        }
        this.originalPackage = this.originalName = string2;
        int n2 = this.originalPackage.lastIndexOf("/");
        this.originalPackage = n2 > -1 ? this.originalPackage.substring(0, n2) : "";
        byte[] byArray = new byte[50000];
        int n3 = 0;
        while ((n = inputStream.read(byArray, n3, byArray.length - n3)) != -1) {
            n3 += n;
        }
        this.targetClass = new byte[n3];
        System.arraycopy(byArray, 0, this.targetClass, 0, n3);
        byte[] byArray2 = string2.getBytes();
        for (int i = 0; i < this.targetClass.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < byArray2.length; ++j) {
                if (this.targetClass[i + j] == byArray2[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.classnameIndex = i;
        }
    }

    public synchronized Class buildClass(String string) {
        String string2 = this.originalPackage != null && this.originalPackage.length() > 0 ? this.originalPackage + "/" + this.cleanName(string) : string;
        String string3 = string2;
        StringBuffer stringBuffer = new StringBuffer(string3);
        String string4 = stringBuffer.reverse().toString();
        Class<?> clazz = this.cacheMap.get(string4);
        if (clazz != null) {
            return clazz;
        }
        logger.trace((Object)("MorphClassLoader building class: " + string3));
        int n = string3.length() - this.originalName.length();
        byte[] byArray = new byte[this.targetClass.length + n];
        byte[] byArray2 = string3.getBytes();
        System.arraycopy(this.targetClass, 0, byArray, 0, this.classnameIndex);
        byArray[this.classnameIndex - 1] = (byte)string3.length();
        System.arraycopy(byArray2, 0, byArray, this.classnameIndex, byArray2.length);
        int n2 = this.classnameIndex + this.originalName.length();
        int n3 = this.targetClass.length - n2;
        int n4 = this.classnameIndex + string3.length();
        System.arraycopy(this.targetClass, n2, byArray, n4, n3);
        String string5 = string3.replace('/', '.');
        clazz = this.defineClass(string5, byArray, 0, byArray.length);
        this.cacheMap.put(string4, clazz);
        return clazz;
    }

    private String cleanName(String string) {
        String string2 = string;
        if (string2.length() > 250) {
            string2 = string2.substring(0, 250);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(c)) {
                    c = '_';
                }
            } else if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

