/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.Comparator;

public abstract class GenericComparator
implements Comparator {
    private SortField sort;
    private boolean caseSensitive;
    private boolean numericSort;

    public GenericComparator(SortField sortField, boolean bl) {
        ValidationHelper.checkForNull("SortField", sortField);
        this.sort = sortField;
        this.caseSensitive = bl;
    }

    public SortField getSort() {
        return this.sort;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean getNumericSort() {
        return this.numericSort;
    }

    public void setNumericSort(boolean bl) {
        this.numericSort = bl;
    }

    public int compare(Object object, Object object2) {
        String string = null;
        String string2 = null;
        if (object != null) {
            string = this.getCompareValue(object, this.sort.getField());
        }
        if (object2 != null) {
            string2 = this.getCompareValue(object2, this.sort.getField());
        }
        int n = this.compareValues(string, string2, this.caseSensitive);
        if (this.sort.getDirection() == 1) {
            n = -1 * n;
        }
        return n;
    }

    private int compareValues(String string, String string2, boolean bl) {
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        if (this.numericSort) {
            try {
                double d = Double.parseDouble(string);
                double d2 = Double.parseDouble(string2);
                if (d == d2) {
                    return 0;
                }
                if (d < d2) {
                    return -1;
                }
                return 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!bl) {
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
        return string.compareTo(string2);
    }

    protected abstract String getCompareValue(Object var1, int var2);
}

