/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class DurableQueue {
    private static final Logger logger = Logger.getLogger(DurableQueue.class);
    private static final int PEEK = 1;
    private static final int POP = 2;
    private RandomAccessFile file;
    private String filename;
    private long offset;
    private boolean isClosed;
    private IOException threadThatClosedThisQueue;
    private static final byte[] HEADER = new byte[]{120, 121, 122};
    private boolean isEmpty;
    private Serializable peekCache;
    private int peekCacheObjectSize;
    private static final long EMPTY_OFFSET = HEADER.length + 8;

    public DurableQueue(String string) throws IOException {
        this.filename = string;
        this.file = new RandomAccessFile(string, "rw");
        this.isClosed = false;
        if (this.file.length() == 0L) {
            this.clear();
        } else {
            byte[] byArray = new byte[HEADER.length];
            this.file.readFully(byArray);
            if (!Arrays.equals(byArray, HEADER)) {
                this.file.close();
                this.file = null;
                throw new IOException("The file " + string + " is not a valid durable list file.");
            }
            this.offset = this.file.readLong();
            this.isEmpty = this.file.length() == EMPTY_OFFSET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.checkIfFileIsClosed();
            this.file.seek(0L);
            this.file.write(HEADER);
            this.offset = EMPTY_OFFSET;
            this.file.writeLong(this.offset);
            this.file.setLength(this.offset);
            this.isEmpty = true;
        }
    }

    private void checkIfFileIsClosed() throws IOException {
        if (this.isClosed) {
            IOException iOException = new IOException("The file has been closed.");
            iOException.initCause(this.threadThatClosedThisQueue);
        }
    }

    public void close() throws IOException {
        this.isClosed = true;
        this.file.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable dequeue(int n) throws IOException {
        this.checkIfFileIsClosed();
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException("The operation passed in is invalid.");
        }
        byte[] byArray = null;
        Object object = this.file;
        synchronized (object) {
            if (this.offset == this.file.length()) {
                this.isEmpty = true;
                return null;
            }
            if (this.peekCache == null) {
                this.file.seek(this.offset);
                this.peekCacheObjectSize = this.file.readInt();
                if (logger.isTraceEnabled() && this.peekCacheObjectSize > 100000) {
                    logger.trace((Object)("The next object on the queue '" + this.filename + "' is " + this.peekCacheObjectSize + " bytes long."));
                }
                byArray = new byte[this.peekCacheObjectSize];
                this.file.readFully(byArray);
            }
            if (n == 2) {
                this.offset = this.offset + 4L + (long)this.peekCacheObjectSize;
                this.updateOffset();
            }
        }
        object = this.peekCache;
        if (this.peekCache == null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                object = (Serializable)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                IOException iOException = new IOException("Unable to reconstruct an object from the queue's file.");
                iOException.initCause(classNotFoundException);
                throw iOException;
            }
        }
        this.peekCache = n == 1 ? object : null;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws IOException {
        int n = 0;
        this.checkIfFileIsClosed();
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            long l = this.offset;
            int n2 = 0;
            while (l < this.file.length()) {
                this.file.seek(l);
                n2 = this.file.readInt();
                l = l + (long)n2 + 4L;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Serializable> listQueue() throws IOException {
        this.checkIfFileIsClosed();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        byte[] byArray = null;
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            long l = this.offset;
            int n = 0;
            while (l < this.file.length()) {
                this.file.seek(l);
                n = this.file.readInt();
                if (logger.isTraceEnabled() && n > 100000) {
                    logger.trace((Object)("The next object on the queue '" + this.filename + "' is " + n + " bytes long."));
                }
                byArray = new byte[n];
                this.file.readFully(byArray);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                try {
                    arrayList.add((Serializable)objectInputStream.readObject());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    IOException iOException = new IOException("Unable to reconstruct an object from the queue's file.");
                    iOException.initCause(classNotFoundException);
                    throw iOException;
                }
                catch (EOFException eOFException) {
                    return arrayList;
                }
                catch (Throwable throwable) {
                    System.out.println("To err is human...");
                    throwable.printStackTrace();
                }
                l = l + (long)n + 4L;
            }
            return arrayList;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public Serializable peek() throws IOException {
        return this.dequeue(1);
    }

    public Serializable pop() throws IOException {
        return this.dequeue(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Serializable serializable) throws IOException {
        this.checkIfFileIsClosed();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.file.seek(this.file.length());
            this.file.writeInt(byArray.length);
            this.file.write(byArray);
            this.isEmpty = false;
        }
    }

    private void updateOffset() throws IOException {
        this.checkIfFileIsClosed();
        if (this.offset == this.file.length()) {
            this.offset = EMPTY_OFFSET;
            this.file.setLength(this.offset);
            this.isEmpty = true;
        }
        this.file.seek(HEADER.length);
        this.file.writeLong(this.offset);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "c:/test_DurableQueueData.dq";
        final DurableQueue durableQueue = new DurableQueue(string);
        durableQueue.clear();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setName("Pusher Thread");
                boolean bl = false;
                int n = 0;
                while (!bl) {
                    if (n >= Integer.MAX_VALUE) {
                        n = 0;
                    } else if (n > 0 && n % 10000 == 0) {
                        try {
                            Thread.sleep(22000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            System.exit(-2);
                        }
                    }
                    String string = "Test String " + n++;
                    try {
                        DurableQueue durableQueue2 = durableQueue;
                        synchronized (durableQueue2) {
                            durableQueue.push((Serializable)((Object)string));
                        }
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                }
                System.exit(-1);
            }
        };
        Thread thread2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setName("View Thread");
                boolean bl = false;
                while (!bl) {
                    Object var2_2 = null;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        System.exit(-2);
                    }
                    DurableQueue durableQueue2 = durableQueue;
                    synchronized (durableQueue2) {
                        try {
                            long l = System.nanoTime();
                            System.out.println("I count with dq.size() " + durableQueue.size() + " records...");
                            long l2 = System.nanoTime();
                            double d = (double)(l2 - l) / 1.0E9;
                            System.out.println("size time: " + d);
                            l = System.nanoTime();
                            ArrayList<Serializable> arrayList = durableQueue.listQueue();
                            System.out.println("I spy " + arrayList.size() + " records...");
                            l2 = System.nanoTime();
                            d = (double)(l2 - l) / 1.0E9;
                            System.out.println("listQueue time: " + d);
                        }
                        catch (EOFException eOFException) {
                        }
                        catch (IOException iOException) {
                            System.out.println("Failed to pop...");
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        };
        Thread thread3 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setName("Popper Thread");
                boolean bl = false;
                while (!bl) {
                    String string = null;
                    try {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            System.exit(-2);
                        }
                        DurableQueue durableQueue2 = durableQueue;
                        synchronized (durableQueue2) {
                            if (!durableQueue.isClosed && !durableQueue.isEmpty() && (string = (String)((Object)durableQueue.dequeue(2))) == null) {
                                System.out.println("Popped a null.");
                            }
                        }
                    }
                    catch (EOFException eOFException) {
                    }
                    catch (IOException iOException) {
                        System.out.println("Failed to pop...");
                        iOException.printStackTrace();
                    }
                }
                System.exit(-1);
            }
        };
        thread.start();
        thread3.start();
        thread2.start();
    }
}

