/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.reporting;

import com.helpsystems.common.core.busobj.CommonVersionedObject;

public class ReportField
extends CommonVersionedObject {
    private static final long serialVersionUID = -4885291249513251312L;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int FONTCOLOR_NORMAL = 0;
    public static final int FONTCOLOR_GREEN = 1;
    public static final int FONTCOLOR_RED = 2;
    private String value;
    private int alignment = 0;
    private boolean nonBreakingHTMLText = false;
    private int fontColor = 0;

    public ReportField() {
    }

    public ReportField(String string) {
        this.value = string;
    }

    public ReportField(String string, int n) {
        this.value = string;
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isNonBreakingHTMLText() {
        return this.nonBreakingHTMLText;
    }

    public void setNonBreakingHTMLText(boolean bl) {
        this.nonBreakingHTMLText = bl;
    }

    public String getValueAsMonoFontHTML(int n, String string) {
        String string2 = this.value != null ? this.value.trim() : "";
        if (string2.length() == 0) {
            string2 = "&nbsp;";
        } else if (string2.startsWith("<")) {
            if (string2.equals("< 0.01")) {
                string2 = "&lt;&nbsp;0.01";
            } else if (string2.equals("< -0.01")) {
                string2 = "&lt;&nbsp;-0.01";
            }
        }
        String string3 = "";
        if (string2.length() <= n) {
            string3 = string3 + string2;
        } else {
            int n2 = 0;
            int n3 = 0;
            String string4 = "";
            int n4 = 0;
            while (n4 * n < string2.length()) {
                n2 = n4 * n;
                n3 = n2 + n;
                string3 = n3 >= string2.length() ? string3 + string4 + string2.substring(n2) : string3 + string4 + string2.substring(n2, n3);
                string4 = "<br>";
                ++n4;
            }
        }
        string3 = this.nonBreakingHTMLText ? string3.replaceAll(" ", "&nbsp;") + string : string3 + string;
        string2 = string3;
        if (this.fontColor == 2) {
            return "<font color=red>" + string2 + "</font>";
        }
        if (this.fontColor == 1) {
            return "<font color=green>" + string2 + "</font>";
        }
        return string2;
    }

    public String getValueAsHTML() {
        String string = this.value != null ? this.value.trim() : "";
        if (string.length() == 0) {
            string = "&nbsp;";
        } else if (string.startsWith("<")) {
            if (string.equals("< 0.01")) {
                string = "&lt;&nbsp;0.01";
            } else if (string.equals("< -0.01")) {
                string = "&lt;&nbsp;-0.01";
            }
        }
        if (this.nonBreakingHTMLText) {
            string = string.replaceAll(" ", "&nbsp;");
        }
        if (this.fontColor == 2) {
            return "<font color=red>" + string + "</font>";
        }
        if (this.fontColor == 1) {
            return "<font color=green>" + string + "</font>";
        }
        return string;
    }

    public void setFonfColor(int n) {
        if (n != 0 && n != 2 && n != 1) {
            throw new IllegalArgumentException("Invalid font color: " + n);
        }
        this.fontColor = n;
    }

    public int getFontColor() {
        return this.fontColor;
    }
}

