/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

public class StatusMessage {
    public static final int SEV_INFO = 1;
    public static final int SEV_WARN = 2;
    public static final int SEV_ATTN = 3;
    public static final String DEFAULT_APPLICATION = "USERAPPL";
    public static final String DEFAULT_LIBRARY = "*DFT";
    private String application = "USERAPPL";
    private int severity = 1;
    private String dataRecord = "";
    private String library = "*DFT";

    public StatusMessage() {
    }

    public StatusMessage(String string, int n, String string2) {
        this.setApplication(string);
        this.setSeverity(n);
        this.setDataRecord(string2);
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String string) {
        this.application = this.cleanString(string, DEFAULT_APPLICATION).trim().toUpperCase();
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    public String getDataRecord() {
        return this.dataRecord;
    }

    public void setDataRecord(String string) {
        this.dataRecord = this.cleanString(string, "");
    }

    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String string) {
        this.library = this.cleanString(string, DEFAULT_LIBRARY).trim();
    }

    private String cleanString(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return string2;
        }
        return string;
    }

    public static String buildRBNSNDMSGCommand(StatusMessage statusMessage) {
        String string = statusMessage.getApplication().toUpperCase();
        return "RBNSNDSTS APPL('" + string + "') SEVERITY(" + StatusMessage.getSeverityString(statusMessage.getSeverity()) + ") RECORD('" + statusMessage.getDataRecord() + "') LIBRARY(" + statusMessage.getLibrary() + ")";
    }

    private static String getSeverityString(int n) {
        switch (n) {
            case 2: {
                return "WR";
            }
            case 3: {
                return "AT";
            }
        }
        return "IN";
    }
}

