/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.network.Packet;
import com.helpsystems.common.core.network.PacketDistribution;
import com.helpsystems.common.core.network.PacketElement;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.sql.Timestamp;
import junit.framework.TestCase;

public class PacketTest
extends TestCase {
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(Packet.class);
    private static final String TYPE_UPDATE_STRING = rbh.getText("update");
    private static final String TYPE_DELETE_STRING = rbh.getText("delete");
    private static final String TYPE_UNKNOWN_STRING = "!" + rbh.getText("unknown");
    private static final String STATUS_PENDING_STRING = rbh.getText("pending");
    private static final String STATUS_IN_PROCESS_STRING = rbh.getText("in_process");
    private static final String STATUS_COMPLETED_STRING = rbh.getText("completed");
    private static final String STATUS_FAILED_STRING = rbh.getText("failed");
    private static final String STATUS_UNKNOWN_STRING = rbh.getText("unknown");
    Packet packet;

    protected void setUp() throws Exception {
        super.setUp();
        this.packet = new Packet();
    }

    protected void tearDown() throws Exception {
        this.packet = null;
        super.tearDown();
    }

    public void testEquals() {
        PacketTest.assertFalse((boolean)this.packet.equals(null));
        PacketTest.assertFalse((boolean)this.packet.equals(new Object()));
        PacketTest.assertTrue((boolean)this.packet.equals(this.packet));
    }

    public void testGetProductHeaderOID() {
        this.packet.setProductHeaderOID(12345);
        PacketTest.assertEquals((int)12345, (int)this.packet.getProductHeaderOID());
    }

    public void testGetCreateDateTime() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.packet.setCreateDateTime(timestamp);
        PacketTest.assertEquals((Object)timestamp, (Object)this.packet.getCreateDateTime());
    }

    public void testGetCreator() {
        this.packet.setCreator("creator");
        PacketTest.assertEquals((String)"creator", (String)this.packet.getCreator());
    }

    public void testGetInstallDateTime() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.packet.setInstallDateTime(timestamp);
        PacketTest.assertEquals((Object)timestamp, (Object)this.packet.getInstallDateTime());
    }

    public void testGetType() {
        this.packet.setType(2);
        PacketTest.assertEquals((int)2, (int)this.packet.getType());
        this.packet.setType(1);
        PacketTest.assertEquals((int)1, (int)this.packet.getType());
        this.packet.setType(-28342938);
        PacketTest.assertEquals((int)-28342938, (int)this.packet.getType());
    }

    public void testGetTypeString() {
        this.packet.setType(2);
        PacketTest.assertEquals((String)TYPE_DELETE_STRING, (String)this.packet.getTypeString());
        this.packet.setType(1);
        PacketTest.assertEquals((String)TYPE_UPDATE_STRING, (String)this.packet.getTypeString());
        this.packet.setType(-28342938);
        PacketTest.assertEquals((String)TYPE_UNKNOWN_STRING, (String)this.packet.getTypeString());
    }

    public void testGetLegacy() {
        this.packet.setLegacy(true);
        PacketTest.assertTrue((boolean)this.packet.getLegacy());
        this.packet.setLegacy(false);
        PacketTest.assertFalse((boolean)this.packet.getLegacy());
    }

    public void testIsLegacy() {
        this.packet.setLegacy(true);
        PacketTest.assertTrue((boolean)this.packet.isLegacy());
        this.packet.setLegacy(false);
        PacketTest.assertFalse((boolean)this.packet.isLegacy());
    }

    public void testGetElements() {
        PacketElement[] packetElementArray = new PacketElement[]{new PacketElement()};
        this.packet.setElements(packetElementArray);
        PacketElement[] packetElementArray2 = this.packet.getElements();
        PacketTest.assertEquals((int)1, (int)packetElementArray2.length);
        PacketTest.assertEquals((Object)packetElementArray[0], (Object)packetElementArray2[0]);
    }

    public void testGetDistributions() {
        PacketDistribution[] packetDistributionArray = new PacketDistribution[]{new PacketDistribution()};
        this.packet.setDistributions(packetDistributionArray);
        PacketDistribution[] packetDistributionArray2 = this.packet.getDistributions();
        PacketTest.assertEquals((int)1, (int)packetDistributionArray2.length);
        PacketTest.assertEquals((Object)packetDistributionArray[0], (Object)packetDistributionArray2[0]);
    }

    public void testGetOID() {
        PacketTest.assertEquals((int)0, (int)this.packet.getOID());
        this.packet.setOID(12394823);
        PacketTest.assertEquals((int)12394823, (int)this.packet.getOID());
    }

    public void testGetDescription() {
        this.packet.setDescription("description");
        PacketTest.assertEquals((String)"description", (String)this.packet.getDescription());
    }

    public void testGetStatusText() {
        PacketTest.assertEquals((String)STATUS_PENDING_STRING, (String)Packet.getStatusText(1));
        PacketTest.assertEquals((String)STATUS_IN_PROCESS_STRING, (String)Packet.getStatusText(2));
        PacketTest.assertEquals((String)STATUS_COMPLETED_STRING, (String)Packet.getStatusText(3));
        PacketTest.assertEquals((String)STATUS_FAILED_STRING, (String)Packet.getStatusText(4));
        PacketTest.assertEquals((String)STATUS_UNKNOWN_STRING, (String)Packet.getStatusText(-99));
        try {
            Packet.getStatusText(-2934823);
            PacketTest.fail((String)"Packet.getStatusText(int) accepted an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

