/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.network.AbstractBusinessObject;
import com.helpsystems.common.core.network.ObjectID;
import com.helpsystems.common.core.network.PacketDistribution;
import com.helpsystems.common.core.network.PacketElement;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import java.sql.Timestamp;

public class Packet
extends AbstractBusinessObject {
    private static final long serialVersionUID = -6604978661459545631L;
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(Packet.class);
    public static final int CREATOR_MAX_LENGTH = 20;
    public static final int DESCRIPTION_MAX_LENGTH = 50;
    public static final int TYPE_UPDATE = 1;
    public static final int TYPE_DELETE = 2;
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_IN_PROCESS = 2;
    public static final int STATUS_COMPLETED = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_UNKNOWN = -99;
    private static final String TYPE_UPDATE_STRING = rbh.getText("update");
    private static final String TYPE_DELETE_STRING = rbh.getText("delete");
    private static final String TYPE_UNKNOWN_STRING = "!" + rbh.getText("unknown");
    private static final String STATUS_PENDING_STRING = rbh.getText("pending");
    private static final String STATUS_IN_PROCESS_STRING = rbh.getText("in_process");
    private static final String STATUS_COMPLETED_STRING = rbh.getText("completed");
    private static final String STATUS_FAILED_STRING = rbh.getText("failed");
    private static final String STATUS_UNKNOWN_STRING = rbh.getText("unknown");
    private int productHeaderOID;
    private Timestamp createDateTime;
    private String creator;
    private Timestamp installDateTime;
    private int type;
    private boolean legacy;
    private PacketElement[] elements;
    private PacketDistribution[] distributions;

    public int getProductHeaderOID() {
        return this.productHeaderOID;
    }

    public void setProductHeaderOID(int n) {
        this.productHeaderOID = n;
    }

    public Timestamp getCreateDateTime() {
        return this.createDateTime;
    }

    public void setCreateDateTime(Timestamp timestamp) {
        this.createDateTime = timestamp;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        ValidationHelper.checkForBlankIgnoreNull("Creator", string);
        ValidationHelper.validateLength("Creator", 20, string);
        this.creator = string;
    }

    public Timestamp getInstallDateTime() {
        return this.installDateTime;
    }

    public void setInstallDateTime(Timestamp timestamp) {
        this.installDateTime = timestamp;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        switch (this.type) {
            case 1: {
                return TYPE_UPDATE_STRING;
            }
            case 2: {
                return TYPE_DELETE_STRING;
            }
        }
        return TYPE_UNKNOWN_STRING;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean getLegacy() {
        return this.legacy;
    }

    public boolean isLegacy() {
        return this.getLegacy();
    }

    public void setLegacy(boolean bl) {
        this.legacy = bl;
    }

    public PacketElement[] getElements() {
        return this.elements;
    }

    public void setElements(PacketElement[] packetElementArray) {
        this.elements = packetElementArray;
    }

    public PacketDistribution[] getDistributions() {
        return this.distributions;
    }

    public void setDistributions(PacketDistribution[] packetDistributionArray) {
        this.distributions = packetDistributionArray;
    }

    public int getOID() {
        BasicIdentifier basicIdentifier = this.getIdentifier();
        if (basicIdentifier != null && basicIdentifier instanceof ObjectID) {
            return ((ObjectID)basicIdentifier).getObjectID();
        }
        return 0;
    }

    public void setOID(int n) {
        this.setIdentifier(new ObjectID(n));
    }

    @Override
    public void setDescription(String string) {
        ValidationHelper.checkForBlankIgnoreNull("Description", string);
        ValidationHelper.validateLength("Description", 50, string);
        super.setDescription(string);
    }

    public static String getStatusText(int n) {
        switch (n) {
            case 1: {
                return STATUS_PENDING_STRING;
            }
            case 2: {
                return STATUS_IN_PROCESS_STRING;
            }
            case 3: {
                return STATUS_COMPLETED_STRING;
            }
            case 4: {
                return STATUS_FAILED_STRING;
            }
            case -99: {
                return STATUS_UNKNOWN_STRING;
            }
        }
        throw new IllegalArgumentException("Not a valid packet status! (" + n + ")");
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Packet packet = (Packet)object;
        return super.equals(object) && Equal.isEqual(this.createDateTime, packet.createDateTime) && Equal.isEqual(this.creator, packet.creator) && Equal.isEqual(this.getDescription(), packet.getDescription()) && Equal.isEqual(this.installDateTime, packet.installDateTime) && Equal.isEqual(this.productHeaderOID, packet.productHeaderOID) && Equal.isEqual(this.type, packet.type) && Equal.isEqual(this.legacy, packet.legacy);
    }
}

